/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.AbstractConditionalDiscreteEmission;

public class ReferenceSequenceDiscreteEmission
extends AbstractConditionalDiscreteEmission {
    private AlphabetContainer refCon;
    private int refIdx;

    private static final Sequence getReferenceSequence(Sequence seq) {
        return ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
    }

    public ReferenceSequenceDiscreteEmission(AlphabetContainer con, AlphabetContainer refCon, int refIdx, double ess) {
        this(con, refCon, refIdx, ReferenceSequenceDiscreteEmission.getHyperParams(ess, (int)refCon.getAlphabetLengthAt(refIdx), (int)con.getAlphabetLengthAt(0)));
    }

    public ReferenceSequenceDiscreteEmission(AlphabetContainer con, AlphabetContainer refCon, int refIdx, double ess, double[][] initHyperParams) {
        this(con, refCon, refIdx, ReferenceSequenceDiscreteEmission.getHyperParams(ess, (int)refCon.getAlphabetLengthAt(refIdx), (int)con.getAlphabetLengthAt(0)), initHyperParams);
    }

    public ReferenceSequenceDiscreteEmission(AlphabetContainer con, AlphabetContainer refCon, int refIdx, double[][] hyperParams) throws IllegalArgumentException {
        super(con, hyperParams);
        if (refCon.getAlphabetLengthAt(refIdx) != (double)hyperParams.length) {
            throw new IllegalArgumentException("Hyper-parameters do not match length of alphabet");
        }
        this.refCon = refCon;
        this.refIdx = refIdx;
    }

    public ReferenceSequenceDiscreteEmission(AlphabetContainer con, AlphabetContainer refCon, int refIdx, double[][] hyperParams, double[][] initHyperParams) throws IllegalArgumentException {
        super(con, hyperParams, initHyperParams);
        if (refCon.getAlphabetLengthAt(refIdx) != (double)hyperParams.length) {
            throw new IllegalArgumentException("Hyper-parameters do not match length of alphabet");
        }
        this.refCon = refCon;
        this.refIdx = refIdx;
    }

    public ReferenceSequenceDiscreteEmission(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected int getConditionIndex(boolean forward, int seqPos, Sequence seq) {
        Sequence ref = ReferenceSequenceDiscreteEmission.getReferenceSequence(seq);
        if (this.refIdx < ref.getLength()) {
            return ref.discreteVal(this.refIdx);
        }
        return -1;
    }

    @Override
    public String toString() {
        String res = "";
        DiscreteAlphabet abc = (DiscreteAlphabet)this.con.getAlphabetAt(0);
        DiscreteAlphabet abc2 = (DiscreteAlphabet)this.refCon.getAlphabetAt(0);
        int i = 0;
        while (i < this.probs.length) {
            int j = 0;
            while (j < this.probs[i].length) {
                res = String.valueOf(res) + "P(X=" + abc.getSymbolAt(j) + " | " + abc2.getSymbolAt(i) + ") = " + this.probs[i][j] + "\t";
                ++j;
            }
            res = String.valueOf(res) + "\n";
            ++i;
        }
        return res;
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.refCon, "refCon");
        XMLParser.appendObjectWithTags(xml, this.refIdx, "refIdx");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.refCon = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "refCon");
        this.refIdx = XMLParser.extractObjectForTags(xml, "refIdx", Integer.TYPE);
    }
}

