/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

public class Normalisation {
    public static double getLogSum(double ... lnVal) {
        return Normalisation.getLogSum(0, lnVal.length, lnVal);
    }

    public static double getLogSum(int start, int end, double ... lnVal) {
        double offset = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        int i = start;
        while (i < end) {
            offset = Math.max(offset, lnVal[i]);
            ++i;
        }
        if (Double.isInfinite(offset)) {
            return Double.NEGATIVE_INFINITY;
        }
        i = start;
        while (i < end) {
            sum += Math.exp(lnVal[i] - offset);
            ++i;
        }
        return offset + Math.log(sum);
    }

    public static double logSumNormalisation(double[] d) {
        return Normalisation.logSumNormalisation(d, 0, d.length, d, 0);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD) {
        return Normalisation.logSumNormalisation(d, startD, endD, d, startD);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double[] secondValues) {
        return Normalisation.logSumNormalisation(d, startD, endD, secondValues, d, startD);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double[] dest, int startDest) {
        return Normalisation.logSumNormalisation(d, startD, endD, null, dest, startDest);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double[] secondValues, double[] dest, int startDest) {
        double offset = Double.NEGATIVE_INFINITY;
        int i = startD;
        while (i < endD) {
            offset = Math.max(offset, d[i]);
            ++i;
        }
        if (secondValues != null) {
            i = 0;
            while (i < secondValues.length) {
                offset = Math.max(offset, secondValues[i]);
                ++i;
            }
        }
        return Normalisation.logSumNormalisation(d, startD, endD, offset, secondValues, dest, startDest);
    }

    public static double logSumNormalisation(double[] d, double offset) {
        return Normalisation.logSumNormalisation(d, 0, d.length, offset, d, 0);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double offset, double[] dest, int startDest) {
        return Normalisation.logSumNormalisation(d, startD, endD, offset, null, dest, startDest);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double offset, double[] secondValues, double[] dest, int startDest) {
        double sum = 0.0;
        int i = 0;
        int l = endD - startD;
        while (i < l) {
            dest[startDest + i] = Math.exp(d[startD + i] - offset);
            sum += dest[startDest + i];
            ++i;
        }
        if (secondValues != null) {
            i = 0;
            while (i < secondValues.length) {
                secondValues[i] = Math.exp(secondValues[i] - offset);
                sum += secondValues[i];
                ++i;
            }
        }
        if (sum != 1.0) {
            Normalisation.normalisation(dest, sum, startDest, startDest + l);
            if (secondValues != null) {
                Normalisation.normalisation(secondValues, sum);
            }
        }
        return offset + Math.log(sum);
    }

    public static double sumNormalisation(double[] d) {
        return Normalisation.sumNormalisation(d, d, 0);
    }

    public static double sumNormalisation(double[] d, double[] dest, int start) {
        double sum = d[0];
        int i = 1;
        while (i < d.length) {
            sum += d[i];
            ++i;
        }
        Normalisation.normalisation(d, sum, dest, start);
        return sum;
    }

    public static void normalisation(double[] d, double v) {
        Normalisation.normalisation(d, v, d, 0);
    }

    public static void normalisation(double[] d, double v, double[] dest, int start) {
        int i = 0;
        while (i < d.length) {
            dest[start] = d[i] / v;
            ++i;
            ++start;
        }
    }

    public static void normalisation(double[] d, double v, int start, int end) {
        while (start < end) {
            int n = start++;
            d[n] = d[n] / v;
        }
    }
}

