/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

public class StatisticalTest {
    public static double getGeneralizedDivergence(double[][] p, double[][] q, double epsilon) throws IllegalArgumentException {
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("epsilon has to be positive");
        }
        int i = 0;
        int length1 = p.length;
        int length2 = p[0].length;
        if (q.length != length1) {
            throw new IllegalArgumentException("The matrices have to have same dimension (" + length1 + " x " + length2 + ").");
        }
        double res = 0.0;
        if (epsilon == 1.0) {
            while (i < length1) {
                if (p[i].length != length2 || q[i].length != length2) {
                    throw new IllegalArgumentException("The matrices have to have same dimension (" + length1 + " x " + length2 + ").");
                }
                int j = 0;
                while (j < length2) {
                    if (p[i][j] != 0.0) {
                        res += p[i][j] * Math.log(p[i][j] / q[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            res *= 2.0;
        } else {
            double e = epsilon - 1.0;
            while (i < length1) {
                if (p[i].length != length2 || q[i].length != length2) {
                    throw new IllegalArgumentException("The matrices have to have same dimension (" + length1 + " x " + length2 + ").");
                }
                int j = 0;
                while (j < length2) {
                    res += p[i][j] * Math.pow(p[i][j] / q[i][j], e);
                    ++j;
                }
                ++i;
            }
            res = (res - 1.0) / (epsilon * e / 2.0);
        }
        return res;
    }

    public static double getGeneralizedDivergence(double[][] p, double[] r, double[] s, double epsilon) {
        return StatisticalTest.getGeneralizedDivergence(p, StatisticalTest.getJointDistribution(r, s), epsilon);
    }

    public static double getGeneralizedDivergence(double[][] p, double epsilon) {
        double[][] marginal = StatisticalTest.getMarginalDistributions(p);
        return StatisticalTest.getGeneralizedDivergence(p, marginal[0], marginal[1], epsilon);
    }

    private static double[][] getMarginalDistributions(double[][] p) {
        double[][] marginal = new double[][]{new double[p.length], new double[p[0].length]};
        int i = 0;
        while (i < marginal[0].length) {
            int j = 0;
            while (j < marginal[1].length) {
                double[] dArray = marginal[0];
                int n = i;
                dArray[n] = dArray[n] + p[i][j];
                double[] dArray2 = marginal[1];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + p[i][j];
                ++j;
            }
            ++i;
        }
        return marginal;
    }

    private static double[][] getJointDistribution(double[] r, double[] s) {
        double[][] q = new double[r.length][s.length];
        int i = 0;
        while (i < r.length) {
            int j = 0;
            while (j < s.length) {
                q[i][j] = r[i] * s[j];
                ++j;
            }
            ++i;
        }
        return q;
    }
}

