/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

public class RadicalInverse {
    private static final int NP = 168;
    private static final int PLIM = 1000;
    private static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997};
    private static final int NRILIM = 1000;
    private int b;
    private double invb;
    private double logb;
    private int JMAX;
    private int co = 0;
    private double xx;
    private long ix;

    public RadicalInverse(int b, double x0) {
        this.b = b;
        this.invb = 1.0 / (double)b;
        this.logb = Math.log(b);
        this.JMAX = (int)(22.18070977791825 / this.logb);
        this.xx = x0;
        this.ix = this.computeI(x0);
    }

    private long computeI(double x) {
        int j;
        int[] digits = new int[this.JMAX];
        for (j = 0; j < this.JMAX && x > 5.0E-16; x -= (double)digits[j], ++j) {
            digits[j] = (int)(x *= (double)this.b);
        }
        long i = 0L;
        for (j = this.JMAX - 1; j >= 0; --j) {
            i = i * (long)this.b + (long)digits[j];
        }
        return i;
    }

    public static int[] getPrimes(int n) {
        int i;
        int[] prime = new int[n];
        int n1 = Math.min(168, n);
        for (i = 0; i < n1; ++i) {
            prime[i] = PRIMES[i];
        }
        if (168 < n) {
            i = 168;
            int candidate = 1001;
            while (i < n) {
                boolean moreTests;
                prime[i] = candidate;
                int j = 1;
                while ((moreTests = prime[j] <= candidate / prime[j]) && candidate % prime[j] > 0) {
                    ++j;
                }
                if (!moreTests) {
                    ++i;
                }
                candidate += 2;
            }
        }
        return prime;
    }

    public static double radicalInverse(int b, long i) {
        double radical;
        double digit = radical = 1.0 / (double)b;
        double inverse = 0.0;
        while (i > 0L) {
            inverse += digit * (double)(i % (long)b);
            digit *= radical;
            i /= (long)b;
        }
        return inverse;
    }

    public static double nextRadicalInverse(double invb, double x) {
        double ALMOST_ONE = 0.9999999999;
        double nextInverse = x + invb;
        if (nextInverse < 0.9999999999) {
            return nextInverse;
        }
        double digit1 = invb;
        double digit2 = invb * invb;
        while (x + digit2 >= 0.9999999999) {
            digit1 = digit2;
            digit2 *= invb;
        }
        return x + (digit1 - 1.0) + digit2;
    }

    public double nextRadicalInverse() {
        ++this.co;
        if (this.co >= 1000) {
            this.co = 0;
            this.ix += 1000L;
            this.xx = RadicalInverse.radicalInverse(this.b, this.ix);
            return this.xx;
        }
        double ALMOST_ONE = 0.9999999999;
        double nextInverse = this.xx + this.invb;
        if (nextInverse < 0.9999999999) {
            this.xx = nextInverse;
            return this.xx;
        }
        double digit1 = this.invb;
        double digit2 = this.invb * this.invb;
        while (this.xx + digit2 >= 0.9999999999) {
            digit1 = digit2;
            digit2 *= this.invb;
        }
        this.xx += digit1 - 1.0 + digit2;
        return this.xx;
    }

    public static void reverseDigits(int k, int[] bdigits, int[] idigits) {
        for (int l = 0; l < k; ++l) {
            idigits[l] = bdigits[k - l];
        }
    }

    public static int integerRadicalInverse(int b, int i) {
        int inverse = 0;
        while (i > 0) {
            inverse = inverse * b + i % b;
            i /= b;
        }
        return inverse;
    }

    public static int nextRadicalInverseDigits(int b, int k, int[] idigits) {
        int l;
        for (l = k - 1; l >= 0; --l) {
            if (idigits[l] != b - 1) {
                int n = l;
                idigits[n] = idigits[n] + 1;
                return k;
            }
            idigits[l] = 0;
        }
        if (l == 0) {
            idigits[k] = 1;
            return ++k;
        }
        return 0;
    }

    public static void getFaurePermutation(int b, int[] pi) {
        if (b == 2) {
            pi[0] = 0;
            pi[1] = 1;
        } else if ((b & 1) != 0) {
            int i;
            RadicalInverse.getFaurePermutation(--b, pi);
            for (i = 0; i < b; ++i) {
                if (pi[i] < b / 2) continue;
                int n = i;
                pi[n] = pi[n] + 1;
            }
            for (i = b; i > b / 2; --i) {
                pi[i] = pi[i - 1];
            }
            pi[b / 2] = b / 2;
        } else {
            RadicalInverse.getFaurePermutation(b /= 2, pi);
            for (int i = 0; i < b; ++i) {
                int n = i;
                pi[n] = pi[n] * 2;
                pi[i + b] = pi[i] + 1;
            }
        }
    }

    public static double permutedRadicalInverse(int b, int[] pi, int i) {
        double radical;
        double digit = radical = 1.0 / (double)b;
        double inverse = 0.0;
        while (i > 0) {
            inverse += digit * (double)pi[i % b];
            digit *= radical;
            i /= b;
        }
        return inverse;
    }
}

