/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.ClassificationRate;
import de.jstacs.classifiers.performanceMeasures.FalsePositiveRateForFixedSensitivity;
import de.jstacs.classifiers.performanceMeasures.MaximumCorrelationCoefficient;
import de.jstacs.classifiers.performanceMeasures.MaximumFMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PRCurve;
import de.jstacs.classifiers.performanceMeasures.PositivePredictiveValueForFixedSensitivity;
import de.jstacs.classifiers.performanceMeasures.ROCCurve;
import de.jstacs.classifiers.performanceMeasures.SensitivityForFixedSpecificity;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import java.util.LinkedList;

public class PerformanceMeasureParameterSet
extends ExpandableParameterSet {
    public PerformanceMeasureParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public PerformanceMeasureParameterSet() throws Exception {
        this(2);
    }

    public PerformanceMeasureParameterSet(int numClasses) throws Exception {
        this(numClasses, new AbstractPerformanceMeasure[0]);
    }

    private static int getNumberOfClasses(AbstractPerformanceMeasure[] measures) {
        int res = 0;
        int i = 0;
        while (i < measures.length) {
            int n = measures[i].getAllowedNumberOfClasses();
            if (res == 0) {
                if (n != 0) {
                    res = n;
                }
            } else if (n != res) {
                throw new IllegalArgumentException("The performance measures are defined for different number of classes.");
            }
            ++i;
        }
        return res;
    }

    public PerformanceMeasureParameterSet(AbstractPerformanceMeasure ... measures) throws Exception {
        this(PerformanceMeasureParameterSet.getNumberOfClasses(measures), measures);
    }

    private PerformanceMeasureParameterSet(int numClasses, AbstractPerformanceMeasure ... measures) throws Exception {
        this(numClasses, AbstractPerformanceMeasure.getCollectionOfAllMeasures(numClasses, false), measures);
    }

    private static ParameterSet[] getParameterSets(int numClasses, SelectionParameter selection, AbstractPerformanceMeasure ... measures) throws Exception {
        SimpleParameterSet template = new SimpleParameterSet(selection);
        int n = measures == null || measures.length == 0 ? 0 : measures.length;
        ParameterSet[] pars = new ParameterSet[Math.max(1, n)];
        pars[0] = template;
        int i = 0;
        while (i < n) {
            if (measures[i].getAllowedNumberOfClasses() != 0 && measures[i].getAllowedNumberOfClasses() != numClasses) {
                throw new Exception("Provided measure " + measures[i].getName() + " not allowed for " + numClasses + " classes.");
            }
            if (i != 0) {
                pars[i] = ((ParameterSet)template).clone();
            }
            ((SelectionParameter)pars[i].getParameterAt(0)).setValue(measures[i]);
            ++i;
        }
        return pars;
    }

    protected PerformanceMeasureParameterSet(int numClasses, SelectionParameter selection, AbstractPerformanceMeasure ... measures) throws Exception {
        super(PerformanceMeasureParameterSet.getParameterSets(numClasses, selection, measures), "Performance measures", "Performance measures for evaluating a classifier of " + numClasses + " classes");
    }

    public static NumericalPerformanceMeasureParameterSet createFilledParameters() throws Exception {
        return (NumericalPerformanceMeasureParameterSet)PerformanceMeasureParameterSet.createFilledParameters(true, 0.999, 0.95, 0.95, 1.0);
    }

    public static PerformanceMeasureParameterSet createFilledParameters(boolean numerical, double spForSn, double snForFPR, double snForPPV, double beta) throws Exception {
        PerformanceMeasureParameterSet res = numerical ? new NumericalPerformanceMeasureParameterSet(2) : new PerformanceMeasureParameterSet(2);
        res.setMeasure(new ClassificationRate());
        res.addMeasure(new SensitivityForFixedSpecificity(spForSn));
        res.addMeasure(new FalsePositiveRateForFixedSensitivity(snForFPR));
        res.addMeasure(new PositivePredictiveValueForFixedSensitivity(snForPPV));
        if (numerical) {
            res.addMeasure(new AucROC());
            res.addMeasure(new AucPR());
        } else {
            res.addMeasure(new ROCCurve());
            res.addMeasure(new PRCurve());
        }
        res.addMeasure(new MaximumCorrelationCoefficient());
        res.addMeasure(new MaximumFMeasure(beta));
        return res;
    }

    @Deprecated
    public void addMeasure(AbstractPerformanceMeasure measure) throws CloneNotSupportedException, SimpleParameter.IllegalValueException {
        this.addParameterToSet();
        this.setMeasure(measure);
    }

    protected void setMeasure(AbstractPerformanceMeasure measure) throws SimpleParameter.IllegalValueException {
        ParameterSetContainer cont = (ParameterSetContainer)this.parameters.get(this.parameters.size() - 1);
        SelectionParameter sel = (SelectionParameter)cont.getValue().getParameterAt(0);
        sel.setValue(measure);
    }

    public AbstractPerformanceMeasure removeMeasure(int index) {
        ParameterSetContainer cont = (ParameterSetContainer)this.parameters.remove(index);
        SelectionParameter cp = (SelectionParameter)cont.getValue().getParameterAt(0);
        return (AbstractPerformanceMeasure)cp.getValue();
    }

    public AbstractPerformanceMeasure[] removeMeasures(Class<? extends AbstractPerformanceMeasure> clazz) {
        LinkedList<AbstractPerformanceMeasure> list = new LinkedList<AbstractPerformanceMeasure>();
        int i = 0;
        while (i < this.parameters.size()) {
            if (((ParameterSet)((Parameter)this.parameters.get(i)).getValue()).getParameterAt(0).getValue().getClass().equals(clazz)) {
                list.add(this.removeMeasure(i));
                --i;
            }
            ++i;
        }
        return list.toArray(new AbstractPerformanceMeasure[0]);
    }

    public AbstractPerformanceMeasure[] removeMeasures(String name) {
        LinkedList<AbstractPerformanceMeasure> list = new LinkedList<AbstractPerformanceMeasure>();
        int i = 0;
        while (i < this.parameters.size()) {
            AbstractPerformanceMeasure meas = (AbstractPerformanceMeasure)((ParameterSet)((Parameter)this.parameters.get(i)).getValue()).getParameterAt(0).getValue();
            if (meas.getName().equals(name)) {
                list.add(this.removeMeasure(i));
                --i;
            }
            ++i;
        }
        return list.toArray(new AbstractPerformanceMeasure[0]);
    }

    public AbstractPerformanceMeasure[] getAllMeasures() {
        AbstractPerformanceMeasure[] measures = new AbstractPerformanceMeasure[this.parameters.size()];
        int i = 0;
        while (i < measures.length) {
            ParameterSetContainer cont = (ParameterSetContainer)this.parameters.get(i);
            SelectionParameter cp = (SelectionParameter)cont.getValue().getParameterAt(0);
            measures[i] = (AbstractPerformanceMeasure)cp.getValue();
            ++i;
        }
        return measures;
    }
}

