/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class GFFParser {
    public static void main(String[] args) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader("/Users/dev/Downloads/Galaxy43-[UCSC_Main_on_Human__knownGene_(genome)].gtf.txt"));
        GFFList list = GFFParser.parseGTF(read, null, null);
        list = list.getSubList("chr4");
        list = list.getSubList(GFFEntry.GFFType.exon);
        ArrayList<GFFEntry> ens = list.getEntriesOverlapping(196560);
        System.out.println(ens);
    }

    public static GFFList parse(String filename) throws IOException {
        int idx = filename.lastIndexOf(46);
        if (idx >= 0) {
            return GFFParser.parse(filename, filename.substring(idx + 1));
        }
        return GFFParser.parse(filename, null);
    }

    public static GFFList parse(String filename, String extension) throws IOException {
        if (extension == null || extension.equalsIgnoreCase("gff") || extension.equalsIgnoreCase("gff3")) {
            return GFFParser.parseGFF(filename);
        }
        if (extension.equalsIgnoreCase("gtf")) {
            return GFFParser.parseGTF(new BufferedReader(new FileReader(filename)), null, null);
        }
        return GFFParser.parseUCSCKnownGenesBED(new BufferedReader(new FileReader(filename)), null, null);
    }

    public static GFFList parseGFF(String filename) throws IOException {
        return GFFParser.parseGFF(filename, null, null);
    }

    public static GFFList parseGFF(String filename, DataSet data, String[] keys) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        return GFFParser.parseGFF(reader, data, keys);
    }

    public static GFFList parseGFF(BufferedReader reader) throws IOException {
        return GFFParser.parseGFF(reader, null, null);
    }

    public static GFFList parseGFF(BufferedReader reader, DataSet data, String[] keys) throws IOException {
        GFFList list = new GFFList(reader);
        if (data != null) {
            list.attachData(data, keys);
        }
        return list;
    }

    public static GFFList parseGTF(BufferedReader reader, DataSet data, String[] keys) throws IOException {
        LinkedList<GFFEntry> list = new LinkedList<GFFEntry>();
        String str = null;
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            int idx = str.lastIndexOf(9);
            String first = str.substring(0, idx);
            String second = str.substring(idx + 1);
            String[] parts = second.split(";");
            sb.delete(0, sb.length());
            int i = 0;
            while (i < parts.length) {
                parts[i] = parts[i].trim();
                if (parts[i].length() > 0) {
                    idx = parts[i].indexOf(32);
                    sb.append(parts[i].substring(0, idx));
                    sb.append("=");
                    sb.append(parts[i].substring(idx + 1));
                    if (i < parts.length - 1) {
                        sb.append(";");
                    }
                }
                ++i;
            }
            list.add(new GFFEntry(String.valueOf(first) + "\t" + sb.toString()));
        }
        GFFList gff = new GFFList(list);
        if (data != null) {
            gff.attachData(data, keys);
        }
        return gff;
    }

    public static GFFList parseUCSCKnownGenesBED(BufferedReader reader, DataSet data, String[] keys) throws IOException {
        ArrayList<GFFEntry> entries = new ArrayList<GFFEntry>();
        String str = null;
        while ((str = reader.readLine()) != null) {
            String[] parts = str.split("\t");
            String seqid = parts[0];
            int start = Integer.parseInt(parts[1]) + 1;
            int end = Integer.parseInt(parts[2]) + 1;
            String id = parts[3];
            double score = Double.parseDouble(parts[4]);
            parts[5] = parts[5].trim();
            StrandedLocatedSequenceAnnotationWithLength.Strand strand = parts[5].length() == 0 || parts[5].equals(".") ? StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN : (parts[5].equals("+") ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : (parts[5].equals("-") ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN));
            int numExons = Integer.parseInt(parts[9]);
            GFFEntry gene = new GFFEntry(seqid, "known_genes", GFFEntry.GFFType.gene.name(), start, end, score, strand, -1, "");
            gene.id = id;
            entries.add(gene);
            String[] lengthParts = parts[10].split(",");
            String[] startParts = parts[11].split(",");
            int i = 0;
            while (i < numExons) {
                int exStart = start + Integer.parseInt(startParts[i]);
                int exEnd = exStart + Integer.parseInt(lengthParts[i]);
                GFFEntry exon = new GFFEntry(seqid, "known_genes", GFFEntry.GFFType.exon.name(), exStart, exEnd, score, strand, -1, "");
                exon.parent = new LinkedList();
                exon.parent.add(gene);
                if (gene.children == null) {
                    gene.children = new LinkedList();
                }
                gene.children.add(exon);
                entries.add(exon);
                ++i;
            }
        }
        GFFList list = new GFFList(entries);
        if (data != null) {
            list.attachData(data, keys);
        }
        return list;
    }

    public static class GFFEntry {
        private String seqid;
        private String source;
        private String type;
        private GFFType parsedType;
        private int start;
        private int end;
        private String id;
        private double score;
        private StrandedLocatedSequenceAnnotationWithLength.Strand strand;
        private int phase;
        private HashMap<String, String> attributes;
        private LinkedList<GFFEntry> parent;
        private LinkedList<GFFEntry> children;

        public String getID() {
            return this.id;
        }

        private void parseParent(HashMap<String, GFFEntry> byID) {
            String parent = this.attributes.get("parent");
            if (parent != null) {
                this.parent = new LinkedList();
                String[] parents = parent.split(",");
                int i = 0;
                while (i < parents.length) {
                    GFFEntry par = byID.get(parents[i]);
                    this.parent.add(par);
                    if (par.children == null) {
                        par.children = new LinkedList();
                    }
                    par.children.add(this);
                    ++i;
                }
            }
        }

        public GFFEntry(String seqid, String source, String type, int start, int end, double score, StrandedLocatedSequenceAnnotationWithLength.Strand strand, int phase, String attributes) {
            this.seqid = seqid;
            this.source = source;
            this.type = type;
            this.parsedType = GFFType.fromString(type);
            this.start = start;
            this.end = end;
            this.score = score;
            this.strand = strand;
            this.phase = phase;
            this.parseAttributes(attributes);
        }

        private void setID() {
            this.id = this.attributes.get("id");
        }

        public GFFEntry(String line) {
            String[] parts = line.split("\t");
            this.seqid = parts[0];
            this.source = parts[1];
            this.type = parts[2];
            this.parsedType = GFFType.fromString(this.type);
            parts[3] = parts[3].trim();
            this.start = parts[3].length() > 0 && !parts[3].equals(".") ? Integer.parseInt(parts[3]) : -1;
            parts[4] = parts[4].trim();
            this.end = parts[4].length() > 0 && !parts[4].equals(".") ? Integer.parseInt(parts[4]) : -1;
            parts[5] = parts[5].trim();
            this.score = parts[5].length() > 0 && !parts[5].equals(".") ? Double.parseDouble(parts[5]) : Double.NaN;
            parts[6] = parts[6].trim();
            this.strand = parts[6].length() == 0 || parts[6].equals(".") ? StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN : (parts[6].equals("+") ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : (parts[6].equals("-") ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN));
            parts[7] = parts[7].trim();
            this.phase = parts[7].length() > 0 && !parts[7].equals(".") ? Integer.parseInt(parts[7]) : -1;
            this.parseAttributes(parts[8]);
        }

        private void parseAttributes(String attrs) {
            this.attributes = new HashMap();
            if (attrs == null || attrs.length() == 0) {
                return;
            }
            String[] parts = attrs.split(";");
            int i = 0;
            while (i < parts.length) {
                String[] temp = parts[i].split("=");
                this.attributes.put(temp[0].toLowerCase(), temp[1]);
                ++i;
            }
            this.setID();
        }

        private boolean hasAttribute(String key) {
            return this.attributes != null && this.attributes.get(key.toLowerCase()) != null;
        }

        private String getAttribute(String key) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(key.toLowerCase());
        }

        public String getSeqid() {
            return this.seqid;
        }

        public String getSource() {
            return this.source;
        }

        public String getType() {
            return this.type;
        }

        public GFFType getParsedType() {
            return this.parsedType;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public double getScore() {
            return this.score;
        }

        public StrandedLocatedSequenceAnnotationWithLength.Strand getStrand() {
            return this.strand;
        }

        public int getPhase() {
            return this.phase;
        }

        public HashMap<String, String> getAttributes() {
            return this.attributes;
        }

        public LinkedList<GFFEntry> getParents() {
            return this.parent;
        }

        public LinkedList<GFFEntry> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuffer str = new StringBuffer(this.type);
            if (this.id != null) {
                str.append(" ");
                str.append(this.id);
            }
            str.append(" (" + this.start + ", " + this.end + ")");
            if (this.parent != null && this.parent.size() > 0) {
                str.append(" of [" + this.parent.get(0));
                int i = 1;
                while (i < this.parent.size()) {
                    str.append(" and " + this.parent.get(i));
                    ++i;
                }
                str.append("]");
            }
            return str.toString();
        }

        public static enum GFFType {
            chromosome,
            gene,
            mRNA,
            protein,
            exon,
            five_prime_UTR,
            CDS,
            three_prime_UTR,
            other;


            public static GFFType fromString(String text) {
                if (text != null) {
                    GFFType[] gFFTypeArray = GFFType.values();
                    int n = gFFTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GFFType b = gFFTypeArray[n2];
                        if (text.equalsIgnoreCase(b.name())) {
                            return b;
                        }
                        ++n2;
                    }
                }
                return null;
            }
        }
    }

    private static class GFFEntryComparator
    implements Comparator<GFFEntry> {
        private static final GFFEntryComparator COMP = new GFFEntryComparator();

        private GFFEntryComparator() {
        }

        @Override
        public int compare(GFFEntry o1, GFFEntry o2) {
            int i = o1.seqid.compareTo(o2.seqid);
            if (i == 0) {
                int n = o1.start > o2.start ? 1 : (i = o1.start < o2.start ? -1 : 0);
            }
            if (i == 0) {
                i = o1.end > o2.end ? 1 : (o1.end < o2.end ? -1 : 0);
            }
            return i;
        }
    }

    public static class GFFList {
        private ArrayList<GFFEntry> entries;
        private HashMap<String, GFFEntry> byID;
        private HashMap<String, GFFList> bySeq;
        private HashMap<GFFEntry.GFFType, GFFList> byType;
        private HashMap<String, Sequence> data;

        public GFFList(Collection<GFFEntry> entries) {
            this.entries = new ArrayList();
            this.entries.addAll(entries);
            this.parse(true);
        }

        private GFFList(ArrayList<GFFEntry> entries) {
            this.entries = entries;
            this.parse(false);
        }

        public void attachData(DataSet data, String[] keys) {
            if (keys.length != data.getNumberOfElements()) {
                throw new IllegalArgumentException();
            }
            Iterator<String> it = this.bySeq.keySet().iterator();
            this.data = new HashMap();
            block0: while (it.hasNext()) {
                String str = it.next();
                int i = 0;
                while (i < keys.length) {
                    if (str.equals(keys[i])) {
                        this.data.put(keys[i], data.getElementAt(i));
                        if (this.bySeq.get((Object)keys[i]).data != null) continue block0;
                        this.bySeq.get(keys[i]).attachData(data, keys);
                        continue block0;
                    }
                    ++i;
                }
                throw new RuntimeException();
            }
            for (GFFEntry.GFFType type : this.byType.keySet()) {
                if (this.byType.get((Object)((Object)type)).data != null) continue;
                this.byType.get((Object)type).attachData(data, keys);
            }
        }

        public Sequence getSequenceFor(GFFEntry entry, int offleft, int offright) {
            Sequence seq = this.data.get(entry.getSeqid()).getSubSequence(entry.getStart() - offleft - 1, entry.getEnd() - entry.getStart() + 1 + offleft + offright);
            return seq;
        }

        private void parse(boolean parseParents) {
            GFFEntry en;
            HashMap bySeq = new HashMap();
            HashMap byType = new HashMap();
            this.byID = new HashMap();
            int i = 0;
            while (i < this.entries.size()) {
                en = this.entries.get(i);
                if (en.getID() != null) {
                    this.byID.put(en.getID(), en);
                }
                if (bySeq.get(en.getSeqid()) == null) {
                    bySeq.put(en.getSeqid(), new ArrayList());
                }
                ArrayList list = (ArrayList)bySeq.get(en.getSeqid());
                list.add(en);
                if (byType.get((Object)en.getParsedType()) == null) {
                    byType.put(en.getParsedType(), new ArrayList());
                }
                list = (ArrayList)byType.get((Object)en.getParsedType());
                list.add(en);
                ++i;
            }
            if (parseParents) {
                i = 0;
                while (i < this.entries.size()) {
                    en = this.entries.get(i);
                    en.parseParent(this.byID);
                    ++i;
                }
            }
            this.sort(bySeq);
            this.sort(byType);
            this.bySeq = new HashMap();
            this.byType = new HashMap();
            if (bySeq.keySet().size() > 1) {
                this.descend(bySeq, this.bySeq);
            } else {
                this.bySeq.put((String)bySeq.keySet().iterator().next(), this);
            }
            if (byType.keySet().size() > 1) {
                this.descend(byType, this.byType);
            } else {
                this.byType.put((GFFEntry.GFFType)((Object)byType.keySet().iterator().next()), this);
            }
        }

        private void descend(HashMap map, HashMap map2) {
            for (Object key : map.keySet()) {
                ArrayList en = (ArrayList)map.get(key);
                map2.put(key, new GFFList(en));
            }
        }

        private void sort(HashMap<? extends Object, ArrayList<GFFEntry>> bySeq2) {
            Iterator<? extends Object> it = bySeq2.keySet().iterator();
            while (it.hasNext()) {
                ArrayList<GFFEntry> en = bySeq2.get(it.next());
                GFFEntry[] ens = en.toArray(new GFFEntry[0]);
                Arrays.sort(ens, GFFEntryComparator.COMP);
                en.clear();
                int i = 0;
                while (i < ens.length) {
                    en.add(ens[i]);
                    ++i;
                }
            }
        }

        public GFFList(BufferedReader reader) throws IOException {
            String line;
            this.entries = new ArrayList();
            while ((line = reader.readLine()) != null) {
                this.entries.add(new GFFEntry(line));
            }
            this.parse(true);
        }

        public GFFList getSubList(String seqId) {
            return this.bySeq.get(seqId);
        }

        public GFFList getSubList(GFFEntry.GFFType type) {
            return this.byType.get((Object)type);
        }

        public ArrayList<GFFEntry> getEntriesBetween(int start, int end) {
            int idx;
            if (this.bySeq.keySet().size() > 1) {
                throw new RuntimeException("get sublist for seqid first");
            }
            ArrayList<GFFEntry> res = new ArrayList<GFFEntry>();
            int i = idx = this.binarySearch(this.entries, start);
            while (i < this.entries.size()) {
                GFFEntry en = this.entries.get(i);
                if (en.start > end) break;
                if (en.start >= start && en.end <= end) {
                    res.add(en);
                }
                ++i;
            }
            return res;
        }

        public ArrayList<GFFEntry> getEntriesOverlapping(int idx) {
            if (this.bySeq.keySet().size() > 1) {
                throw new RuntimeException("get sublist for seqid first");
            }
            int idx2 = this.binarySearch(this.entries, idx);
            ArrayList<GFFEntry> res = new ArrayList<GFFEntry>();
            int i = 0;
            while (i < idx2) {
                GFFEntry en = this.entries.get(i);
                if (en.start <= idx && en.end >= idx) {
                    res.add(en);
                }
                ++i;
            }
            return res;
        }

        private int binarySearch(ArrayList<GFFEntry> en, int idx) {
            return this.binarySearch(en, idx, 0, en.size());
        }

        private int binarySearch(ArrayList<GFFEntry> en, int idx, int left, int right) {
            if (left == right) {
                return left;
            }
            int pivot = en.get((left + right) / 2).start;
            if (pivot >= idx) {
                return this.binarySearch(en, idx, left, (left + right) / 2);
            }
            return this.binarySearch(en, idx, (left + right) / 2 + 1, right);
        }
    }
}

