/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.Singleton;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;

public final class DNAAlphabet
extends ComplementableDiscreteAlphabet
implements Singleton {
    public static final DNAAlphabet SINGLETON = DNAAlphabet.get();

    private static DNAAlphabet get() {
        DNAAlphabet res = null;
        try {
            res = new DNAAlphabet();
        }
        catch (Exception doesNotHappen) {
            throw new RuntimeException(doesNotHappen.getMessage());
        }
        return res;
    }

    private DNAAlphabet() throws DoubleSymbolException, IllegalArgumentException {
        super(true, DNAAlphabetParameterSet.DNA);
        this.parameters = DNAAlphabetParameterSet.SINGLETON;
    }

    @Override
    public int getComplementaryCode(int code) {
        return 3 - code;
    }

    public static final class DNAAlphabetParameterSet
    extends Alphabet.AlphabetParameterSet<DNAAlphabet>
    implements Singleton {
        public static final DNAAlphabetParameterSet SINGLETON = DNAAlphabetParameterSet.get();
        private static final String[] DNA = new String[]{"A", "C", "G", "T"};

        private static DNAAlphabetParameterSet get() {
            DNAAlphabetParameterSet res = null;
            try {
                res = new DNAAlphabetParameterSet();
            }
            catch (Exception doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getMessage());
            }
            return res;
        }

        private DNAAlphabetParameterSet() throws Exception {
            super(DNAAlphabet.class);
        }

        @Override
        public String getInstanceComment() {
            return "An alphabet for DNA.";
        }
    }
}

