/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif;

import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public final class UniformDurationDiffSM
extends DurationDiffSM {
    private double logP;

    public UniformDurationDiffSM(int min, int max) {
        this(min, max, 0.0);
    }

    public UniformDurationDiffSM(int min, int max, double ess) {
        super(min, max, ess);
        this.computeLogP();
    }

    public UniformDurationDiffSM(StringBuffer b) throws NonParsableException {
        super(b);
        this.computeLogP();
    }

    @Override
    public void modify(int delta) {
        super.modify(delta);
        this.computeLogP();
    }

    private void computeLogP() {
        this.logP = -Math.log(this.delta + 1);
    }

    @Override
    public String getInstanceName() {
        return "uniform";
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public void setParameters(double[] params, int start) {
    }

    @Override
    public void initializeFunction(int index, boolean meila, DataSet[] data, double[][] weights) {
    }

    @Override
    protected String getRNotation(String distributionName) {
        return "l = " + this.min + ":" + this.max + "; n = length(l); " + distributionName + " = rep(1,n)/n;";
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    @Override
    public double getLogScore(int ... values) {
        return this.logP;
    }

    @Override
    public double getLogScoreAndPartialDerivation(IntList indices, DoubleList partialDer, int ... values) {
        return this.logP;
    }

    public void drawPosition(int[] positions) {
        positions[0] = this.min + r.nextInt(this.delta + 1);
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    @Override
    public void initializeUniformly() {
    }

    @Override
    public void adjust(int[] length, double[] weight) {
    }
}

