/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.Normalisation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RandomNumberGenerator
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private double nextGaussian;
    private boolean haveNextGaussian = false;

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected synchronized void setSeed(long seed) {
        this.haveNextGaussian = false;
        this.mt = new int[624];
        this.mt[0] = (int)seed;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1];
            ++this.mti;
        }
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    protected synchronized int next(int bits) {
        int y;
        if (this.mti >= 624) {
            int kk = 0;
            while (kk < 227) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }

    public RandomNumberGenerator() {
        this(System.currentTimeMillis());
    }

    public RandomNumberGenerator(long seed) {
        this.setSeed(seed);
    }

    public synchronized int nextInt() {
        return this.next(32);
    }

    public synchronized int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public synchronized int nextPoisson(double lambda) {
        int v = -1;
        double l = Math.exp(-lambda);
        double p = 1.0;
        while (p >= l) {
            p *= this.nextUniform();
            ++v;
        }
        return v;
    }

    public synchronized int nextPoisson() {
        return this.nextPoisson(1.0);
    }

    public synchronized boolean nextBoolean() {
        return (this.next(32) & 0x8000) != 0;
    }

    public synchronized boolean nextBoolean(double p) {
        double u = this.nextUniform();
        return u < p;
    }

    public synchronized double nextUniform() {
        long l = ((long)this.next(26) << 27) + (long)this.next(27);
        return (double)l / 9.007199254740992E15;
    }

    public synchronized double nextUniform(double a, double b) {
        return a + (b - a) * this.nextUniform();
    }

    public synchronized double nextGaussian() {
        if (!this.haveNextGaussian) {
            double x2;
            double v1 = this.nextUniform();
            double v2 = this.nextUniform();
            double x1 = Math.sqrt(-2.0 * Math.log(v1)) * Math.cos(Math.PI * 2 * v2);
            this.nextGaussian = x2 = Math.sqrt(-2.0 * Math.log(v1)) * Math.sin(Math.PI * 2 * v2);
            this.haveNextGaussian = true;
            return x1;
        }
        this.haveNextGaussian = false;
        return this.nextGaussian;
    }

    public synchronized double nextGaussian(double m, double s2) {
        return this.nextGaussian() * Math.sqrt(s2) + m;
    }

    public synchronized double nextGamma() {
        return this.nextGamma(1.0, 1.0, 0.0);
    }

    public synchronized double nextGamma(double alpha, double beta) {
        return this.nextGamma(alpha, beta, 0.0);
    }

    public synchronized double nextGamma(double alpha, double beta, double lambda) {
        double gamma = 0.0;
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha < 1.0) {
            boolean flag = false;
            double b = 1.0 + alpha * Math.exp(-1.0);
            while (!flag) {
                double p = b * this.nextUniform();
                if (p > 1.0) {
                    gamma = -Math.log((b - p) / alpha);
                    if (!(this.nextUniform() <= Math.pow(gamma, alpha - 1.0))) continue;
                    flag = true;
                    continue;
                }
                gamma = Math.pow(p, 1.0 / alpha);
                if (!(this.nextUniform() <= Math.exp(-gamma))) continue;
                flag = true;
            }
        } else if (alpha == 1.0) {
            gamma = -Math.log(this.nextUniform());
        } else {
            double y = -Math.log(this.nextUniform());
            while (this.nextUniform() > Math.pow(y * Math.exp(1.0 - y), alpha - 1.0)) {
                y = -Math.log(this.nextUniform());
            }
            gamma = alpha * y;
        }
        return beta * gamma + lambda;
    }

    public synchronized double nextGammaLog(double alpha, double beta) {
        double logGamma = 0.0;
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha < 1.0) {
            boolean flag = false;
            double logB = Normalisation.getLogSum(0.0, Math.log(alpha) - 1.0);
            while (!flag) {
                double logP = logB + Math.log(this.nextUniform());
                if (logP > 0.0) {
                    logGamma = Math.log(-Math.log((Math.exp(logB) - Math.exp(logP)) / alpha));
                    if (!(Math.log(this.nextUniform()) <= logGamma * (alpha - 1.0))) continue;
                    flag = true;
                    continue;
                }
                logGamma = logP / alpha;
                if (!(Math.log(this.nextUniform()) <= -logGamma)) continue;
                flag = true;
            }
        } else if (alpha == 1.0) {
            logGamma = Math.log(-Math.log(this.nextUniform()));
        } else {
            double y = -Math.log(this.nextUniform());
            while (Math.log(this.nextUniform()) > (Math.log(y) + (1.0 - y)) * (alpha - 1.0)) {
                y = -Math.log(this.nextUniform());
            }
            logGamma = Math.log(alpha) + Math.log(y);
        }
        return Math.log(beta) + logGamma;
    }

    public synchronized double nextExp() {
        return this.nextGamma(1.0, 1.0, 0.0);
    }

    public synchronized double nextExp(double beta) {
        return this.nextGamma(1.0, beta, 0.0);
    }

    public synchronized double nextExp(double beta, double lambda) {
        return this.nextGamma(1.0, beta, lambda);
    }

    public synchronized double nextChiSq() {
        return this.nextGamma(0.5, 2.0, 0.0);
    }

    public synchronized double nextChiSq(int df) {
        return this.nextGamma(0.5 * (double)df, 2.0, 0.0);
    }

    public synchronized double nextChiSq(int df, double lambda) {
        return this.nextGamma(0.5 * (double)df, 2.0, lambda);
    }

    public synchronized double nextBeta(double alpha, double beta) {
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha == 1.0 && beta == 1.0) {
            return this.nextUniform();
        }
        if (alpha >= 1.0 && beta >= 1.0) {
            double A = alpha - 1.0;
            double B = beta - 1.0;
            double C = A + B;
            double L = C * Math.log(C);
            double mu = A / C;
            double sigma = 0.5 / Math.sqrt(C);
            double y = this.nextGaussian();
            double x = sigma * y + mu;
            while (x < 0.0 || x > 1.0) {
                y = this.nextGaussian();
                x = sigma * y + mu;
            }
            double u = this.nextUniform();
            while (Math.log(u) >= A * Math.log(x / A) + B * Math.log((1.0 - x) / B) + L + 0.5 * y * y) {
                y = this.nextGaussian();
                x = sigma * y + mu;
                while (x < 0.0 || x > 1.0) {
                    y = this.nextGaussian();
                    x = sigma * y + mu;
                }
                u = this.nextUniform();
            }
            return x;
        }
        double v1 = Math.pow(this.nextUniform(), 1.0 / alpha);
        double v2 = Math.pow(this.nextUniform(), 1.0 / beta);
        while (v1 + v2 > 1.0) {
            v1 = Math.pow(this.nextUniform(), 1.0 / alpha);
            v2 = Math.pow(this.nextUniform(), 1.0 / beta);
        }
        return v1 / (v1 + v2);
    }
}

