/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;
import org.biojavax.CrossRef;
import org.biojavax.CrossReferenceResolver;
import org.biojavax.RichAnnotation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.PositionResolver;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.ontology.ComparableTerm;

public class EmptyRichLocation
extends Unchangeable
implements RichLocation {
    public RichFeature getFeature() {
        return null;
    }

    public void sort() {
    }

    public void setFeature(RichFeature feature) throws ChangeVetoException {
        throw new ChangeVetoException("Cannot set a feature for the empty location");
    }

    public CrossRef getCrossRef() {
        return null;
    }

    public Annotation getAnnotation() {
        return RichAnnotation.EMPTY_ANNOTATION;
    }

    public Set getNoteSet() {
        return RichAnnotation.EMPTY_ANNOTATION.getNoteSet();
    }

    public void setNoteSet(Set notes) throws ChangeVetoException {
        throw new ChangeVetoException("Cannot annotate the empty location");
    }

    public ComparableTerm getTerm() {
        return null;
    }

    public void setTerm(ComparableTerm term) throws ChangeVetoException {
        throw new ChangeVetoException("Cannot give a term to the empty location");
    }

    public int getCircularLength() {
        return 0;
    }

    public void setCircularLength(int sourceSeqLength) throws ChangeVetoException {
        throw new ChangeVetoException("Cannot make empty locations circular");
    }

    public RichLocation.Strand getStrand() {
        return RichLocation.Strand.UNKNOWN_STRAND;
    }

    public int getRank() {
        return 0;
    }

    public void setRank(int rank) throws ChangeVetoException {
        throw new ChangeVetoException("Cannot give a rank to the empty location");
    }

    public int getMax() {
        return 0;
    }

    public int getMin() {
        return 0;
    }

    public Position getMinPosition() {
        return Position.EMPTY_POSITION;
    }

    public Position getMaxPosition() {
        return Position.EMPTY_POSITION;
    }

    public void setPositionResolver(PositionResolver p) {
    }

    public Iterator blockIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    public boolean isContiguous() {
        return true;
    }

    public boolean contains(int p) {
        return false;
    }

    public Location getDecorator(Class decoratorClass) {
        return null;
    }

    public Location newInstance(Location loc) {
        return loc;
    }

    public Location translate(int dist) {
        return this;
    }

    public boolean contains(Location l) {
        return false;
    }

    public boolean overlaps(Location l) {
        return false;
    }

    public Location union(Location l) {
        if (l == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        return l;
    }

    public Location intersection(Location l) {
        if (l == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        return this;
    }

    public void setCrossRefResolver(CrossReferenceResolver r) {
    }

    public SymbolList symbols(SymbolList seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        return SymbolList.EMPTY_LIST;
    }

    public int hashCode() {
        return 17;
    }

    public boolean equals(Object o) {
        return o instanceof EmptyRichLocation;
    }

    public int compareTo(Object o) {
        if (o instanceof EmptyRichLocation) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return "empty";
    }
}

