/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.PRCurve;
import de.jstacs.classifiers.performanceMeasures.ROCCurve;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.ExtendedZOOPSDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.REnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;
import projects.dispom.PFMComparator;

public class DiscoveryComparator {
    private static final String HOME = "../Dispom/";
    private static final String TOOLS = "tools/";
    private static final String DATATYPE = "artificial/";
    private static final String motifName = "implanted motif";
    private static final String host = "localhost";
    private static final String user = "";
    private static final String pass = "";

    private static DataSet addPosition(DataSet data, String posFileName, String revcomFileName, int length) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(posFileName));
        BufferedReader rr = new BufferedReader(new FileReader(revcomFileName));
        Sequence[] seqs = data.getAllElements();
        int i = 0;
        while (i < seqs.length) {
            String line = r.readLine().trim();
            String liner = rr.readLine().trim();
            if (!line.equalsIgnoreCase("na")) {
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = liner.equalsIgnoreCase("true") ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
                seqs[i] = seqs[i].annotate(false, new MotifAnnotation(motifName, Integer.parseInt(line) - 1, length, strand, new Result[0]));
            }
            ++i;
        }
        r.close();
        rr.close();
        return new DataSet("annotated " + data.getAnnotation(), seqs);
    }

    private static ComparableElement<Boolean, Double> getMeanDivergence(double[] bg, double[][] pwm, double[][] pwmRefFw, double[][] pwmRefRev, PFMComparator.PFMDistance dist) {
        double reverse;
        double forward = DiscoveryComparator.getMeanDivergence(bg, pwm, pwmRefFw, dist);
        if (forward < (reverse = DiscoveryComparator.getMeanDivergence(bg, pwm, pwmRefRev, dist))) {
            return new ComparableElement<Boolean, Double>(true, forward);
        }
        return new ComparableElement<Boolean, Double>(false, reverse);
    }

    private static double getMeanDivergence(double[] bg, double[][] pwm, double[][] pwmRef, PFMComparator.PFMDistance dist) {
        if (pwm.length < pwmRef.length) {
            pwm = DiscoveryComparator.fillPwm(pwm, pwmRef.length, bg);
        } else if (pwm.length > pwmRef.length) {
            pwmRef = DiscoveryComparator.fillPwm(pwmRef, pwm.length, bg);
        }
        return dist.compare(pwm, pwmRef, pwmRef.length / 2);
    }

    private static double[][] fillPwm(double[][] original, int newLength, double[] bg) {
        double[][] newPwm = new double[newLength][];
        int i = 0;
        while (i < (newLength - original.length) / 2) {
            newPwm[i] = (double[])bg.clone();
            ++i;
        }
        int k = 0;
        while (k < original.length) {
            newPwm[i] = (double[])original[k].clone();
            ++k;
            ++i;
        }
        while (i < newLength) {
            newPwm[i] = (double[])bg.clone();
            ++i;
        }
        return newPwm;
    }

    private static void plotPositionalDistribution(REnvironment r, String file, ExtendedZOOPSDiffSM mix, DataSet truth) throws Exception {
        r.createVector("pos", DiscoveryComparator.getPositions(truth, motifName));
        DurationDiffSM dsf = (DurationDiffSM)mix.getFunction(1);
        String plotcmd = String.valueOf(dsf.toString()) + "\n" + "par(mar=c(5,6,0,0),cex.lab=2,cex.axis=2);\n" + "hist(pos,xlab=\"Position\", ylab=\"\",main=\"\", xlim=c(min(l),max(l)),freq=F,breaks=seq(0,500,by=20),col=gray(0.8),axes=F);\n" + "a=axis(1,col.axis=0);b=a-501;axis(1,at=a,label=b);axis(2,las=2);\n" + "lines(l,p,lwd=2);";
        r.plotToPDF(plotcmd, 8.0, 3.0, file, true);
    }

    private static void plotSeqLogo(REnvironment r, String file, double[][] pwm) throws Exception {
        if (pwm.length == 0) {
            return;
        }
        r.createMatrix("pwm", pwm);
        r.voidEval("print(pwm);pwm<-apply(pwm,1,function(x){x/sum(x)});print(pwm);");
        r.plotToPDF("library(seqLogo);seqLogo(pwm);", 8.0, 3.0, file, true);
    }

    private static double[][] getPWM(DataSet data, String motifName, boolean rc) throws Exception {
        try {
            DataSet ex = DiscoveryComparator.exciseSites(data, motifName, rc);
            return PFMComparator.getPFM(ex);
        }
        catch (EmptyDataSetException ex) {
            return new double[0][0];
        }
    }

    private static int[] getPositions(DataSet data, String motifName) {
        IntList list = new IntList();
        for (Sequence seq : data) {
            SequenceAnnotation[] anns = seq.getAnnotation();
            int i = 0;
            while (anns != null && i < anns.length) {
                if (anns[i] instanceof MotifAnnotation && (motifName == null || motifName.equals(anns[i].getIdentifier()))) {
                    list.add(((MotifAnnotation)anns[i]).getPosition());
                }
                ++i;
            }
        }
        return list.toArray();
    }

    private static DataSet exciseSites(DataSet data, String motifName, boolean rc) throws EmptyDataSetException, WrongAlphabetException, OperationNotSupportedException {
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        for (Sequence seq : data) {
            SequenceAnnotation[] anns = seq.getAnnotation();
            int i = 0;
            while (anns != null && i < anns.length) {
                if (anns[i] instanceof MotifAnnotation && (motifName == null || motifName.equals(anns[i].getIdentifier()))) {
                    if (((MotifAnnotation)anns[i]).getStrandedness() == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE && !rc || ((MotifAnnotation)anns[i]).getStrandedness() != StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE && rc) {
                        seqs.add(seq.reverseComplement(((MotifAnnotation)anns[i]).getPosition(), ((MotifAnnotation)anns[i]).getEnd()));
                    } else {
                        seqs.add(seq.getSubSequence(((MotifAnnotation)anns[i]).getPosition(), ((MotifAnnotation)anns[i]).getLength()));
                    }
                }
                ++i;
            }
        }
        return new DataSet("excised sites", seqs.toArray(new Sequence[0]));
    }

    public static void main(String[] args) throws Exception {
        String[] prefixes = new String[]{"MA0001.1", "MA0005.1", "MA0015", "MA0048", "MA0048_ma52gauss", "MA0048_ma52unif", "MA0052", "MA0054", "MA0077"};
        String[] dataSet = new String[]{"MA0001", "MA0005", "MA0015", "MA0048", "MA0048+MA0052(gauss)", "MA0048+MA0052(unif)", "MA0052", "MA0054", "MA0077"};
        String[] orgs = new String[]{"at", "at", "dm", "hs", "hs", "hs", "hs", "petunia", "hs", "at"};
        String[] infs = new String[]{"gauss", "unif"};
        int[] lengths = new int[]{10, 10, 9, 10, 10, 10, 10, 9, 8, 10};
        REnvironment r = null;
        try {
            try {
                r = new REnvironment(host, "", "");
                double[][][][][] ppvs = new double[infs.length][prefixes.length][2][][];
                double[] sns = new double[]{0.1, 0.25, 0.3, 0.5, 0.7, 0.75, 0.9};
                String[] names = null;
                PFMComparator.PFMDistance[] dists = new PFMComparator.PFMDistance[]{new PFMComparator.SymmetricKullbackLeiblerDivergence(1.0)};
                int pr = 0;
                while (pr < prefixes.length) {
                    int in = 0;
                    while (in < infs.length) {
                        int gl = 0;
                        while (gl < 2) {
                            DiscoveryResult dr;
                            Discoverer.resetUsed();
                            DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
                            String prefix = prefixes[pr];
                            String org = orgs[pr];
                            String inf = infs[in];
                            String infix = String.valueOf(inf);
                            int length = lengths[pr];
                            boolean givenLength = gl == 1;
                            System.out.println("##################################################################################");
                            System.out.println("data/artificial/" + prefix + ".sites_" + org + ".txt_e.txt_" + inf + ".txt");
                            DataSet data = new DataSet(con, new SparseStringExtractor("../Dispom/data/artificial/" + prefix + ".sites_" + org + ".txt_e.txt_" + inf + ".txt"));
                            System.out.println("../Dispom//data/artificial//pos_" + prefix + ".sites_" + org + ".txt_e.txt_" + inf + ".txt");
                            DataSet truth = DiscoveryComparator.addPosition(data, "../Dispom//data/artificial//pos_" + prefix + ".sites_" + org + ".txt_e.txt_" + inf + ".txt_new.txt", "../Dispom//data/artificial//revcom_" + prefix + ".sites_" + org + ".txt_e.txt.txt", length);
                            double[] bg = PFMComparator.getCounts(truth);
                            double[][] truePWMfw = DiscoveryComparator.getPWM(truth, motifName, false);
                            double[][] truePWMrev = DiscoveryComparator.getPWM(truth, motifName, true);
                            DiscoveryComparator.plotSeqLogo(r, "../Dispom/results/artificial/seqLogos/seqLogo-truePWM-" + prefix.replaceAll("[\\._\\s]", "-") + "-" + infix + ".pdf", truePWMfw);
                            LinkedList<DiscoveryResult> list = new LinkedList<DiscoveryResult>();
                            if (!givenLength) {
                                list.add(new DiscoveryResult(Discoverer.A__GLAM, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_anchor500.txt"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.A__GLAM, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_anchor500_w" + length + ".txt"}));
                            }
                            if (givenLength) {
                                list.add(new DiscoveryResult(Discoverer.DEME, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_w" + length + ".txt"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.DEME, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_w15.txt"}));
                            }
                            if (givenLength) {
                                list.add(new DiscoveryResult(Discoverer.DME, truth, data, true, new String[]{"dme_" + prefix + "_" + infix + "_w" + length + ".txt"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.DME, truth, data, true, new String[]{"dme_" + prefix + "_" + infix + "_w15.txt"}));
                            }
                            if (givenLength) {
                                list.add(new DiscoveryResult(Discoverer.GIBBS_SAMPLER, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_w" + length + ".txt"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.GIBBS_SAMPLER, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_w15.txt"}));
                            }
                            if (!givenLength) {
                                list.add(new DiscoveryResult(Discoverer.IMPROBIZER, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_improbizer.txt", String.valueOf(prefix) + "_" + infix + "_motif.txt"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.IMPROBIZER, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_improbizer.txt", String.valueOf(prefix) + "_" + infix + "_motif_w" + length + ".txt"}));
                            }
                            if (givenLength) {
                                list.add(new DiscoveryResult(Discoverer.MEME, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_w" + length + ".txt"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.MEME, truth, data, true, new String[]{String.valueOf(prefix) + "_" + infix + "_w6-20.txt"}));
                            }
                            if (givenLength) {
                                list.add(new DiscoveryResult(Discoverer.WEEDER, truth, data, true, new String[]{"fl/" + prefix + ".sites_" + org + ".txt_e.txt_" + infix + ".txt.fasta_fl.wee"}));
                            } else {
                                list.add(new DiscoveryResult(Discoverer.WEEDER, truth, data, true, new String[]{"vl/" + prefix + ".sites_" + org + ".txt_e.txt_" + infix + ".txt.fasta.wee"}));
                            }
                            FileAndName[] fnn = DiscoveryComparator.getFiles(givenLength, prefix, infix, length, "dipomm-150");
                            if (fnn != null && fnn.length > 0) {
                                list.add(new DiscoveryResult(Discoverer.Dispom, truth, data, false, new String[]{fnn[0].file.getAbsolutePath(), "../Dispom/data/artificial//" + prefix + ".sites_" + org + ".txt_e.txt_bgonly.txt", "1E-4"}));
                            }
                            Iterator it = null;
                            ppvs[in][pr][gl] = new double[list.size()][sns.length];
                            names = new String[list.size()];
                            it = list.iterator();
                            int p = 0;
                            int fw = 0;
                            while (it.hasNext()) {
                                dr = (DiscoveryResult)it.next();
                                int s = 0;
                                while (s < sns.length) {
                                    ppvs[in][pr][gl][p][s] = dr.getPPVFor(sns[s]);
                                    ++s;
                                }
                                double[][] pwm = dr.getPWM();
                                PrintWriter wr2 = new PrintWriter("../Dispom/results/artificial/distances/dist-" + dr.getName().replaceAll("[\\._\\s]", "-") + "-" + prefix.replaceAll("[\\._\\s]", "-") + "-" + infix + "-givenLength-" + givenLength + ".txt");
                                fw = 0;
                                int d = 0;
                                while (d < dists.length) {
                                    ComparableElement<Boolean, Double> pwmComparison = DiscoveryComparator.getMeanDivergence(bg, pwm, truePWMfw, truePWMrev, dists[d]);
                                    wr2.println(pwmComparison.getWeight());
                                    if (pwmComparison.getElement().booleanValue()) {
                                        ++fw;
                                    }
                                    ++d;
                                }
                                wr2.close();
                                dr.createPlots(r, (double)fw >= (double)dists.length / 2.0, String.valueOf(prefix.replaceAll("[\\._\\s]", "-")) + "-" + infix + "-givenLength-" + givenLength);
                                names[p] = dr.getName();
                                ++p;
                            }
                            int i = 0;
                            while (i < list.size()) {
                                dr = (DiscoveryResult)list.get(i);
                                if (!dr.plot()) {
                                    list.remove(i--);
                                }
                                ++i;
                            }
                            LinkedList<AbstractScoreBasedClassifier.DoubleTableResult> dtrPR = new LinkedList<AbstractScoreBasedClassifier.DoubleTableResult>();
                            LinkedList<AbstractScoreBasedClassifier.DoubleTableResult> dtrROC = new LinkedList<AbstractScoreBasedClassifier.DoubleTableResult>();
                            ArrayList<String> colors = new ArrayList<String>();
                            StringBuffer points = new StringBuffer(list.size() * 100);
                            points.append("\n");
                            int i2 = 0;
                            while (i2 < list.size()) {
                                dr = (DiscoveryResult)list.get(i2);
                                points.append("points( " + dr.getValue(0) + ", " + dr.getValue(2) + ", col=\"" + dr.getColor() + "\", pch=" + dr.getPCH() + ", cex=2, lwd=3 );\n");
                                String n = dr.getName();
                                points.append("text( " + dr.getValue(0) + ", " + dr.getValue(2) + ", \"" + n + "\", col=\"" + dr.getColor() + "\", adj=c(1,1.5), cex=1.75 );\n");
                                dtrPR.add(dr.getPrCurve());
                                dtrROC.add(dr.getROCCurve());
                                colors.add(dr.getColor());
                                ++i2;
                            }
                            System.out.println(colors);
                            StringBuffer plotcmd = AbstractScoreBasedClassifier.DoubleTableResult.getPlotCommands(r, ", xlim=c(0, 1), ylim=c(0, 1), xlab=\"Nucleotide Recall\", ylab=\"Nucleotide Precision\", lwd=3", colors.toArray(new String[0]), dtrPR.toArray(new AbstractScoreBasedClassifier.DoubleTableResult[0]));
                            String palette = "par(mar=c(5,5,0,0),cex.lab=2,cex.main=2,cex.axis=2);\n";
                            r.plotToPDF(String.valueOf(palette) + plotcmd.toString() + "\n" + points.toString(), "../Dispom/results/artificial/pics/plot-pr-" + prefix.replaceAll("[\\._]", "-") + "_" + infix + "_givenLength-" + givenLength + ".pdf", true);
                            ++gl;
                        }
                        ++in;
                    }
                    ++pr;
                }
                int i = 0;
                while (i < infs.length) {
                    int j = 0;
                    while (j < 2) {
                        int k = 0;
                        while (k < sns.length) {
                            PrintWriter pr2 = new PrintWriter("../Dispom/results/artificial/tables/table_" + infs[i] + "_" + (j == 0 ? "variable" : "fixed") + "_" + sns[k] + ".txt");
                            int l = 0;
                            while (l < prefixes.length) {
                                pr2.print("\t\"" + dataSet[l] + "\"");
                                ++l;
                            }
                            pr2.println();
                            l = 0;
                            while (l < ppvs[i][0][j].length) {
                                pr2.print((String)names[l]);
                                int m = 0;
                                while (m < prefixes.length) {
                                    if (Double.isNaN(ppvs[i][m][j][l][k])) {
                                        pr2.print("\t0");
                                    } else {
                                        pr2.print("\t" + ppvs[i][m][j][l][k]);
                                    }
                                    ++m;
                                }
                                pr2.println();
                                ++l;
                            }
                            pr2.close();
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (r != null) {
                    r.close();
                    System.out.println("closed REnvironment");
                }
            }
        }
        finally {
            if (r != null) {
                r.close();
                System.out.println("closed REnvironment");
            }
        }
    }

    private static FileAndName[] getFiles(boolean bl, String string, String string2, int n, String string3) {
        throw new Error("Unresolved compilation problems: \n\tThe constructor RegExFilenameFilter(String, boolean, boolean, String) is undefined\n\tThe constructor RegExFilenameFilter(String, boolean, boolean, String) is undefined\n");
    }

    private static enum Discoverer {
        A__GLAM("black"),
        DEME("blue"),
        DME("cyan"),
        GIBBS_SAMPLER("orange"),
        IMPROBIZER("skyblue1"),
        MEME("red"),
        MOAN("yellow"),
        WEEDER("magenta2"),
        Dispom("green3");

        private static int no;
        private int myNo;
        private int used;
        private String color;

        static {
            no = 0;
        }

        private Discoverer(String color) {
            this.setMyNo();
            this.used = 3;
            this.color = color;
        }

        private void setMyNo() {
            this.myNo = 5 + no++;
        }

        public int getNumber() {
            return this.myNo;
        }

        public void used() {
            ++this.used;
        }

        public static void resetUsed() {
            Discoverer[] vals;
            Discoverer[] discovererArray = vals = Discoverer.values();
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Discoverer d = discovererArray[n2];
                d.used = 3;
                ++n2;
            }
        }

        public String getColor() {
            return this.color;
        }
    }

    private static class DiscoveryResult {
        private static PRCurve prCurve = new PRCurve();
        private static ROCCurve rocCurve = new ROCCurve();
        ResultSet rs;
        AbstractScoreBasedClassifier.DoubleTableResult pr;
        AbstractScoreBasedClassifier.DoubleTableResult roc;
        String description;
        Discoverer d;
        double[][] pwm;
        ExtendedZOOPSDiffSM md;
        DataSet truth;
        double aucPR;
        int pch;

        private DiscoveryResult(Discoverer discoverer, DataSet dataSet, DataSet dataSet2, boolean bl, String ... stringArray) throws Exception {
            throw new Error("Unresolved compilation problems: \n\tThe constructor RegExFilenameFilter(String, boolean, boolean, String) is undefined\n\tThe constructor RegExFilenameFilter(String, boolean, boolean, String) is undefined\n\tThe constructor RegExFilenameFilter(String, boolean, boolean, String) is undefined\n");
        }

        public double[][] getPWM() {
            return this.pwm;
        }

        public double getPPVFor(double Sn) {
            if (this.pr == null || this.rs.getNumberOfResults() == 0) {
                return Double.NaN;
            }
            int i = this.pr.getNumberOfLines() - 1;
            while (i >= 0 && this.pr.getLine(i)[0] < Sn) {
                --i;
            }
            if (i == -1) {
                return Double.NaN;
            }
            return this.pr.getLine(i)[1];
        }

        /*
         * Unable to fully structure code
         */
        public boolean plot() {
            if (this.pr == null) {
                return false;
            }
            i = this.pr.getNumberOfLines() - 1;
            if (!(this.pr.getLine(i)[0] > 0.1)) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                --i;
lbl7:
                // 2 sources

                ** while (i >= 0 && this.pr.getLine((int)i)[1] < 0.1)
            }
lbl8:
            // 1 sources

            return i != -1;
        }

        public String getColor() {
            return this.d.getColor();
        }

        public int getPCH() {
            return this.pch;
        }

        public String getName() {
            String s = this.d.name();
            if (this.d == Discoverer.Dispom && this.pch != 3) {
                s = String.valueOf(s) + "-" + (this.pch - 3);
            }
            return s.replaceAll("__", "-").replace('_', ' ');
        }

        public double getAUC_PR() {
            return this.aucPR;
        }

        public double getValue(int index) {
            return (Double)this.rs.getResultAt(index).getValue();
        }

        public AbstractScoreBasedClassifier.DoubleTableResult getPrCurve() {
            return this.pr;
        }

        public void createPlots(REnvironment r, boolean rc, String suffix) throws Exception {
            DiscoveryComparator.plotSeqLogo(r, "../Dispom/results/artificial/seqLogos/seqLogo-" + this.getName().replaceAll("[\\._\\s]", "-") + "-" + suffix + ".pdf", rc ? this.pwm : PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, this.pwm));
            if (this.d == Discoverer.Dispom) {
                DiscoveryComparator.plotPositionalDistribution(r, "../Dispom/results/artificial/positionalDistribution/pos-" + this.getName().replaceAll("[\\._\\s]", "-") + "-" + suffix + ".pdf", this.md, this.truth);
            }
        }

        public AbstractScoreBasedClassifier.DoubleTableResult getROCCurve() {
            return this.roc;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(300);
            sb.append(String.valueOf(this.d.name()) + "\t");
            int i = 0;
            while (i < this.rs.getNumberOfResults()) {
                sb.append(this.rs.getResultAt(i).getValue() + "\t");
                ++i;
            }
            sb.append(this.description);
            return sb.toString();
        }

        public String getHeading() {
            StringBuffer sb = new StringBuffer(300);
            sb.append("discoverer\t");
            int i = 0;
            while (i < this.rs.getNumberOfResults()) {
                sb.append(String.valueOf(this.rs.getResultAt(i).getName()) + "\t");
                ++i;
            }
            sb.append("description");
            return sb.toString();
        }
    }

    private static class FileAndName {
        public File file;
        public String name;

        public FileAndName(File file, String name) {
            this.file = file;
            this.name = name;
        }
    }
}

