/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import projects.dispom.DispomPredictorParameterSet;

public class DispomPredictor {
    private static final String[] PREFIX = new String[]{"home", "ignore", "fg", "bg", "xml", "p-val", "one-histogram"};

    private static DataSet getSample(AlphabetContainer con, String fileName, char ignore) throws FileNotFoundException, WrongAlphabetException, EmptyDataSetException, WrongLengthException, IOException {
        return new DataSet(con, new SparseStringExtractor(fileName, ignore));
    }

    public static void main(String[] args) throws Exception {
        SignificantMotifOccurrencesFinder smof;
        ParameterSetTagger params = new ParameterSetTagger(PREFIX, new DispomPredictorParameterSet());
        params.fillParameters("=", args);
        System.out.println("parameters:");
        System.out.println(params);
        System.out.println("_________________________________");
        if (!params.hasDefaultOrIsSet()) {
            System.out.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        String home = params.getValueFromTag("home", String.class);
        char ignore = params.getValueFromTag("ignore", Character.class).charValue();
        int anz = 1;
        if (params.isSet("bg")) {
            anz = 2;
        }
        DataSet[] data = new DataSet[anz];
        data[0] = DispomPredictor.getSample(con, String.valueOf(home) + File.separatorChar + params.getValueFromTag("fg", String.class), ignore);
        if (anz > 1) {
            data[1] = DispomPredictor.getSample(con, String.valueOf(home) + File.separatorChar + params.getValueFromTag("bg", String.class), ignore);
        }
        double[][] weights = new double[anz][];
        int i = 0;
        while (i < data.length) {
            weights[i] = new double[data[i].getNumberOfElements()];
            Arrays.fill(weights[i], 1.0);
            System.out.println(String.valueOf(i) + "\t# = " + data[i].getNumberOfElements() + "\tlength = " + data[i].getElementLength() + "\t" + data[i].getAnnotation());
            ++i;
        }
        int sl = data[0].getElementLength();
        String fName = params.getValueFromTag("xml", String.class);
        if (!fName.endsWith(".xml")) {
            fName = String.valueOf(fName) + ".xml";
        }
        GenDisMixClassifier cl = new GenDisMixClassifier(XMLParser.extractForTag(FileManager.readFile(new File(fName)), "classifier"));
        DifferentiableStatisticalModel[] bestNSF = ArrayHandler.cast(DifferentiableStatisticalModel.class, cl.getDifferentiableSequenceScores());
        System.out.println("_________________________________");
        MotifDiscoverer md = (MotifDiscoverer)((Object)bestNSF[0]);
        System.out.println(md);
        System.out.println("result: " + cl.getLastScore());
        System.out.println("_________________________________");
        if (anz > 1) {
            smof = new SignificantMotifOccurrencesFinder(md, data[1], null, params.getValueFromTag("p-val", Double.class));
        } else if (params.getValueFromTag("one-histogram", Boolean.class).booleanValue()) {
            Random r = new Random();
            Sequence[] seqs = new Sequence[1000];
            int numFg = data[0].getNumberOfElements();
            int n = 0;
            while (n < seqs.length) {
                seqs[n] = new PermutedSequence(data[0].getElementAt(r.nextInt(numFg)));
                ++n;
            }
            DataSet bg = new DataSet("permuted", seqs);
            smof = new SignificantMotifOccurrencesFinder(md, bg, null, params.getValueFromTag("p-val", Double.class));
        } else {
            smof = new SignificantMotifOccurrencesFinder(md, SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, false, 1000, (double)params.getValueFromTag("p-val", Double.class));
        }
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        int m = 0;
        while (m < md.getNumberOfMotifs()) {
            System.out.println();
            System.out.println("predictions for motif " + m);
            System.out.println("sequence\tposition\tstrand\tbinding site\tadjusted binding site\tp-value");
            System.out.println("------------------------------------------------------------------------");
            DataSet annotated = smof.annotateMotif(data[0], m);
            int i2 = 0;
            while (i2 < annotated.getNumberOfElements()) {
                int end;
                SequenceAnnotation[] seqAn = data[0].getElementAt(i2).getAnnotation();
                int start = seqAn == null ? 0 : seqAn.length;
                Sequence seq = annotated.getElementAt(i2);
                seqAn = seq.getAnnotation();
                int n = end = seqAn == null ? 0 : seqAn.length;
                if (end - start > 0) {
                    int j = start;
                    while (j < end) {
                        Sequence site;
                        MotifAnnotation ma = (MotifAnnotation)seqAn[j];
                        Sequence adjusted = site = seq.getSubSequence(ma.getPosition(), ma.getLength());
                        if (ma.getStrandedness() == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE) {
                            list.add(site.reverseComplement());
                            adjusted = adjusted.reverseComplement();
                        } else {
                            list.add(site);
                        }
                        System.out.println(String.valueOf(i2) + "\t" + ma.getPosition() + "\t" + (Object)((Object)ma.getStrandedness()) + "\t" + site + "\t" + adjusted + "\t" + ma.getAnnotations()[1].getValue());
                        ++j;
                    }
                }
                ++i2;
            }
            double[][] pfm = DispomPredictor.getPFM(new DataSet("", list.toArray(new Sequence[0])));
            System.out.println("------------------------------------------------------------------------");
            System.out.println("Position frequency matrix of sites: ");
            i2 = 0;
            while (i2 < pfm.length) {
                System.out.print("\t" + i2);
                ++i2;
            }
            System.out.println();
            int j = 0;
            while (j < pfm[0].length) {
                System.out.print(DNAAlphabet.SINGLETON.getSymbolAt(j));
                int i3 = 0;
                while (i3 < pfm.length) {
                    System.out.print("\t" + pfm[i3][j]);
                    ++i3;
                }
                System.out.println();
                ++j;
            }
            System.out.println();
            System.out.println("------------------------------------------------------------------------");
            System.out.println("Position weight matrix of sites: ");
            i2 = 0;
            while (i2 < pfm.length) {
                System.out.print("\t" + i2);
                ++i2;
            }
            System.out.println();
            double s = list.size();
            int j2 = 0;
            while (j2 < pfm[0].length) {
                System.out.print(DNAAlphabet.SINGLETON.getSymbolAt(j2));
                int i4 = 0;
                while (i4 < pfm.length) {
                    System.out.print("\t" + pfm[i4][j2] / s);
                    ++i4;
                }
                System.out.println();
                ++j2;
            }
            ++m;
        }
    }

    public static double[][] getPFM(DataSet data) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        int l = 0;
        while (l < pfm.length) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
            ++l;
        }
        int n = 0;
        while (n < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(n);
            int l2 = 0;
            while (l2 < pfm.length) {
                double[] dArray = pfm[l2];
                int n2 = seq.discreteVal(l2);
                dArray[n2] = dArray[n2] + 1.0;
                ++l2;
            }
            ++n;
        }
        return pfm;
    }
}

