/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook.recipes;

import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import java.util.Arrays;

public class GenDisMixClassifierTest {
    public static void main(String[] args) throws Exception {
        DataSet[] data = new DataSet[]{new DNADataSet(args[0]), new DNADataSet(args[1])};
        AlphabetContainer container = data[0].getAlphabetContainer();
        int length = data[0].getElementLength();
        double essFg = 4.0;
        double essBg = 4.0;
        BayesianNetworkDiffSM pwmFg = new BayesianNetworkDiffSM(container, length, essFg, true, new InhomogeneousMarkov(0));
        BayesianNetworkDiffSM pwmBg = new BayesianNetworkDiffSM(container, length, essBg, true, new InhomogeneousMarkov(0));
        GenDisMixClassifierParameterSet cps = new GenDisMixClassifierParameterSet(container, length, 20, 0.1, 0.1, 1.0, false, OptimizableFunction.KindOfParameter.PLUGIN, true, AbstractMultiThreadedOptimizableFunction.getNumberOfAvailableProcessors());
        LearningPrinciple[] lp = LearningPrinciple.values();
        GenDisMixClassifier[] cl = new GenDisMixClassifier[lp.length + 1];
        int i = 0;
        while (i < cl.length - 1) {
            System.out.println("classifier " + i + " uses " + (Object)((Object)lp[i]));
            cl[i] = new GenDisMixClassifier(cps, (LogPrior)new CompositeLogPrior(), lp[i], pwmFg, pwmBg);
            ++i;
        }
        double[] beta = new double[]{0.3, 0.3, 0.4};
        System.out.println("classifier " + i + " uses the weights " + Arrays.toString(beta));
        cl[i] = new GenDisMixClassifier(cps, (LogPrior)new CompositeLogPrior(), beta, pwmFg, pwmBg);
        i = 0;
        while (i < cl.length) {
            cl[i].train(data);
            ++i;
        }
        NumericalPerformanceMeasureParameterSet mp = PerformanceMeasureParameterSet.createFilledParameters();
        i = 0;
        while (i < cl.length) {
            System.out.println(cl[i].evaluate((PerformanceMeasureParameterSet)mp, true, data));
            ++i;
        }
    }
}

