/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.PascalDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class PascalGen
extends RandomVariateGenInt {
    protected int n;
    protected double p;

    public PascalGen(RandomStream s, int n, double p) {
        super(s, new PascalDist(n, p));
        this.setParams(n, p);
    }

    public PascalGen(RandomStream s, PascalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getN(), dist.getP());
        }
    }

    public static int nextInt(RandomStream s, int n, double p) {
        return PascalDist.inverseF(n, p, s.nextDouble());
    }

    public int getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    protected void setParams(int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.p = p;
        this.n = n;
    }
}

