/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.SimpleCosts;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.results.Result;
import de.jstacs.utils.ToolBox;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.LinkedList;

public class AlignAthAlyPromotersAll {
    public static void main(String[] args) throws Exception {
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        DataSet ds = new DataSet(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "R", "W", "M", "S")), new SparseStringExtractor(args[0], '>', (SequenceAnnotationParser)parser));
        LinkedList<Sequence> at = new LinkedList<Sequence>();
        LinkedList<Sequence> al = new LinkedList<Sequence>();
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            if (i % 2 == 0) {
                at.add(ds.getElementAt(i));
            } else {
                al.add(ds.getElementAt(i));
            }
            ++i;
        }
        DataSet ath = new DataSet("", at);
        DataSet aly = new DataSet("", al);
        Alignment aling = new Alignment(Alignment.AlignmentType.GLOBAL, new AffineCosts(3.0, new SimpleCosts(0.0, 2.0, 0.5)));
        at.clear();
        al.clear();
        int i2 = 0;
        while (i2 < ath.getNumberOfElements()) {
            Sequence aths = ath.getElementAt(i2);
            Sequence alys = aly.getElementAt(i2);
            PairwiseStringAlignment res = aling.getAlignment(aths, alys);
            String athal = res.getAlignedString(0);
            String alyal = res.getAlignedString(1);
            System.out.println(">ath\n" + aths);
            System.out.println(">aly\n" + alys);
            System.out.println();
            System.out.println(athal);
            System.out.println(alyal);
            System.out.println();
            double[] athrep = new double[aths.getLength()];
            double[] alyrep = new double[alys.getLength()];
            int j = 0;
            int k = 0;
            int l = 0;
            while (j < athal.length()) {
                if (athal.charAt(j) == alyal.charAt(j)) {
                    athrep[k] = 1.0;
                    alyrep[l] = 1.0;
                    ++k;
                    ++l;
                } else if (athal.charAt(j) == '-') {
                    alyrep[l] = 0.0;
                    ++l;
                } else if (alyal.charAt(j) == '-') {
                    athrep[k] = 0.0;
                    ++k;
                } else {
                    athrep[k] = 0.0;
                    alyrep[l] = 0.0;
                    ++k;
                    ++l;
                }
                ++j;
            }
            j = 0;
            while (j < athrep.length) {
                athrep[j] = ToolBox.mean(j, Math.min(j + 8, athrep.length), athrep);
                ++j;
            }
            j = 0;
            while (j < alyrep.length) {
                alyrep[j] = ToolBox.mean(j, Math.min(j + 8, alyrep.length), alyrep);
                ++j;
            }
            aths = aths.annotate(true, new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
            alys = alys.annotate(true, new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
            at.add(aths);
            al.add(alys);
            ++i2;
        }
        new DataSet("", at.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_athprof.fa"), '>', parser);
        new DataSet("", al.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_alyprof.fa"), '>', parser);
    }
}

