/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.REnvironment;
import java.io.File;
import seqTools.ChIPper;

public class ChipSeqBSVis {
    public static void main(String[] args) throws Exception {
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        double ess = 4.0;
        String home = "/Users/dev/Desktop/ChIP-seq/dispom_chip/";
        String factor = "AP2gamma";
        int motifLength = 10;
        double[] oldPars = new double[]{-1.8545072887471554, -1.203619360647335, -0.68206204860221, -2.0124410297218636, -5.600277949787155, -1.8312027522447487, -2.509671327770164, -5.389983032940059, -7.105374172440809, 0.05201979939822354, -7.606606760973154, -5.712625036295201, -7.196965537501024, -0.1884053773226381, -6.019018358700991, -2.100597960463086, -3.472543586269973, -1.2570610735967704, -1.7160756242603152, -0.5271092221095318, -2.055006508478231, -1.0863556493034199, -0.8956326562293494, -2.6272021798113556, -0.7083673829590511, -2.2889519108256517, -1.3339016640579244, -4.08358021781508, -2.847399854001266, -5.690806895008637, -0.04681267856185463, -6.354519004096607, -5.85498956269083, -7.267411859771515, 0.16611461826341256, -6.577989357421334, -1.5397790571268417, 2.1194150515189047, 0.9333861452038995, -1.5130221396644805, -0.8292164828952985, -0.5570778782002601, -0.19621215206118628, -6.879768871816195, 0.858974016703737, -2.5185180251672383, 1.1304590749553483, -1.3744231301210246, -1.4137899319448193, -1.392665506702869, -1.3642988757161498, 2.5241692209600908, -4.057257927226994};
        AbstractDifferentiableStatisticalModel motif = new MarkovModelDiffSM((AlphabetContainer)con, motifLength, ess, true, 0, null);
        motif = new StrandDiffSM((DifferentiableStatisticalModel)motif, 0.5, 1, true, StrandDiffSM.InitMethod.INIT_BOTH_STRANDS);
        motif = new NormalizedDiffSM(motif, 1);
        motif.initializeFunctionRandomly(false);
        ChIPper fg = new ChIPper(1, 0.75, motif);
        int i = motif.getNumberOfParameters();
        double[] pars = new double[fg.getNumberOfParameters()];
        System.arraycopy(oldPars, 0, pars, 0, i);
        System.arraycopy(oldPars, oldPars.length - 2, pars, i, 2);
        fg.setParameters(pars, 0);
        System.out.println(fg);
        REnvironment re = null;
        try {
            try {
                File f = new File(String.valueOf(home) + "/data/");
                RegExFilenameFilter filter = new RegExFilenameFilter("", RegExFilenameFilter.Directory.FORBIDDEN, true, String.valueOf(factor) + "_positives.*");
                String fgData = String.valueOf(f.getAbsolutePath()) + "/" + f.list(filter)[0];
                filter = new RegExFilenameFilter("", RegExFilenameFilter.Directory.FORBIDDEN, true, String.valueOf(factor) + "_negatives.*");
                String bgData = String.valueOf(f.getAbsolutePath()) + "/" + f.list(filter)[0];
                SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
                DataSet[] data = new DataSet[]{SparseSequence.getDataSet((AlphabetContainer)con, fgData, parser), SparseSequence.getDataSet((AlphabetContainer)con, bgData, null)};
                SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(fg, data[1], null, 1.0E-4);
                DataSet d = smof.annotateMotif(0, data[0], 0, Integer.MAX_VALUE, true);
                double[] summit = new double[d.getNumberOfElements()];
                double[] weight = new double[summit.length];
                double[] sd = new double[summit.length];
                int[] no = new int[summit.length];
                double[] closest = new double[summit.length];
                DoubleList il = new DoubleList();
                i = 0;
                while (i < d.getNumberOfElements()) {
                    il.clear();
                    Sequence s = d.getElementAt(i);
                    SequenceAnnotation[] seqAn = s.getAnnotation();
                    summit[i] = Double.NaN;
                    int j = 0;
                    while (j < seqAn.length) {
                        if (seqAn[j] instanceof MotifAnnotation) {
                            il.add(((MotifAnnotation)seqAn[j]).getPosition());
                            int n = i;
                            no[n] = no[n] + 1;
                        } else if (seqAn[j].getType().equals("weight")) {
                            weight[i] = Double.parseDouble(seqAn[j].getIdentifier());
                        } else if (seqAn[j].getType().equals("mean")) {
                            summit[i] = Double.parseDouble(seqAn[j].getIdentifier());
                        } else if (seqAn[j].getType().equals("sd")) {
                            sd[i] = Double.parseDouble(seqAn[j].getIdentifier());
                        }
                        ++j;
                    }
                    if (il.length() > 0) {
                        closest[i] = summit[i] - il.get(0);
                        j = 1;
                        while (j < il.length()) {
                            if (Math.abs(summit[i] - il.get(j)) < Math.abs(closest[i])) {
                                closest[i] = summit[i] - il.get(j);
                            }
                            ++j;
                        }
                    } else {
                        closest[i] = Double.NaN;
                    }
                    double[] histogram = new double[s.getLength()];
                    double sum = 0.0;
                    double max = 0.0;
                    int j2 = 0;
                    while (j2 < histogram.length) {
                        histogram[j2] = ((double)j2 - summit[i]) / sd[i];
                        histogram[j2] = (float)Math.exp(-0.5 * histogram[j2] * histogram[j2]);
                        sum += histogram[j2];
                        ++j2;
                    }
                    j2 = 0;
                    while (j2 < histogram.length) {
                        int n = j2;
                        histogram[n] = histogram[n] / sum;
                        if (histogram[j2] > max) {
                            max = histogram[j2];
                        }
                        ++j2;
                    }
                    int n = i++;
                    weight[n] = weight[n] * max;
                }
                re = new REnvironment();
                re.voidEval("require(hexbin)");
                re.createVector("sd", sd);
                re.createVector("summit", summit);
                re.createVector("weight", weight);
                re.createVector("no", no);
                re.createVector("closest", closest);
                re.plotToPDF("hist(closest);", String.valueOf(home) + factor + "-hist-differences.pdf", true);
                re.plotToPDF("plot(hexbin(weight,no),trans=log,inv=exp)", String.valueOf(home) + factor + "-hexbin-weight-no.pdf", true);
                re.plotToPDF("plot(hexbin(weight,closest),trans=log,inv=exp)", String.valueOf(home) + factor + "-hexbin-weight-difference.pdf", true);
                re.plotToPDF("plot(hexbin(weight,sd),trans=log,inv=exp)", String.valueOf(home) + factor + "-hexbin-weight-sd.pdf", true);
                re.plotToPDF("plot(hexbin(sd,closest))", String.valueOf(home) + factor + "-hexbin-sd-difference.pdf", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (re != null) {
                    re.close();
                }
            }
        }
        finally {
            if (re != null) {
                re.close();
            }
        }
    }
}

