/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.neuralNetworks.activationFunctions;

import de.jstacs.classifiers.neuralNetworks.activationFunctions.ActivationFunction;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class HyperbolicTangentActivationFunction
implements ActivationFunction {
    private double beta;

    public HyperbolicTangentActivationFunction(double beta) {
        this.beta = beta;
    }

    public HyperbolicTangentActivationFunction(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.beta = XMLParser.extractObjectForTags(xml, "beta", Double.TYPE);
    }

    @Override
    public String getName() {
        return "Hyperbolic tangent with beta=" + this.beta;
    }

    @Override
    public double getValue(double x) {
        return Math.tanh(this.beta * x);
    }

    @Override
    public double getDerivation(double x) {
        double a = Math.tanh(this.beta * x);
        return this.beta * (1.0 - a * a);
    }

    @Override
    public double getPositiveValue() {
        return 1.0;
    }

    @Override
    public double getNegativeValue() {
        return -1.0;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.beta, "beta");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }
}

