/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.initialization.PopulationInitializer;
import de.jstacs.optimization.geneticAlgorithms.operations.Crossover;
import de.jstacs.optimization.geneticAlgorithms.operations.Mutation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;

public class GeneticAlgorithm<T extends Individual> {
    private PopulationInitializer<T> initializer;
    private Mutation<T> mutation;
    private Crossover<T> crossover;
    private IndividualSelection<T> selection;
    private FitnessFunction<T> fitness;
    private Population<T> finalPopulation;

    public GeneticAlgorithm(PopulationInitializer<T> initializer, Mutation<T> mutation, Crossover<T> crossover, IndividualSelection<T> selection, FitnessFunction<T> fitness) {
        this.initializer = initializer;
        this.mutation = mutation;
        this.crossover = crossover;
        this.selection = selection;
        this.fitness = fitness;
    }

    protected Population<T> getBaseForMutation(int nElite, int nCo, int nPop, Population<T> previous, Population<T> afterCrossover) {
        Population<T> bestBreeded = null;
        if (nElite > 0) {
            if (nElite + nCo > nPop) {
                bestBreeded = afterCrossover.getBestIndividuals(nPop - nElite);
            } else if (nElite + nCo < nPop) {
                Population<T> remain = previous.removeDuplicates().getWorstIndividuals(nPop - nElite).getBestIndividuals(nPop - nElite - nCo);
                bestBreeded = afterCrossover.join(remain);
            } else {
                bestBreeded = afterCrossover;
            }
        } else {
            Population<T> bestOld = previous.removeDuplicates().getBestIndividuals(nPop - nCo);
            bestBreeded = afterCrossover.join(bestOld);
        }
        return bestBreeded;
    }

    public void optimize(int numGeneration, int sizePopulation) throws Exception {
        Population<T> population = this.initializer.getInitialPopulation(sizePopulation, this.fitness);
        double percentElitism = 0.2;
        SafeOutputStream printer = SafeOutputStream.getSafeOutputStream(SafeOutputStream.DEFAULT_STREAM);
        SafeOutputStream silent = SafeOutputStream.getSafeOutputStream(null);
        double currFitness = 0.0;
        double lastFitness = 0.0;
        int it = 0;
        int eq = 0;
        Time t = Time.getTimeInstance(null);
        t.reset();
        while (it < numGeneration && (double)eq < (double)numGeneration / 10.0) {
            Population<T> co = this.crossover.getCrossoverPopulation(population, this.fitness, this.selection);
            co.sortIndividuals();
            Population<T> newPopulation = null;
            int nElite = (int)Math.ceil(percentElitism * (double)population.getNumberOfIndivuals());
            int nPop = population.getNumberOfIndivuals();
            int nCo = co.getNumberOfIndivuals();
            Population<T> elite = population.removeDuplicates().getBestIndividuals(nElite);
            Population<T> bestBreeded = this.getBaseForMutation(nElite, nCo, nPop, population, co);
            bestBreeded = this.mutation.getMutatedPopulation(bestBreeded, this.fitness);
            newPopulation = elite.join(bestBreeded);
            newPopulation.sortIndividuals();
            lastFitness = currFitness;
            currFitness = newPopulation.getIndividual(0).getFitness();
            printer.writeln(String.valueOf(t.getElapsedTime()) + "\t" + newPopulation.getNumberOfIndivuals() + " " + currFitness);
            eq = currFitness == lastFitness ? ++eq : 0;
            population = newPopulation;
            if (it % 100 == 0) {
                this.fitness.setOutputStream(printer);
                this.fitness.getFitness(newPopulation.getIndividual(0));
                this.fitness.setOutputStream(silent);
                System.out.println(newPopulation);
            }
            ++it;
        }
        this.finalPopulation = population;
    }

    public Population<T> getFinalPopulation() {
        return this.finalPopulation;
    }
}

