/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.operations;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.operations.Operation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import java.util.LinkedList;
import java.util.Random;

public class SimpleInDel<T extends Individual>
implements Operation<T> {
    protected static Random r = new Random();
    protected double rate;

    public SimpleInDel(double rate) {
        this.rate = rate;
    }

    protected int drawNumberOfMutations(T individual) {
        int length = individual.getDimension();
        double ra = r.nextDouble();
        int num = 1 + (int)Math.ceil(Math.log(2.0 * (1.0 - ra) + Math.pow(0.5, length - 1) * ra) / Math.log(0.5));
        return num;
    }

    protected int drawSymbol(T individual, int dimension) {
        AlphabetContainer con = individual.getEncoding();
        return r.nextInt((int)con.getAlphabetLengthAt(dimension));
    }

    @Override
    public Population<T> getModifiedPopulation(Population<T> original, FitnessFunction<T> fun, IndividualSelection<T> select) throws Exception {
        LinkedList<Object> ind = new LinkedList<Object>();
        original = select.selectIndividuals(original, (int)Math.ceil((double)original.getNumberOfIndivuals() * this.rate));
        int i = 0;
        while (i < original.getNumberOfIndivuals()) {
            int j;
            int dim;
            Object in = original.getIndividual(i);
            int[] vals = new int[in.getDimension()];
            int num = this.drawNumberOfMutations(in);
            double rn = r.nextDouble();
            if (rn <= 0.25) {
                dim = r.nextInt(vals.length - num);
                j = 0;
                while (j < dim) {
                    vals[j] = in.getValueAt(j);
                    ++j;
                }
                j = 0;
                while (j < num && j < vals.length) {
                    vals[j] = this.drawSymbol(in, j + dim);
                    ++j;
                }
                j = dim + num;
                while (j < vals.length) {
                    vals[j] = in.getValueAt(j - num);
                    ++j;
                }
            } else if (rn <= 0.5) {
                dim = r.nextInt(vals.length - num);
                j = 0;
                while (j < dim) {
                    vals[j] = in.getValueAt(j);
                    ++j;
                }
                j = dim + num;
                while (j < in.getDimension()) {
                    vals[j - num] = in.getValueAt(j);
                    ++j;
                }
                j = in.getDimension() - num;
                while (j < vals.length) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
            } else if (rn <= 0.75) {
                dim = num + r.nextInt(vals.length - num);
                j = 0;
                while (j < dim - num) {
                    vals[j] = in.getValueAt(j + num);
                    ++j;
                }
                j = dim - num;
                while (j < dim) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
                j = dim;
                while (j < vals.length) {
                    vals[j] = in.getValueAt(j);
                    ++j;
                }
            } else {
                dim = num + r.nextInt(vals.length - num);
                j = 0;
                while (j < num) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
                j = 0;
                while (j < dim - num) {
                    vals[j + num] = in.getValueAt(j);
                    ++j;
                }
                j = dim;
                while (j < vals.length) {
                    vals[j] = in.getValueAt(j);
                    ++j;
                }
            }
            in = in.getIndividual(vals);
            in.setFitness(fun);
            ind.add(in);
            ++i;
        }
        return original.getPopulation(ind);
    }
}

