/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.populations.individuals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;

public class DiscreteSequenceIndividual
implements Individual {
    protected SimpleDiscreteSequence sequence;
    private Double fitness;

    public DiscreteSequenceIndividual(SimpleDiscreteSequence seq) {
        this.sequence = seq;
    }

    @Override
    public DiscreteSequenceIndividual getIndividual(int[] vals) throws Exception {
        return new DiscreteSequenceIndividual(new IntSequence(this.sequence.getAlphabetContainer(), vals));
    }

    @Override
    public AlphabetContainer getEncoding() {
        return this.sequence.getAlphabetContainer();
    }

    @Override
    public int getDimension() {
        return this.sequence.getLength();
    }

    @Override
    public int getValueAt(int dimension) {
        return this.sequence.discreteVal(dimension);
    }

    public SimpleDiscreteSequence getSequence() {
        return this.sequence;
    }

    @Override
    public Individual mutate(int dimension, int value) throws WrongAlphabetException, WrongSequenceTypeException {
        if (!this.sequence.getAlphabetContainer().isEncodedSymbol(dimension, value)) {
            throw new RuntimeException();
        }
        int[] original = new int[this.sequence.getLength()];
        int i = 0;
        while (i < original.length) {
            original[i] = i == dimension ? value : this.sequence.discreteVal(i);
            ++i;
        }
        IntSequence seq = new IntSequence(this.sequence.getAlphabetContainer(), original);
        return new DiscreteSequenceIndividual(seq);
    }

    @Override
    public Individual crossover(int crossdim, Individual second) throws WrongAlphabetException, WrongSequenceTypeException {
        if (this.sequence.getLength() == second.getDimension() && (this.sequence.getAlphabetContainer() == second.getEncoding() || this.sequence.getAlphabetContainer().checkConsistency(second.getEncoding()))) {
            int[] original = new int[this.sequence.getLength()];
            int i = 0;
            while (i < original.length) {
                original[i] = i > crossdim ? second.getValueAt(i) : this.sequence.discreteVal(i);
                ++i;
            }
            IntSequence seq = new IntSequence(this.sequence.getAlphabetContainer(), original);
            return new DiscreteSequenceIndividual(seq);
        }
        throw new RuntimeException();
    }

    @Override
    public synchronized double getFitness() {
        while (this.fitness == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.fitness;
    }

    public void setFitness(FitnessFunction fun) throws Exception {
        this.fitness = fun.getFitness(this);
    }

    @Override
    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public String toString() {
        return String.valueOf(this.sequence.toString()) + " " + this.fitness;
    }

    @Override
    public double getHammingDistance(Individual second) {
        if (second instanceof DiscreteSequenceIndividual) {
            try {
                return this.sequence.getHammingDistance(((DiscreteSequenceIndividual)second).getSequence());
            }
            catch (WrongAlphabetException e) {
                return Double.POSITIVE_INFINITY;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int getFirstDifferentDimension(Individual second) {
        if (second instanceof DiscreteSequenceIndividual) {
            SimpleDiscreteSequence secSeq = ((DiscreteSequenceIndividual)second).getSequence();
            int i = 0;
            while (i < this.sequence.getLength() && i < secSeq.getLength() && secSeq.discreteVal(i) == this.sequence.discreteVal(i)) {
                ++i;
            }
            return i;
        }
        return 0;
    }

    @Override
    public int getLastDifferentDimension(Individual second) {
        if (second instanceof DiscreteSequenceIndividual) {
            SimpleDiscreteSequence secSeq = ((DiscreteSequenceIndividual)second).getSequence();
            if (secSeq.getLength() != this.sequence.getLength()) {
                return Math.min(secSeq.getLength(), this.sequence.getLength());
            }
            int i = this.sequence.getLength() - 1;
            while (i > 0 && secSeq.discreteVal(i) == this.sequence.discreteVal(i)) {
                --i;
            }
            return i;
        }
        return 0;
    }

    @Override
    public int compareTo(Individual arg0) {
        return Double.compare(arg0.getFitness(), this.getFitness());
    }

    @Override
    public boolean equals(Individual second) {
        if (second instanceof DiscreteSequenceIndividual) {
            return this.sequence.equals(((DiscreteSequenceIndividual)second).sequence);
        }
        return false;
    }

    public int hashCode() {
        return this.sequence.hashCode();
    }
}

