/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.AbstractMixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.util.HashMap;

public abstract class AbstractChIPper
extends AbstractMixtureDiffSM
implements MutableMotifDiscoverer {
    protected double logP;
    protected int[] endIndex;
    protected HashMap<Sequence, float[][]> positionHash;

    public AbstractChIPper(int starts, DifferentiableStatisticalModel ... motif) throws CloneNotSupportedException {
        super(0, starts, motif.length + 1, true, true, motif);
        this.init();
    }

    public AbstractChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    protected void init() {
        this.logP = -Math.log(this.function[0].getAlphabetContainer().getAlphabetLengthAt(0));
        this.positionHash = new HashMap();
        this.endIndex = new int[this.function.length];
    }

    @Override
    public AbstractChIPper clone() throws CloneNotSupportedException {
        AbstractChIPper clone = (AbstractChIPper)super.clone();
        clone.positionHash = new HashMap();
        for (Sequence s : this.positionHash.keySet()) {
            clone.positionHash.put(s, (float[][])ArrayHandler.clone((Cloneable[])this.positionHash.get(s)));
        }
        clone.endIndex = (int[])this.endIndex.clone();
        return clone;
    }

    @Override
    protected boolean determineIsNormalized() {
        return false;
    }

    protected Sequence getReference(Sequence seq) {
        SequenceAnnotation seqAn = seq.getSequenceAnnotationByType("reference", 0);
        return seqAn == null ? null : ((ReferenceSequenceAnnotation)seqAn).getReferenceSequence();
    }

    protected float[] getPosition(int motif, Sequence seq, boolean add) {
        Object res = this.positionHash.get(seq);
        if (res == null) {
            res = new float[this.function.length][];
        }
        if (res[motif] == null) {
            Sequence ref = this.getReference(seq);
            if (ref != null) {
                res[motif] = new float[seq.getLength() - this.function[motif].getLength() + 1];
                float sum = 0.0f;
                int i = 0;
                while (i < res[motif].length) {
                    res[motif][i] = (float)ref.continuousVal(i);
                    sum += res[motif][i];
                    ++i;
                }
                i = 0;
                while (i < res[motif].length) {
                    res[motif][i] = (float)Math.log(res[motif][i] / sum);
                    ++i;
                }
            }
            if (add) {
                this.positionHash.put(seq, (float[][])res);
            }
        }
        return res[motif];
    }

    @Override
    public double getHyperparameterForHiddenParameter(int index) {
        if (index < this.function.length) {
            return this.function[index].getESS();
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.function.length) {
            sum += this.function[i].getESS();
            ++i;
        }
        return sum;
    }

    @Override
    protected double getLogNormalizationConstantForComponent(int i) {
        if (i < this.function.length) {
            return this.function[i].getLogNormalizationConstant();
        }
        return 0.0;
    }

    public static int draw(DataSet d, double[] weight) {
        if (weight == null) {
            return r.nextInt(d.getNumberOfElements());
        }
        return AbstractChIPper.draw(weight);
    }

    public static int draw(double[] weight) {
        double s = r.nextDouble() * ToolBox.sum(weight);
        int i = 0;
        while (weight[i] < s) {
            s -= weight[i];
            ++i;
        }
        return i;
    }

    @Override
    protected void initializeUsingPlugIn(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        int num = this.getNumberOfMotifs();
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double d = 0.1 / (double)(a - 1);
        d = (1.0 - (double)a * d) / ((double)a * d);
        int motif = 0;
        while (motif < num) {
            int p;
            int l = this.function[motif].getLength();
            int s = AbstractChIPper.draw(data[index], weights == null ? null : weights[index]);
            Sequence seq = data[index].getElementAt(s);
            Sequence ref = this.getReference(seq);
            if (ref == null) {
                p = r.nextInt(seq.getLength() - l + 1);
            } else {
                double[] prof = new double[seq.getLength() - this.function[motif].getLength()];
                int i = 0;
                while (i < prof.length) {
                    prof[i] = ref.continuousVal(i);
                    ++i;
                }
                p = AbstractChIPper.draw(prof);
            }
            seq = seq.getSubSequence(p, l);
            double h = d * this.function[motif].getESS();
            this.function[motif].initializeFunction(0, freeParams, new DataSet[]{new DataSet("", seq)}, new double[][]{{h}});
            ++motif;
        }
        this.initializeHiddenUniformly();
        this.positionHash.clear();
    }

    @Override
    public double getESS() {
        double ess = 0.0;
        int i = 0;
        while (i <= this.function.length) {
            ess += this.getHyperparameterForHiddenParameter(i);
            ++i;
        }
        return ess;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        int[] ind;
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        double res = (ind = this.getIndices(parameterIndex))[0] == this.function.length ? this.partNorm[ind[1]] : this.logHiddenPotential[ind[0]] + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]);
        return res;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        return component;
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        return this.getIndexOfMaximalComponentFor(sequence, 0);
    }

    @Override
    public int getMotifLength(int motif) {
        return this.function[motif].getLength();
    }

    @Override
    public int getNumberOfMotifs() {
        return this.function.length;
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        if (component < this.function.length) {
            return 1;
        }
        return 0;
    }

    protected abstract int fillComponentScoreOf(double[] var1, int var2, Sequence var3, int var4);

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l >= 0) {
                res = new double[l + 1];
                int end = this.fillComponentScoreOf(res, component, sequence, startpos);
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, res);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                int i = 0;
                while (i < res.length) {
                    int n = i++;
                    res[n] = res[n] + d;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (motif > 0 || component > this.function.length) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        if (m instanceof StrandDiffSM) {
            if (startpos == 0) {
                return ((StrandDiffSM)m).getProbsForComponent(sequence);
            }
            return ((StrandDiffSM)m).getProbsForComponent(sequence.getSubSequence(startpos));
        }
        return new double[]{1.0, 0.0};
    }

    @Override
    public void adjustHiddenParameters(int index, DataSet[] data, double[][] weights) throws Exception {
    }

    @Override
    public void initializeMotif(int motifIndex, DataSet data, double[] weights) throws Exception {
        this.function[motifIndex].initializeFunction(0, this.freeParams, new DataSet[]{data}, new double[][]{weights});
        this.init(this.freeParams);
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        this.function[motif].initializeFunctionRandomly(this.freeParams);
        this.init(this.freeParams);
    }

    @Override
    protected void init(boolean freeParams) {
        super.init(freeParams);
        if (this.positionHash != null) {
            this.positionHash.clear();
        }
    }

    @Override
    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        if (this.function[motifIndex] instanceof Mutable) {
            double norm_old = this.function[motifIndex].getLogNormalizationConstant();
            boolean res = ((Mutable)((Object)this.function[motifIndex])).modify(offsetLeft, offsetRight);
            if (res) {
                this.init(this.freeParams);
                double norm_new = this.function[motifIndex].getLogNormalizationConstant();
                int n = motifIndex;
                this.hiddenParameter[n] = this.hiddenParameter[n] + (norm_old - norm_new);
                this.setHiddenParameters(this.hiddenParameter, 0);
                this.norm = Double.NaN;
            }
            return res;
        }
        return false;
    }

    @Override
    public String toString() {
        throw new Error("Unresolved compilation problem: \n\tCannot override the final method from AbstractDifferentiableStatisticalModel\n");
    }
}

