/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.OrderNDistributionFactory;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public final class GATools {
    private static SimpleAlphabet binary;
    private static AtomicSymbol zero;
    private static AtomicSymbol one;

    public static FiniteAlphabet getBinaryAlphabet() {
        return binary;
    }

    public static AtomicSymbol one() {
        return one;
    }

    public static SymbolList createBinary(String binarySequence) throws IllegalSymbolException {
        SymbolTokenization toke = null;
        try {
            toke = GATools.getBinaryAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Cannot make binary tokenization", ex);
        }
        return new SimpleSymbolList(toke, binarySequence);
    }

    public static AtomicSymbol zero() {
        return zero;
    }

    public static OrderNDistribution uniformMutationDistribution(FiniteAlphabet a) throws IllegalAlphabetException {
        List<FiniteAlphabet> l = Collections.nCopies(2, a);
        Alphabet alpha = AlphabetManager.getCrossProductAlphabet(l);
        OrderNDistribution d = (OrderNDistribution)OrderNDistributionFactory.DEFAULT.createDistribution(alpha);
        AlphabetIndex ind = AlphabetManager.getAlphabetIndex(a);
        UniformDistribution u = new UniformDistribution(a);
        for (int i = 0; i < a.size(); ++i) {
            try {
                d.setDistribution(ind.symbolForIndex(i), u);
                continue;
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex);
            }
        }
        return d;
    }

    public static OrderNDistribution standardMutationDistribution(FiniteAlphabet a) throws IllegalAlphabetException {
        List<FiniteAlphabet> l = Collections.nCopies(2, a);
        Alphabet alpha = AlphabetManager.getCrossProductAlphabet(l);
        OrderNDistribution d = (OrderNDistribution)OrderNDistributionFactory.DEFAULT.createDistribution(alpha);
        AlphabetIndex ind = AlphabetManager.getAlphabetIndex(a);
        for (int i = 0; i < a.size(); ++i) {
            try {
                Distribution sub_dist = d.getDistribution(ind.symbolForIndex(i));
                AlphabetIndex ind2 = AlphabetManager.getAlphabetIndex(a);
                for (int j = 0; j < a.size(); ++j) {
                    if (ind.symbolForIndex(i) == ind2.symbolForIndex(j)) {
                        sub_dist.setWeight(ind2.symbolForIndex(j), 0.0);
                        continue;
                    }
                    sub_dist.setWeight(ind2.symbolForIndex(j), 1.0 / (double)(a.size() - 1));
                }
                continue;
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex);
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex);
            }
        }
        return d;
    }

    static {
        zero = AlphabetManager.createSymbol("zero");
        one = AlphabetManager.createSymbol("one");
        HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
        syms.add(zero);
        syms.add(one);
        binary = new SimpleAlphabet(syms, "GA_Binary");
        CharacterTokenization tk = new CharacterTokenization(binary, false);
        tk.bindSymbol(zero, '0');
        tk.bindSymbol(one, '1');
        binary.putTokenization("token", tk);
        AlphabetManager.registerAlphabet(binary.getName(), (Alphabet)binary);
    }
}

