/*
 * Decompiled with CFR 0.152.
 */
package projects.dnaInstability;

import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.REnvironment;
import java.util.Arrays;

public class DNAInstability {
    private static double[][] stacking = new double[][]{{-1.49, -2.19, -1.44, -1.72}, {-0.93, -1.82, -1.29, -1.44}, {-1.81, -2.55, -1.82, -2.19}, {-0.57, -1.81, -0.93, -1.49}};
    private static double[] binding = new double[]{0.64, 0.12, 0.12, 0.64};
    static double R = 0.0019872041456665754;
    private double[][] stackBoltz = (double[][])ArrayHandler.clone((Cloneable[])stacking);
    private double[] bindBoltz = (double[])binding.clone();

    public DNAInstability(double tempK) throws CloneNotSupportedException {
        int i = 0;
        while (i < this.stackBoltz.length) {
            int j = 0;
            while (j < this.stackBoltz[i].length) {
                double[] dArray = this.stackBoltz[i];
                int n = j++;
                dArray[n] = dArray[n] / (R * tempK);
            }
            int n = i++;
            this.bindBoltz[n] = this.bindBoltz[n] / (R * tempK);
        }
    }

    public double computeLogG(int start, Sequence seq, int stateI, int stateIp1) {
        double val = (double)stateI * this.bindBoltz[seq.discreteVal(start)];
        if (start < seq.getLength() - 1) {
            val += (double)(stateIp1 == 0 ? stateI : 0) * this.stackBoltz[seq.discreteVal(start)][seq.discreteVal(start + 1)];
        }
        if (start > 0) {
            val += (double)stateI * this.stackBoltz[seq.discreteVal(start - 1)][seq.discreteVal(start)];
        }
        return val;
    }

    public double[][] computeForward(Sequence seq) {
        double[][] f = new double[seq.getLength() + 1][2];
        f[0][0] = 0.0;
        f[0][1] = 0.0;
        int i = 1;
        while (i <= seq.getLength()) {
            f[i][0] = Normalisation.getLogSum(this.computeLogG(i - 1, seq, 0, 0) + f[i - 1][0], this.computeLogG(i - 1, seq, 1, 0) + f[i - 1][1]);
            f[i][1] = Normalisation.getLogSum(this.computeLogG(i - 1, seq, 0, 1) + f[i - 1][0], this.computeLogG(i - 1, seq, 1, 1) + f[i - 1][1]);
            ++i;
        }
        return f;
    }

    public double[][] computeBackward(Sequence seq) {
        double[][] b = new double[seq.getLength()][2];
        b[b.length - 1][0] = this.computeLogG(seq.getLength() - 1, seq, 0, 1);
        b[b.length - 1][1] = this.computeLogG(seq.getLength() - 1, seq, 1, 1);
        int i = seq.getLength() - 2;
        while (i >= 0) {
            b[i][0] = Normalisation.getLogSum(this.computeLogG(i, seq, 0, 0) + b[i + 1][0], this.computeLogG(i, seq, 0, 1) + b[i + 1][1]);
            b[i][1] = Normalisation.getLogSum(this.computeLogG(i, seq, 1, 0) + b[i + 1][0], this.computeLogG(i, seq, 1, 1) + b[i + 1][1]);
            --i;
        }
        return b;
    }

    public double[][] getMeanOpeningProfile(DataSet data, int maxOpen) {
        if (data == null) {
            return null;
        }
        if (data.getElementLength() == 0) {
            return null;
        }
        double n = Math.log(data.getNumberOfElements());
        double[][] mean = new double[data.getElementLength()][maxOpen];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            double[][] o = this.computeOpeningProfile(data.getElementAt(i), maxOpen);
            int j = 0;
            while (j < o.length) {
                int k = 0;
                while (k < o[j].length) {
                    mean[j][k] = i == 0 ? o[j][k] : Normalisation.getLogSum(mean[j][k], o[j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < mean.length) {
            int j = 0;
            while (j < mean[i].length) {
                double[] dArray = mean[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] - n;
            }
            ++i;
        }
        return mean;
    }

    public double[][] computeOpeningProfile(Sequence seq, int maxOpen) {
        double[][] f = this.computeForward(seq);
        double[][] b = this.computeBackward(seq);
        double[][] o = new double[seq.getLength()][maxOpen];
        double norm = f[f.length - 1][0];
        int i = 0;
        while (i < o.length) {
            double tempO = 0.0;
            Arrays.fill(o[i], Double.NaN);
            int l = 0;
            while (l < maxOpen && i + l < seq.getLength()) {
                o[i][l] = f[i][1] + tempO + b[i + l][1] - norm;
                tempO += this.computeLogG(i + l, seq, 1, 1);
                ++l;
            }
            ++i;
        }
        return o;
    }

    private static double[][] shift(double[][] profile) {
        int j;
        double[][] temp = new double[profile.length][profile[0].length];
        int i = 0;
        while (i < temp.length) {
            j = 0;
            while (j < temp[i].length) {
                temp[i][j] = Double.NaN;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < temp.length) {
            j = 0;
            while (j < profile[i].length) {
                if (i + (int)Math.round((double)j / 2.0) < temp.length) {
                    temp[i + (int)Math.round((double)((double)j / 2.0))][j] = profile[i][j];
                }
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public double[][] getBaselineProfile(int n, int length, int maxOpen, DataSet ... dss) throws Exception {
        HomogeneousMM mm = null;
        if (dss.length == 0) {
            mm = new HomogeneousMM(new HomMMParameterSet(DNAAlphabetContainer.SINGLETON, 0.0, "", 0));
            mm.train(new DataSet("", Sequence.create(DNAAlphabetContainer.SINGLETON, "ACGT")));
        } else {
            mm = new HomogeneousMM(new HomMMParameterSet(DNAAlphabetContainer.SINGLETON, 0.0, "", 2));
            mm.train(DataSet.union(dss));
        }
        DataSet ds = mm.emitDataSet(n, length);
        return this.getMeanOpeningProfile(ds, maxOpen);
    }

    public static void plot(double[][] baseline, REnvironment re, String fileName, int width, int height, String[] names, double[][] ... profiles) throws Exception {
        re.createMatrix("baseline", DNAInstability.shift(baseline));
        re.voidEval("m<-log(colMeans(exp(baseline),na.rm=T));");
        StringBuffer sb = new StringBuffer();
        re.voidEval("zlim<-c(Inf,-Inf);");
        int i = 0;
        while (i < profiles.length) {
            re.createMatrix("profile" + i, DNAInstability.shift(profiles[i]));
            re.voidEval("profile" + i + "[is.nan(profile" + i + ")]<-NA;");
            re.voidEval("profile" + i + "<-profile" + i + "[(ncol(profile" + i + ")*2):(nrow(profile" + i + ")-ncol(profile" + i + ")*2),];" + "profile" + i + "<-t(t(profile" + i + ") - m);");
            re.voidEval("zlim<-c(min(zlim[1],profile" + i + ",na.rm=T),max(zlim[2],profile" + i + ",na.rm=T));");
            sb.append("image(1:nrow(profile" + i + ")+ncol(profile" + i + ")*2,1:ncol(profile" + i + "),profile" + i + ",xlab=\"Position\",ylab=\"Opening width\",zlim=zlim,col=topo.colors(256),main=\"" + names[i] + "\");");
            ++i;
        }
        re.voidEval("print(zlim);");
        re.plotToPDF(sb.toString(), width, height, fileName, true);
    }
}

