/*
 * Decompiled with CFR 0.152.
 */
package projects.mirnas;

import de.jstacs.Storable;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public class MiRNAPredictor {
    private BackgroundDistributionLibrary lib;

    public MiRNAPredictor(DataSet bgSample, DataSet miRNAs, int windowWidth, AbstractScoreBasedClassifier classifier) throws Exception {
        this.lib = new BackgroundDistributionLibrary(bgSample, miRNAs, windowWidth, classifier);
    }

    public MiRNAPredictor(DataSet fgSample, int fakeLength, DataSet miRNAs, int windowWidth, AbstractScoreBasedClassifier classifier) throws Exception {
        this.lib = new BackgroundDistributionLibrary(fgSample, fakeLength, miRNAs, windowWidth, classifier);
    }

    public MiRNAPredictor(String libFile) throws NonParsableException, IOException {
        this.lib = new BackgroundDistributionLibrary(FileManager.readFile(new File(libFile)));
    }

    public MiRNAPredictor(BackgroundDistributionLibrary lib) {
        this.lib = lib;
    }

    public Pair<Integer, double[]>[][] predict(Sequence miRNA, DataSet data, double pVal) throws Exception {
        Pair[][] res = new Pair[data.getNumberOfElements()][];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            res[i] = this.predict(miRNA, seq, pVal);
            ++i;
        }
        return res;
    }

    public Pair<Integer, double[]>[] predictBest(Sequence miRNA, Sequence seq) throws Exception {
        AbstractScoreBasedClassifier cl = this.lib.getClassifier();
        int windowWidth = this.lib.getWindowWidth();
        LinkedList pred = new LinkedList();
        pred.clear();
        int bestPos = -1;
        double bestScore = Double.NEGATIVE_INFINITY;
        int j = 0;
        while (j < seq.getLength() - windowWidth + 1) {
            SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{new ReferenceSequenceAnnotation("seq", miRNA, new Result[0])};
            Sequence sub = seq.getSubSequence(j, windowWidth).reverse().annotate(false, sequenceAnnotationArray);
            double score = cl.getScore(sub, 0) - cl.getScore(sub, 1);
            if (score > bestScore) {
                bestScore = score;
                bestPos = j;
            }
            ++j;
        }
        double p = this.lib.getDistributionFor(miRNA).getPValueForScore(bestScore);
        return new Pair[]{new Pair<Integer, double[]>(bestPos, new double[]{p, -Math.log(p), bestScore})};
    }

    public Pair<Integer, double[]>[] predict(Sequence miRNA, Sequence seq, double pVal) throws Exception {
        double thresh = this.lib.getDistributionFor(miRNA).getThresholdForFPR(pVal);
        AbstractScoreBasedClassifier cl = this.lib.getClassifier();
        int windowWidth = this.lib.getWindowWidth();
        LinkedList<Pair<Integer, double[]>> pred = new LinkedList<Pair<Integer, double[]>>();
        pred.clear();
        int j = 0;
        while (j < seq.getLength() - windowWidth + 1) {
            SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{new ReferenceSequenceAnnotation("seq", miRNA, new Result[0])};
            Sequence sub = seq.getSubSequence(j, windowWidth).reverse().annotate(false, sequenceAnnotationArray);
            double score = cl.getScore(sub, 0) - cl.getScore(sub, 1);
            if (score > thresh) {
                double p = this.lib.getDistributionFor(miRNA).getPValueForScore(score);
                pred.add(new Pair<Integer, double[]>(j, new double[]{p, -Math.log(p), score}));
            }
            ++j;
        }
        return pred.toArray(new Pair[0]);
    }

    public void saveLibrary(String libFile) throws IOException {
        FileManager.writeFile(new File(libFile), (CharSequence)this.lib.toXML());
    }

    public void saveLibraries(String libPrefix) throws IOException {
        this.lib.saveLibraries(libPrefix);
    }

    private static class BackgroundDistribution
    implements Storable {
        private double[] scores;

        public BackgroundDistribution(DataSet bgSample, AbstractScoreBasedClassifier classifier) throws Exception {
            this.fillScoresFor(bgSample, classifier);
        }

        public double getPValueForScore(double score) {
            int i = this.scores.length - 1;
            while (i >= 0) {
                if (this.scores[i] < score) {
                    return (double)(this.scores.length - i - 1) / (double)this.scores.length;
                }
                --i;
            }
            return 1.0;
        }

        public BackgroundDistribution(StringBuffer xml) throws NonParsableException {
            xml = XMLParser.extractForTag(xml, "BackgroundDistribution");
            this.scores = XMLParser.extractObjectForTags(xml, "scores", double[].class);
        }

        private void fillScoresFor(DataSet sample, AbstractScoreBasedClassifier classifier) throws Exception {
            this.scores = classifier.getScores(sample);
            Arrays.sort(this.scores);
        }

        public double getThresholdForFPR(double fpr) {
            return this.scores[(int)Math.floor((1.0 - fpr) * (double)this.scores.length)];
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.scores, "scores");
            XMLParser.addTags(xml, "BackgroundDistribution");
            return xml;
        }
    }

    public static class BackgroundDistributionLibrary
    implements Storable {
        private HashMap<Sequence, BackgroundDistribution> map;
        private AbstractScoreBasedClassifier classifier;
        private DataSet bgSample;

        public BackgroundDistributionLibrary(DataSet bgSample, DataSet miRNAs, int windowWidth, AbstractScoreBasedClassifier classifier) throws Exception {
            this.bgSample = this.check(bgSample, windowWidth);
            this.classifier = classifier;
            this.map = new HashMap();
            this.fillLibrary(miRNAs);
        }

        public BackgroundDistributionLibrary(String libPrefix, DataSet bgSample, int windowWidth, AbstractScoreBasedClassifier classifier, DataSet miRNAs) throws NonParsableException, IOException, EmptyDataSetException, WrongAlphabetException, WrongLengthException, OperationNotSupportedException {
            this.map = new HashMap();
            this.bgSample = this.check(bgSample, windowWidth);
            this.classifier = classifier;
            this.restoreLibraries(libPrefix, miRNAs);
        }

        public BackgroundDistributionLibrary(String libPrefix, DataSet fgSample, int fakeLength, int windowWidth, AbstractScoreBasedClassifier classifier, DataSet miRNAs) throws Exception {
            this.map = new HashMap();
            fgSample = BackgroundDistributionLibrary.fakeSample(fgSample, fakeLength);
            this.bgSample = this.check(fgSample, windowWidth);
            this.classifier = classifier;
            this.restoreLibraries(libPrefix, miRNAs);
        }

        public void saveLibraries(String libPrefix) throws IOException {
            for (Sequence key : this.map.keySet()) {
                FileManager.writeFile(new File(String.valueOf(libPrefix) + "_" + key.toString() + ".lib"), (CharSequence)this.map.get(key).toXML());
            }
        }

        public void restoreLibraries(String libPrefix, DataSet miRNAs) throws NonParsableException, IOException {
            for (Sequence key : miRNAs) {
                this.map.put(key, new BackgroundDistribution(FileManager.readFile(new File(String.valueOf(libPrefix) + "_" + key.toString() + ".lib"))));
            }
        }

        private DataSet check(DataSet bgSample2, int windowWidth) throws EmptyDataSetException, WrongAlphabetException, WrongLengthException, OperationNotSupportedException {
            int i;
            DataSet sam = null;
            if (bgSample2.getMinimalElementLength() < windowWidth) {
                LinkedList<Sequence> list = new LinkedList<Sequence>();
                i = 0;
                while (i < bgSample2.getNumberOfElements()) {
                    Sequence seq = bgSample2.getElementAt(i);
                    if (seq.getLength() >= windowWidth) {
                        list.add(seq);
                    }
                    ++i;
                }
                sam = new DataSet("", list.toArray(new Sequence[0]));
            } else {
                sam = bgSample2;
            }
            Sequence[] seqs = sam.getAllElements();
            i = 0;
            while (i < seqs.length) {
                seqs[i] = seqs[i].reverse();
                ++i;
            }
            sam = new DataSet("", seqs);
            sam = new DataSet(sam, windowWidth);
            return sam;
        }

        public int getWindowWidth() {
            return this.bgSample.getElementLength();
        }

        public AbstractScoreBasedClassifier getClassifier() {
            return this.classifier;
        }

        public BackgroundDistributionLibrary(DataSet fgSample, int fakeLength, DataSet miRNAs, int windowWidth, AbstractScoreBasedClassifier classifier) throws Exception {
            this(BackgroundDistributionLibrary.fakeSample(fgSample, fakeLength), miRNAs, windowWidth, classifier);
        }

        private static DataSet fakeSample(DataSet fgSample, int fakeLength) throws Exception {
            HomogeneousMM mm = new HomogeneousMM(new HomMMParameterSet(fgSample.getAlphabetContainer(), 0.0, "", 2));
            mm.train(fgSample);
            DataSet fakeSample = mm.emitDataSet(1, fakeLength);
            return fakeSample;
        }

        public BackgroundDistributionLibrary(StringBuffer xml) throws NonParsableException {
            xml = XMLParser.extractForTag(xml, "BackgroundDistributionLibrary");
            DataSetResult keyRes = XMLParser.extractObjectForTags(xml, "keys", DataSetResult.class);
            Sequence[] keys = keyRes.getValue().getAllElements();
            BackgroundDistribution[] bds = XMLParser.extractObjectForTags(xml, "values", BackgroundDistribution[].class);
            this.map = new HashMap();
            int i = 0;
            while (i < keys.length) {
                this.map.put(keys[i], bds[i]);
                ++i;
            }
            this.bgSample = XMLParser.extractObjectForTags(xml, "bgSample", DataSetResult.class).getValue();
            this.classifier = XMLParser.extractObjectForTags(xml, "classifier", AbstractScoreBasedClassifier.class);
        }

        private void fillLibrary(DataSet miRNAs) throws Exception {
            for (Sequence miRNA : miRNAs) {
                DataSet temp = BackgroundDistributionLibrary.annotate(this.bgSample, miRNA);
                this.map.put(miRNA, new BackgroundDistribution(temp, this.classifier));
            }
        }

        private BackgroundDistribution getDistributionFor(Sequence miRNA) {
            return this.map.get(miRNA);
        }

        private static DataSet annotate(DataSet s, Sequence mirna) throws Exception {
            Sequence[] seqs = s.getAllElements();
            int i = 0;
            while (i < seqs.length) {
                seqs[i] = seqs[i].annotate(false, new ReferenceSequenceAnnotation("seq", mirna, new Result[0]));
                ++i;
            }
            return new DataSet("", seqs);
        }

        @Override
        public StringBuffer toXML() {
            try {
                Sequence[] keys = this.map.keySet().toArray(new Sequence[0]);
                DataSet keySam = new DataSet("", keys);
                DataSetResult keyRes = new DataSetResult("keys", "", keySam);
                LinkedList<BackgroundDistribution> list = new LinkedList<BackgroundDistribution>();
                int i = 0;
                while (i < keys.length) {
                    list.add(this.map.get(keys[i]));
                    ++i;
                }
                BackgroundDistribution[] bds = list.toArray(new BackgroundDistribution[0]);
                StringBuffer xml = new StringBuffer();
                XMLParser.appendObjectWithTags(xml, keyRes, "keys");
                XMLParser.appendObjectWithTags(xml, bds, "values");
                XMLParser.appendObjectWithTags(xml, new DataSetResult("bgSample", "", this.bgSample), "bgSample");
                XMLParser.appendObjectWithTags(xml, this.classifier, "classifier");
                XMLParser.addTags(xml, "BackgroundDistributionLibrary");
                return xml;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

