/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import projects.talGA.MatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class SimpleMatchFinder
extends MatchFinder {
    private DataSet ds;
    private TALgetterDiffSM model;

    public SimpleMatchFinder(DataSet ds, TALgetterDiffSM model) {
        this.ds = ds;
        this.model = model;
        try {
            this.model.fix();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataSet(DataSet ds) {
        this.ds = ds;
        this.reset();
    }

    @Override
    public LimitedSortedList<MatchFinder.Match> getScoresAbove(Sequence tal, double thresh, int cap, boolean capBest, boolean rc) {
        LimitedSortedList<MatchFinder.Match> list = null;
        MatchFinder.HashEntry en = new MatchFinder.HashEntry(tal, thresh, cap, capBest);
        list = null;
        if (list == null) {
            list = new LimitedSortedList<MatchFinder.Match>(cap);
            int i = 0;
            while (i < this.ds.getNumberOfElements()) {
                Sequence seq = this.ds.getElementAt(i);
                if (list.getLength() >= cap) {
                    if (!capBest) {
                        System.out.println("break");
                        break;
                    }
                    if (list.getWorstScore() > thresh) {
                        thresh = list.getWorstScore();
                    }
                }
                if (rc) {
                    try {
                        seq = seq.reverseComplement();
                    }
                    catch (Exception e) {
                        throw new RuntimeException();
                    }
                }
                if (seq.getLength() > tal.getLength()) {
                    int j = 0;
                    while (j < seq.getLength() - tal.getLength()) {
                        double sc = this.model.getPartialLogScoreFor(tal, seq, j, 0, tal.getLength() + 1);
                        if (sc >= thresh && list.checkInsert(sc)) {
                            if (rc) {
                                list.insert(sc, new MatchFinder.Match(i, seq.getLength() - j - 1 - tal.getLength(), rc));
                            } else {
                                list.insert(sc, new MatchFinder.Match(i, j, rc));
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.hash(en, list, rc);
        }
        return list;
    }
}

