/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import javax.naming.OperationNotSupportedException;
import projects.talGA.InfixMatchFinder;
import projects.talGA.MatchFinder;
import projects.talGA.SimpleMatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class TALENTargetFinder {
    private MatchFinder finder;
    private DataSet ds;
    private TALgetterDiffSM model;

    public TALENTargetFinder(DataSet ds, TALgetterDiffSM model, int maxLength) {
        this.finder = MatchFinder.getMatchFinder(ds, model, maxLength);
        this.ds = ds;
        this.model = model;
    }

    public TALENTargetFinder(DataSet ds, TALgetterDiffSM model, MatchFinder finder) {
        this.finder = finder;
        this.ds = ds;
        this.model = model;
    }

    public void setDataSet(DataSet ds) {
        if (this.finder instanceof InfixMatchFinder) {
            this.ds = ds;
            ((InfixMatchFinder)this.finder).setDataSet(ds);
        } else if (this.finder instanceof SimpleMatchFinder) {
            this.ds = ds;
            ((SimpleMatchFinder)this.finder).setDataSet(ds);
        } else {
            throw new RuntimeException();
        }
    }

    public LimitedSortedList<TALENMatch> getTALENMatches(Sequence tal1, Sequence tal2, double totalThresh, double singleThresh1, double singleThresh2, int minDist, int maxDist, int limit, boolean relativeScores) throws OperationNotSupportedException {
        LimitedSortedList<TALENMatch> list = new LimitedSortedList<TALENMatch>(limit);
        this.fillMatches(tal1, tal2, totalThresh, singleThresh1, singleThresh2, minDist, maxDist, list, relativeScores);
        this.fillMatches(tal2, tal1, totalThresh, singleThresh2, singleThresh1, minDist, maxDist, list, relativeScores);
        this.fillMatches(tal1, tal1, totalThresh, singleThresh1, singleThresh1, minDist, maxDist, list, relativeScores);
        this.fillMatches(tal2, tal2, totalThresh, singleThresh2, singleThresh2, minDist, maxDist, list, relativeScores);
        return list;
    }

    private void fillMatches(Sequence tal1, Sequence tal2, double totalThresh, double singleThresh1, double singleThresh2, int minDist, int maxDist, LimitedSortedList<TALENMatch> list, boolean relativeScores) throws OperationNotSupportedException {
        ComparableElement<MatchFinder.Match, Double>[] list1Fwd = this.finder.getScoresAbove(tal1, singleThresh1 * (double)(relativeScores ? tal1.getLength() + 1 : 1), 1000000, true, false).getSortedList();
        int i = 0;
        while (i < list1Fwd.length) {
            MatchFinder.Match curr = list1Fwd[i].getElement();
            double currScore = list1Fwd[i].getWeight();
            int seq = curr.getSeqIdx();
            int pos = curr.getSeqPos();
            Sequence seq2 = this.ds.getElementAt(seq);
            if (pos + tal1.getLength() + 1 + minDist + tal2.getLength() + 1 < seq2.getLength()) {
                int length = maxDist - minDist + tal2.getLength() + 1;
                if (length > seq2.getLength() - pos - tal1.getLength() - minDist - 1) {
                    length = seq2.getLength() - pos - tal1.getLength() - minDist - 1;
                }
                Sequence rc = seq2.reverseComplement();
                int tl = tal2.getLength();
                int j = 0;
                int k = seq2.getLength() - (pos + tal1.getLength() + 1 + minDist) - length;
                while (j < length - tl) {
                    double score2 = this.model.getPartialLogScoreFor(tal2, rc, k, 0, tal2.getLength() + 1);
                    int n = relativeScores ? tal2.getLength() + 1 : 1;
                    if (score2 / (double)n > singleThresh2) {
                        double d = currScore / (double)(relativeScores ? tal1.getLength() + 1 : 1);
                        int n2 = relativeScores ? tal2.getLength() + 1 : 1;
                        if (d + score2 / (double)n2 > totalThresh) {
                            list.insert(currScore / (double)(relativeScores ? tal1.getLength() + 1 : 1) + score2 / (double)(relativeScores ? tal2.getLength() + 1 : 1), new TALENMatch(tal1, tal2, curr, new MatchFinder.Match(seq, pos + tal1.getLength() + 1 + minDist + length - j - (tal2.getLength() + 1), true)));
                        }
                    }
                    ++j;
                    ++k;
                }
            }
            ++i;
        }
    }

    public void reset() {
        this.finder.reset();
    }

    public static class TALENMatch {
        private Sequence tal1;
        private Sequence tal2;
        private MatchFinder.Match match1;
        private MatchFinder.Match match2;

        public TALENMatch(Sequence tal1, Sequence tal2, MatchFinder.Match match1, MatchFinder.Match match2) {
            this.tal1 = tal1;
            this.tal2 = tal2;
            this.match1 = match1;
            this.match2 = match2;
        }

        public Sequence getTal1() {
            return this.tal1;
        }

        public Sequence getTal2() {
            return this.tal2;
        }

        public MatchFinder.Match getMatch1() {
            return this.match1;
        }

        public MatchFinder.Match getMatch2() {
            return this.match2;
        }
    }
}

