/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.Pair;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SeqLogoPlotter;
import projects.tals.TALgetterDiffSM;

public class PlotSpecAndImp {
    public static void main(String[] args) throws Exception {
        TALgetterDiffSM model = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readFile("projects/tals/talfinder_obg2_hyp_bg.xml"), "model");
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence seq = Sequence.create(alphabetsRVD, args[0], "-");
        Pair<double[][], double[]> pair = model.getSpecificitiesAndImportances(seq);
        REnvironment re = new REnvironment();
        re.voidEval("source(\"/Users/dev/Desktop/TAL-Chips/mylogo.R\");");
        re.createMatrix("pwm", pair.getFirstElement());
        re.createVector("imp", pair.getSecondElement());
        String[] parts = args[0].split("-");
        re.createVector("lab", parts);
        re.voidEval("pwm<-t(pwm)");
        re.voidEval("imp<-c(NA,imp);");
        re.voidEval("lab<-c(\"0\",lab)");
        re.plotToPDF("my.logo(pwm=pwm,xticks=lab,imp=imp)", 14.0, 5.0, "/Users/dev/Downloads/logo.pdf", true);
        re.close();
        parts = ("0-" + args[0]).split("-");
        SeqLogoPlotter.plotTALgetterLogoToPNG("/Users/dev/Downloads/logo.png", 800, pair.getFirstElement(), pair.getSecondElement(), parts);
    }
}

