/*
 * Decompiled with CFR 0.152.
 */
package seqTools;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import seqTools.AbstractChIPper;

public class FastThresholdedChIPper
extends AbstractChIPper {
    private double[][] motifProfile;
    private IntList end;
    private double threshold;
    private HashMap<Sequence, BitSet[]> toBeUsedHash;

    public FastThresholdedChIPper(int starts, double t, DifferentiableStatisticalModel ... motif) throws CloneNotSupportedException {
        super(starts, motif);
        if (t <= 0.0 || t > 1.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = t;
        this.init();
    }

    public FastThresholdedChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = (Double)XMLParser.extractObjectForTags(xml, "threshold");
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer extra = new StringBuffer(100);
        XMLParser.appendObjectWithTags(extra, this.threshold, "threshold");
        return extra;
    }

    @Override
    protected void init() {
        super.init();
        this.end = new IntList();
        this.toBeUsedHash = new HashMap();
    }

    @Override
    public FastThresholdedChIPper clone() throws CloneNotSupportedException {
        FastThresholdedChIPper clone = (FastThresholdedChIPper)super.clone();
        clone.motifProfile = (double[][])ArrayHandler.clone((Cloneable[])this.motifProfile);
        clone.end = this.end.clone();
        clone.toBeUsedHash = new HashMap();
        for (Sequence s : this.toBeUsedHash.keySet()) {
            clone.toBeUsedHash.put(s, (BitSet[])ArrayHandler.clone((Cloneable[])this.toBeUsedHash.get(s)));
        }
        return clone;
    }

    @Override
    protected int fillComponentScoreOf(double[] array, int component, Sequence sequence, int startpos) {
        int end = this.fillComponentScoreOf(array, component, sequence, startpos, null, false);
        return end;
    }

    protected int fillComponentScoreOf(int i, Sequence seq, int start, BitSet b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        if (this.motifProfile == null || this.motifProfile[0].length < end) {
            this.motifProfile = new double[3][seq.getLength()];
        }
        return this.fillComponentScoreOf(this.motifProfile[0], i, seq, start, b, usePosition);
    }

    protected int fillComponentScoreOf(double[] array, int i, Sequence seq, int start, BitSet b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        double pos = 0.0;
        float[] position = null;
        if (usePosition && (position = this.getPosition(i, seq, false)) == null) {
            pos = -Math.log(end);
        }
        int j = 0;
        int l = 0;
        while (l < end) {
            if (b == null || b.get(start)) {
                if (position != null) {
                    pos = position[start];
                }
                array[j++] = pos + this.function[i].getLogScoreFor(seq, start) - (double)m * this.logP;
            }
            ++l;
            ++start;
        }
        return j;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        BitSet[] b = this.toBeUsedHash.get(seq);
        int i = 0;
        while (i < this.function.length) {
            int j = this.fillComponentScoreOf(i, seq, start, b == null ? null : b[i], true);
            this.componentScore[i] = h + this.logHiddenPotential[i] + Normalisation.getLogSum(0, j, this.motifProfile[0]);
            ++i;
        }
        this.componentScore[this.function.length] = h + this.logHiddenPotential[this.function.length];
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int n;
        boolean add;
        int startIndex = partialDer.length();
        double pos = Double.NaN;
        BitSet[] b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add && start == 0) {
            b = new BitSet[this.function.length];
        }
        int i = 0;
        while (i < this.function.length) {
            if (!add) {
                b[i].clear();
            } else if (start == 0) {
                b[i] = new BitSet();
            }
            ++i;
        }
        int j = 0;
        while (j < this.function.length) {
            int m = this.function[j].getLength();
            int stop = seq.getLength() - start - m + 1;
            if (stop > 0) {
                float[] position = this.getPosition(j, seq, true);
                if (position == null) {
                    pos = -Math.log(stop);
                }
                if (this.motifProfile == null || this.motifProfile.length < stop) {
                    this.motifProfile = new double[3][seq.getLength()];
                }
                n = 0;
                int l = start;
                while (n < stop) {
                    if (position != null) {
                        pos = position[l];
                    }
                    this.motifProfile[0][n] = pos + this.function[j].getLogScoreFor(seq, l) - (double)m * this.logP;
                    ++l;
                    ++n;
                }
                this.componentScore[j] = Normalisation.logSumNormalisation(this.motifProfile[0], 0, stop, this.motifProfile[1], 0);
                System.arraycopy(this.motifProfile[1], 0, this.motifProfile[2], 0, stop);
                Arrays.sort(this.motifProfile[2], 0, stop);
                int e = stop - 1;
                double s = 0.0;
                while (e >= 0 && (s += this.motifProfile[2][e]) < this.threshold) {
                    --e;
                }
                double t = this.motifProfile[2][e];
                int k = 0;
                this.iList[j].clear();
                this.dList[j].clear();
                this.end.clear();
                e = 0;
                while (e < stop) {
                    if (this.motifProfile[1][e] >= t) {
                        this.motifProfile[2][k++] = this.motifProfile[0][e];
                        this.function[j].getLogScoreAndPartialDerivation(seq, start + e, this.iList[j], this.dList[j]);
                        if (b != null) {
                            b[j].set(e);
                        }
                    }
                    this.end.add(this.iList[j].length());
                    ++e;
                }
                if (add && start == 0) {
                    this.toBeUsedHash.put(seq, b);
                }
                this.componentScore[j] = Normalisation.logSumNormalisation(this.motifProfile[2], 0, k);
                k = 0;
                s = 0.0;
                e = 0;
                while (e < stop) {
                    this.motifProfile[1][e] = this.motifProfile[1][e] < t ? 0.0 : this.motifProfile[2][k++];
                    ++e;
                }
                int n2 = j;
                this.componentScore[n2] = this.componentScore[n2] + this.logHiddenPotential[j];
                l = 0;
                int counter = 0;
                while (l < stop) {
                    e = this.end.get(l);
                    if (this.motifProfile[1][l] > 0.0) {
                        while (counter < e) {
                            indices.add(this.iList[j].get(counter) + this.paramRef[j]);
                            partialDer.add(this.dList[j].get(counter++) * this.motifProfile[1][l]);
                        }
                    } else {
                        counter = e;
                    }
                    ++l;
                }
            } else {
                this.componentScore[j] = Double.NEGATIVE_INFINITY;
            }
            this.endIndex[j] = partialDer.length();
            ++j;
        }
        this.componentScore[this.function.length] = this.logHiddenPotential[this.function.length];
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        j = 0;
        while (j < this.function.length) {
            partialDer.multiply(startIndex, this.endIndex[j], this.componentScore[j]);
            startIndex = this.endIndex[j];
            ++j;
        }
        logScore += this.logP * (double)(seq.getLength() - start);
        n = this.function.length;
        int i2 = this.paramRef[n + 1] - this.paramRef[n];
        j = 0;
        while (j < i2) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            int end = this.fillComponentScoreOf(component, sequence, startpos, null, false);
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l > 0) {
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, this.motifProfile[0]);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                res = new double[l + 1];
                int i = 0;
                while (i < res.length) {
                    res[i] = this.motifProfile[0][i] + d;
                    ++i;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type FastThresholdedChIPper must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

