/*
 * Decompiled with CFR 0.152.
 */
package seqTools;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;
import seqTools.AbstractChIPper;

public class FastThresholdedStrandChIPper2
extends AbstractChIPper {
    private static final double LOG2 = Math.log(2.0);
    private double[] scoreProfile;
    private double[] normedProfile;
    private double[] temp;
    private IntList tempPos;
    private IntList end;
    private double threshold;
    private HashMap<Sequence, IntList[]> toBeUsedHash;

    public FastThresholdedStrandChIPper2(int starts, double t, DifferentiableStatisticalModel ... motif) throws CloneNotSupportedException {
        super(starts, motif);
        if (t <= 0.0 || t > 1.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = t;
        this.init();
    }

    public FastThresholdedStrandChIPper2(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = (Double)XMLParser.extractObjectForTags(xml, "threshold");
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer extra = new StringBuffer(100);
        XMLParser.appendObjectWithTags(extra, this.threshold, "threshold");
        return extra;
    }

    @Override
    protected void init() {
        super.init();
        this.end = new IntList();
        this.tempPos = new IntList();
        this.toBeUsedHash = new HashMap();
    }

    @Override
    public FastThresholdedStrandChIPper2 clone() throws CloneNotSupportedException {
        FastThresholdedStrandChIPper2 clone = (FastThresholdedStrandChIPper2)super.clone();
        if (this.scoreProfile != null) {
            clone.scoreProfile = (double[])this.scoreProfile.clone();
        }
        if (this.normedProfile != null) {
            clone.normedProfile = (double[])this.normedProfile.clone();
        }
        if (this.temp != null) {
            clone.temp = (double[])this.temp.clone();
        }
        clone.end = this.end.clone();
        clone.tempPos = this.tempPos.clone();
        clone.toBeUsedHash = new HashMap();
        for (Sequence s : this.toBeUsedHash.keySet()) {
            IntList[] list = this.toBeUsedHash.get(s);
            IntList[] clonedList = new IntList[list.length];
            int i = 0;
            while (i < list.length) {
                if (list[i] != null) {
                    clonedList[i] = list[i].clone();
                }
                ++i;
            }
            clone.toBeUsedHash.put(s, clonedList);
        }
        return clone;
    }

    @Override
    protected int fillComponentScoreOf(double[] array, int component, Sequence sequence, int startpos) {
        int end = this.fillComponentScoreOf(array, component, sequence, startpos, null, false);
        return end;
    }

    protected int fillComponentScoreOf(int i, Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        if (this.scoreProfile == null || this.scoreProfile.length < 2 * end) {
            this.scoreProfile = new double[seq.getLength() * 2];
        }
        return this.fillComponentScoreOf(this.scoreProfile, i, seq, start, b, usePosition);
    }

    protected int fillComponentScoreOf(double[] array, int i, Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        double pos = 0.0;
        float[] position = null;
        if (usePosition && (position = this.getPosition(i, seq, false)) == null) {
            pos = -Math.log(end);
        }
        int j = 0;
        int curr = -1;
        int n = b == null ? end : b.length();
        int l = 0;
        while (l < n) {
            if (b != null) {
                curr = b.get(l);
                boolean rc = false;
                if (curr < 0) {
                    rc = true;
                    curr = -curr - 1;
                }
                if (curr >= start && curr <= seq.getLength() - m) {
                    if (position != null) {
                        pos = position[curr];
                    }
                    if (rc) {
                        try {
                            array[j++] = pos - LOG2 + this.function[i].getLogScoreFor(seq.reverseComplement(), seq.getLength() - curr - m) - (double)m * this.logP;
                        }
                        catch (OperationNotSupportedException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        array[j++] = pos - LOG2 + this.function[i].getLogScoreFor(seq, curr) - (double)m * this.logP;
                    }
                }
            } else {
                curr = start + l;
                if (curr >= start && curr <= seq.getLength() - m) {
                    if (position != null) {
                        pos = position[curr];
                    }
                    try {
                        array[j++] = Normalisation.getLogSum(pos - LOG2 + this.function[i].getLogScoreFor(seq, curr) - (double)m * this.logP, pos - LOG2 + this.function[i].getLogScoreFor(seq.reverseComplement(), seq.getLength() - curr - m) - (double)m * this.logP);
                    }
                    catch (OperationNotSupportedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++l;
        }
        return j;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        IntList[] b = this.toBeUsedHash.get(seq);
        int i = 0;
        while (i < this.function.length) {
            int j = this.fillComponentScoreOf(i, seq, start, b == null ? null : b[i], true);
            this.componentScore[i] = h + this.logHiddenPotential[i] + Normalisation.getLogSum(0, j, this.scoreProfile);
            ++i;
        }
        this.componentScore[this.function.length] = h + this.logHiddenPotential[this.function.length];
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int n;
        boolean add;
        int startIndex = partialDer.length();
        double pos = Double.NaN;
        IntList[] b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add && start == 0) {
            b = new IntList[this.function.length];
        }
        int i = 0;
        while (i < this.function.length) {
            if (!add) {
                b[i].clear();
            } else if (start == 0) {
                b[i] = new IntList();
            }
            ++i;
        }
        int j = 0;
        while (j < this.function.length) {
            int m = this.function[j].getLength();
            int stop = seq.getLength() - start - m + 1;
            if (stop > 0) {
                float[] position = this.getPosition(j, seq, true);
                if (position == null) {
                    pos = -Math.log(stop);
                }
                if (this.scoreProfile == null || this.scoreProfile.length < 2 * stop) {
                    this.scoreProfile = new double[seq.getLength() * 2];
                }
                if (this.normedProfile == null || this.normedProfile.length < 2 * stop) {
                    this.normedProfile = new double[seq.getLength() * 2];
                }
                if (this.temp == null || this.temp.length < 2 * stop) {
                    this.temp = new double[seq.getLength() * 2];
                }
                n = 0;
                int l = start;
                while (n < stop) {
                    if (position != null) {
                        pos = position[l];
                    }
                    this.scoreProfile[n] = pos - LOG2 + this.function[j].getLogScoreFor(seq, l) - (double)m * this.logP;
                    try {
                        this.scoreProfile[n + stop] = pos - LOG2 + this.function[j].getLogScoreFor(seq.reverseComplement(), seq.getLength() - l - m) - (double)m * this.logP;
                    }
                    catch (OperationNotSupportedException e1) {
                        throw new RuntimeException(e1);
                    }
                    ++l;
                    ++n;
                }
                Normalisation.logSumNormalisation(this.scoreProfile, 0, 2 * stop, this.normedProfile, 0);
                System.arraycopy(this.normedProfile, 0, this.temp, 0, 2 * stop);
                Arrays.sort(this.temp, 0, 2 * stop);
                int e = 2 * stop - 1;
                double s = 0.0;
                while (e > 0 && (s += this.temp[e]) < this.threshold) {
                    --e;
                }
                double t = this.temp[e];
                int k = 0;
                this.iList[j].clear();
                this.dList[j].clear();
                this.end.clear();
                this.tempPos.clear();
                e = 0;
                while (e < stop) {
                    if (this.normedProfile[e] >= t) {
                        this.tempPos.add(e);
                        this.function[j].getLogScoreAndPartialDerivation(seq, start + e, this.iList[j], this.dList[j]);
                        if (b != null) {
                            b[j].add(e);
                        }
                    }
                    this.end.add(this.iList[j].length());
                    ++e;
                }
                e = 0;
                while (e < stop) {
                    if (this.normedProfile[stop + e] >= t) {
                        this.tempPos.add(-e - 1);
                        try {
                            this.function[j].getLogScoreAndPartialDerivation(seq.reverseComplement(), seq.getLength() - (start + e) - m, this.iList[j], this.dList[j]);
                        }
                        catch (OperationNotSupportedException e1) {
                            throw new RuntimeException(e1);
                        }
                        if (b != null) {
                            b[j].add(-e - 1);
                        }
                    }
                    this.end.add(this.iList[j].length());
                    ++e;
                }
                k = 0;
                while (k < this.tempPos.length()) {
                    int p = this.tempPos.get(k);
                    this.normedProfile[k] = p >= 0 ? this.scoreProfile[p] : this.scoreProfile[stop - p - 1];
                    ++k;
                }
                if (add && start == 0) {
                    this.toBeUsedHash.put(seq, b);
                }
                this.componentScore[j] = Normalisation.logSumNormalisation(this.normedProfile, 0, k);
                k = 0;
                int n2 = j;
                this.componentScore[n2] = this.componentScore[n2] + this.logHiddenPotential[j];
                k = 0;
                int counter = 0;
                while (k < this.tempPos.length()) {
                    l = this.tempPos.get(k);
                    if (l < 0) {
                        l = -l - 1;
                    }
                    e = this.end.get(l);
                    if (l > 0) {
                        counter = this.end.get(l - 1);
                    }
                    while (counter < e) {
                        indices.add(this.iList[j].get(counter) + this.paramRef[j]);
                        partialDer.add(this.dList[j].get(counter++) * this.normedProfile[k]);
                    }
                    ++k;
                }
            } else {
                this.componentScore[j] = Double.NEGATIVE_INFINITY;
            }
            this.endIndex[j] = partialDer.length();
            ++j;
        }
        this.componentScore[this.function.length] = this.logHiddenPotential[this.function.length];
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        j = 0;
        while (j < this.function.length) {
            partialDer.multiply(startIndex, this.endIndex[j], this.componentScore[j]);
            startIndex = this.endIndex[j];
            ++j;
        }
        logScore += this.logP * (double)(seq.getLength() - start);
        n = this.function.length;
        int i2 = this.paramRef[n + 1] - this.paramRef[n];
        j = 0;
        while (j < i2) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (motif > 0 || component > this.function.length) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        Sequence ts = sequence.getSubSequence(startpos, m.getLength());
        double[] temp = new double[]{m.getLogScoreFor(ts), m.getLogScoreFor(ts.reverseComplement())};
        Normalisation.logSumNormalisation(temp);
        return temp;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            int end = this.fillComponentScoreOf(component, sequence, startpos, null, false);
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l > 0) {
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, this.scoreProfile);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                res = new double[l + 1];
                int i = 0;
                while (i < res.length) {
                    res[i] = this.scoreProfile[i] + d;
                    ++i;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type FastThresholdedStrandChIPper2 must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

