/*
 * Decompiled with CFR 0.152.
 */
package seqTools.positions;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.util.HashMap;
import seqTools.positions.PositionDistribution;

public abstract class DensityPositionDistribution
extends PositionDistribution
implements Cloneable {
    private double[] temp;
    private double[][] tempDer;
    private HashMap<Integer, Double> logNorms;
    private HashMap<Integer, double[]> logNormPartialDers;

    public DensityPositionDistribution(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getTag());
        int maximumExpectedLength = (Integer)XMLParser.extractObjectForTags(xml, "mel");
        this.extractFurtherInformation(xml);
        this.temp = new double[maximumExpectedLength];
        this.logNorms = new HashMap();
        this.logNormPartialDers = new HashMap();
    }

    protected abstract void extractFurtherInformation(StringBuffer var1) throws NonParsableException;

    protected abstract void appendFurtherInformation(StringBuffer var1);

    protected abstract String getTag();

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.temp.length, "mel");
        this.appendFurtherInformation(xml);
        XMLParser.addTags(xml, this.getTag());
        return xml;
    }

    public DensityPositionDistribution(int maximumExpectedLength) {
        this.temp = new double[maximumExpectedLength];
        this.logNorms = new HashMap();
        this.logNormPartialDers = new HashMap();
    }

    public DensityPositionDistribution clone() throws CloneNotSupportedException {
        DensityPositionDistribution clone = (DensityPositionDistribution)super.clone();
        clone.temp = (double[])this.temp.clone();
        clone.tempDer = (double[][])ArrayHandler.clone((Cloneable[])this.tempDer);
        clone.logNorms = new HashMap();
        clone.logNormPartialDers = new HashMap();
        return clone;
    }

    @Override
    public double getLogScore(Sequence seq, int start, int end, int position, int motifWidth) {
        return this.getLogDensity(end - start + 1, position, motifWidth) - this.getLogNorm(end - start + 1, motifWidth);
    }

    protected double getLogNorm(int length, int motifWidth) {
        if (!this.logNorms.containsKey(length)) {
            this.logNorms.put(length, this.computeLogNorm(length, motifWidth));
        }
        return this.logNorms.get(length);
    }

    protected double computeLogNorm(int length, int motifWidth) {
        this.acquireTemps(length, false);
        int i = 0;
        while (i < length) {
            this.temp[i] = this.getLogDensity(length, i, motifWidth);
            ++i;
        }
        return Normalisation.getLogSum(0, length, this.temp);
    }

    protected double[][] getLogNormPartialDers(int length, int motifWidth) {
        if (!this.logNorms.containsKey(length) || !this.logNormPartialDers.containsKey(length)) {
            double[][] res = this.computeLogNormPartialDers(length, motifWidth);
            this.logNorms.put(length, res[0][0]);
            this.logNormPartialDers.put(length, res[1]);
            return res;
        }
        return new double[][]{{this.logNorms.get(length)}, this.logNormPartialDers.get(length)};
    }

    protected double[][] computeLogNormPartialDers(int length, int motifWidth) {
        double norm;
        this.acquireTemps(length, true);
        int i = 0;
        while (i < length) {
            double[] curr = this.getLogDensityAndPartialDerivation(length, i, motifWidth);
            this.temp[i] = curr[0];
            int j = 1;
            while (j < curr.length) {
                this.tempDer[j - 1][i] = curr[j] * Math.exp(curr[0]);
                ++j;
            }
            ++i;
        }
        double[][] res = new double[][]{new double[1], new double[this.getNumberOfParameters()]};
        res[0][0] = norm = Normalisation.getLogSum(0, length, this.temp);
        int i2 = 0;
        while (i2 < res[1].length) {
            res[1][i2] = Math.exp(Normalisation.getLogSum(0, length, this.tempDer[i2]) - norm);
            ++i2;
        }
        return res;
    }

    protected void acquireTemps(int length, boolean der) {
        if (this.temp == null || this.temp.length < length) {
            this.temp = new double[length];
        }
        if (der && (this.tempDer == null || this.tempDer.length < length)) {
            this.tempDer = new double[this.getNumberOfParameters()][this.temp.length];
        }
    }

    protected abstract double getLogDensity(int var1, int var2, int var3);

    protected abstract double[] getLogDensityAndPartialDerivation(int var1, int var2, int var3);

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int end, int position, int motifWidth, IntList indices, DoubleList partial, int off) {
        double[][] res = this.getLogNormPartialDers(end - start + 1, motifWidth);
        double[] t = this.getLogDensityAndPartialDerivation(end - start + 1, position, motifWidth);
        int i = 0;
        while (i < res[1].length) {
            indices.add(i + off);
            partial.add(t[i] - res[1][i]);
            ++i;
        }
        return t[0] - res[0][0];
    }

    protected void reset() {
        this.logNorms.clear();
        this.logNormPartialDers.clear();
    }
}

