/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.ArbitraryFloatSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.results.Result;
import de.jstacs.utils.Time;
import java.util.Arrays;

public class ChIPperProfile {
    public static void main(String[] args) throws Exception {
        String home = args[0];
        String fgData = String.valueOf(home) + args[1];
        String classifier = args[3];
        int motifLength = Integer.parseInt(args[4]);
        int restarts = 10;
        boolean motifNumber = true;
        int threads = 4;
        int sd = 75;
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        AlphabetContainer ref = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        double ess = 4.0;
        boolean free = false;
        Time time = Time.getTimeInstance(System.out);
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        DataSet[] dataSetArray = new DataSet[2];
        dataSetArray[0] = SparseSequence.getDataSet((AlphabetContainer)con, fgData, parser);
        DataSet[] data = dataSetArray;
        System.out.println("data");
        int i = 0;
        while (i < 1) {
            System.out.println(String.valueOf(data[i].getAnnotation()) + "\t" + data[i].getNumberOfElements() + "\t" + "[" + data[i].getMinimalElementLength() + " .. " + data[i].getAverageElementLength() + " .. " + data[i].getMaximalElementLength() + "]");
            ++i;
        }
        Sequence[] annotated = new Sequence[data[0].getNumberOfElements()];
        Sequence[] annotatedBg = new Sequence[data[0].getNumberOfElements()];
        double[][] weights = new double[][]{new double[data[0].getNumberOfElements()], new double[data[0].getNumberOfElements()]};
        double[] raw = (double[])weights[0].clone();
        float[][] histogram = new float[data[0].getNumberOfElements()][];
        float[][] histogramBg = new float[data[0].getNumberOfElements()][];
        double[] bw = new double[weights[0].length];
        double[] mean = new double[weights[0].length];
        int j = 0;
        while (j < weights[0].length) {
            annotated[j] = data[0].getElementAt(j);
            SequenceAnnotation[] seqAn = annotated[j].getAnnotation();
            mean[j] = Double.NaN;
            int i2 = 0;
            while (i2 < seqAn.length) {
                if (seqAn[i2].getType().equals("maxT")) {
                    raw[j] = Double.parseDouble(seqAn[i2].getIdentifier());
                } else if (seqAn[i2].getType().equals("peakSummit")) {
                    mean[j] = Double.parseDouble(seqAn[i2].getIdentifier());
                } else if (seqAn[i2].getType().equals("leftPeakboundary")) {
                    int n = j;
                    bw[n] = bw[n] - (double)Integer.parseInt(seqAn[i2].getIdentifier());
                } else if (seqAn[i2].getType().equals("rightPeakboundary")) {
                    int n = j;
                    bw[n] = bw[n] + (double)Integer.parseInt(seqAn[i2].getIdentifier());
                }
                ++i2;
            }
            bw[j] = Math.abs(bw[j]);
            ++j;
        }
        System.out.println(sd);
        j = 0;
        while (j < weights[0].length) {
            histogram[j] = new float[annotated[j].getLength()];
            histogramBg[j] = new float[annotated[j].getLength()];
            float max = 0.0f;
            float sum = 0.0f;
            int i3 = 0;
            while (i3 < histogram[j].length) {
                histogram[j][i3] = (float)(((double)i3 - mean[j]) / (double)sd);
                histogram[j][i3] = (float)Math.exp(-0.5 * (double)histogram[j][i3] * (double)histogram[j][i3]);
                sum += histogram[j][i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < histogram[j].length) {
                float[] fArray = histogram[j];
                int n = i3;
                fArray[n] = fArray[n] / sum;
                if (histogram[j][i3] > max) {
                    max = histogram[j][i3];
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < histogramBg[j].length) {
                histogramBg[j][i3] = max - histogram[j][i3];
                ++i3;
            }
            Sequence temp = annotated[j].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogram[j]), new Result[0]));
            annotatedBg[j] = annotated[j].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogramBg[j]), new Result[0]));
            annotated[j] = temp;
            ++j;
        }
        data[0] = new DataSet("", annotated);
        data[1] = new DataSet("", annotatedBg);
        MutableMotifDiscoverer mmd = (MutableMotifDiscoverer)XMLParser.extractObjectForTags(FileManager.readFile(classifier), "discoverer");
        int i4 = 0;
        while (i4 < 10) {
            System.out.println(Arrays.toString(mmd.getProfileOfScoresFor(0, 0, data[0].getElementAt(i4), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_CONDITIONAL)));
            ++i4;
        }
    }
}

