/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.SimpleCosts;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.utils.DoubleList;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;

public class CompareAthAly {
    public static void main(String[] args) throws Exception {
        DataSet ds = new DataSet(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "R", "W", "M", "S")), new SparseStringExtractor(args[0], '>', (SequenceAnnotationParser)new SplitSequenceAnnotationParser(":", ";")));
        LinkedList<Sequence> at = new LinkedList<Sequence>();
        LinkedList<Sequence> al = new LinkedList<Sequence>();
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            if (i % 2 == 0) {
                at.add(ds.getElementAt(i));
            } else {
                al.add(ds.getElementAt(i));
            }
            ++i;
        }
        DataSet ath = new DataSet("", at);
        DataSet aly = new DataSet("", al);
        Alignment align = new Alignment(Alignment.AlignmentType.GLOBAL, new AffineCosts(3.0, new SimpleCosts(0.0, 1.5, 1.0)));
        DoubleList dl = new DoubleList();
        PrintWriter wr = new PrintWriter(args[1]);
        int i2 = 0;
        while (i2 < ath.getNumberOfElements()) {
            System.out.println(i2);
            Sequence ats = ath.getElementAt(i2);
            Sequence als = aly.getElementAt(i2);
            dl.clear();
            CompareAthAly.addStats(align, ats, als, dl);
            CompareAthAly.addStats(align, ats.getSubSequence(Math.max(ats.getLength() - 1000, 0), Math.max(ats.getLength() - 500, 0) - Math.max(ats.getLength() - 1000, 0)), als.getSubSequence(Math.max(als.getLength() - 1000, 0), Math.max(als.getLength() - 500, 0) - Math.max(als.getLength() - 1000, 0)), dl);
            CompareAthAly.addStats(align, ats.getSubSequence(Math.max(ats.getLength() - 500, 0)), als.getSubSequence(Math.max(als.getLength() - 500, 0)), dl);
            String id1 = ats.getSequenceAnnotationByType("id", 0).getIdentifier();
            String id2 = als.getSequenceAnnotationByType("id", 0).getIdentifier();
            wr.print(String.valueOf(id1) + "\t" + id2);
            int j = 0;
            while (j < dl.length()) {
                wr.print("\t" + dl.get(j));
                ++j;
            }
            wr.println();
            ++i2;
        }
        wr.close();
    }

    private static HashMap<String, int[]> getMap(Sequence seq, int k) {
        HashMap<String, int[]> map1 = new HashMap<String, int[]>();
        int i = 0;
        while (i < seq.getLength() - k + 1) {
            String sub = seq.toString(i, i + k);
            int[] num = map1.get(sub);
            if (num == null) {
                map1.put(sub, new int[]{1});
            } else {
                num[0] = num[0] + 1;
            }
            ++i;
        }
        return map1;
    }

    private static void addStats(Alignment align, Sequence seq1, Sequence seq2, DoubleList dl) {
        PairwiseStringAlignment res = align.getAlignment(seq1, seq2);
        double fullCost = res.getCost();
        double m = Math.max(seq1.getLength(), seq2.getLength());
        dl.add(fullCost / m);
        int k = 6;
        HashMap<String, int[]> map1 = CompareAthAly.getMap(seq1, k);
        HashMap<String, int[]> map2 = CompareAthAly.getMap(seq2, k);
        DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(DNAAlphabetContainer.SINGLETON, k, false);
        double d = 0.0;
        while (en.hasMoreElements()) {
            String str = ((Sequence)en.nextElement()).toString();
            int[] num1 = map1.get(str);
            int[] num2 = map2.get(str);
            int n1 = num1 == null ? 0 : num1[0];
            int n2 = num2 == null ? 0 : num2[0];
            d += (double)Math.abs(n1 - n2);
        }
        dl.add(d / m);
    }
}

