/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.continuous.MultivariateGaussianEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.BaumWelchParameterSet;
import de.jstacs.utils.ToolBox;

public class TestGaussHMM {
    public static void main(String[] args) throws Exception {
        AlphabetContainer con = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        DataSet ds = new DataSet(con, new SparseStringExtractor(args[0]));
        BaumWelchParameterSet pars = new BaumWelchParameterSet(1, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), 1);
        Emission[] emissions = new Emission[]{new MultivariateGaussianEmission(1, new double[]{-3.0}, new double[][]{{400.0}}, 400.0, 400.0, false, false), new MultivariateGaussianEmission(1, new double[]{0.0}, new double[][]{{90.0}}, 400.0, 400.0, true, true), new MultivariateGaussianEmission(1, new double[]{3.0}, new double[][]{{400.0}}, 400.0, 400.0, false, false)};
        AbstractHMM hmm = HMMFactory.createErgodicHMM(pars, 1, 4.0, 0.9, 7000.0, emissions);
        hmm.train(ds);
        System.out.println(hmm);
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            System.out.println(hmm.getViterbiPathFor(ds.getElementAt(i)).getFirstElement());
            double[][] statPost = hmm.getStatePosteriorMatrixFor(ds.getElementAt(i));
            double[] temp = new double[statPost.length];
            System.out.print("[");
            int j = 0;
            while (j < statPost[0].length) {
                int k = 0;
                while (k < statPost.length) {
                    temp[k] = statPost[k][j];
                    ++k;
                }
                System.out.print(String.valueOf(ToolBox.getMaxIndex(temp)) + ", ");
                ++j;
            }
            System.out.println("]");
            System.out.println("+++++++++++++++++++");
            ++i;
        }
    }
}

