/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.MultiDimensionalArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.continuous.FixedCorrelationGaussianEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.continuous.MultivariateGaussianEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.BaumWelchParameterSet;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.Locale;

public class TestGaussHMM2 {
    public static void main(String[] args) throws Exception {
        AlphabetContainer con = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        DataSet ds = new DataSet(con, new SparseStringExtractor(args[0]));
        DataSet ds2 = new DataSet(con, new SparseStringExtractor(args[1]));
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            MultiDimensionalArbitrarySequence seq = new MultiDimensionalArbitrarySequence(null, (ArbitrarySequence)ds.getElementAt(i), (ArbitrarySequence)ds2.getElementAt(i));
            list.add(seq);
            ++i;
        }
        ds = new DataSet("", list);
        BaumWelchParameterSet pars = new BaumWelchParameterSet(1, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), 1);
        double[][] corr = new double[][]{{1.0, 0.99}, {0.99, 1.0}};
        double[][] corr2 = new double[][]{{12000.0, 0.0}, {0.0, 12000.0}};
        Emission[] emissions = new Emission[]{new FixedCorrelationGaussianEmission(2, new double[]{0.0, 0.0}, new double[]{2000.0, 2000.0}, 4000.0, 8000.0, corr, false), new MultivariateGaussianEmission(2, new double[]{0.0, 0.0}, corr2, 4000.0, 1000.0, false, false)};
        AbstractHMM hmm = HMMFactory.createErgodicHMM(pars, 1, 4.0, 0.9, 7000.0, emissions);
        hmm.train(ds);
        System.out.println(hmm);
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(2);
        int i2 = 0;
        while (i2 < ds.getNumberOfElements()) {
            System.out.println(hmm.getViterbiPathFor(ds.getElementAt(i2)).getFirstElement().toString().replaceAll(" ", "     "));
            double[][] statPost = hmm.getStatePosteriorMatrixFor(ds.getElementAt(i2));
            double[] temp = new double[statPost.length];
            System.out.print("[");
            int j = 0;
            while (j < statPost[0].length) {
                int k = 0;
                while (k < statPost.length) {
                    temp[k] = statPost[k][j];
                    ++k;
                }
                System.out.print(String.valueOf(nf.format(Math.log(temp[1] / temp[0]))) + ", ");
                ++j;
            }
            System.out.println("]");
            System.out.println("+++++++++++++++++++");
            ++i2;
        }
    }
}

