/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream5.paper;

import challenges.dream5.paper.KMerStatistics;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.ToolBox;
import java.util.LinkedList;

public class Dream5ReEvaluation {
    public static void main(String[] args) throws Exception {
        String home = args[0];
        String answers = args[1];
        String predictions = args[2];
        String goldStandars = args[3];
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        SparseStringExtractor exAn = new SparseStringExtractor(String.valueOf(home) + System.getProperty("file.separator") + answers, '#');
        SparseStringExtractor exPred = new SparseStringExtractor(String.valueOf(home) + System.getProperty("file.separator") + predictions, '#');
        exAn.nextElement();
        exPred.nextElement();
        String lastTF = "";
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        DoubleList truth = new DoubleList();
        DoubleList pred = new DoubleList();
        MeanResultSet mrs = new MeanResultSet();
        while (exAn.hasMoreElements()) {
            String line = exAn.nextElement();
            String[] temp = line.split("\t");
            Sequence seq = Sequence.create(con, temp[2]);
            double weight = Double.parseDouble(temp[3]);
            int flag = Integer.parseInt(temp[4]);
            line = exPred.nextElement();
            temp = line.split("\t");
            double pw = Double.parseDouble(temp[3]);
            if (!lastTF.equals("") && !lastTF.equals(temp[0]) || !exAn.hasMoreElements()) {
                LinkedList<Sequence> gs = new LinkedList<Sequence>();
                SparseStringExtractor exGS = new SparseStringExtractor(String.valueOf(home) + System.getProperty("file.separator") + goldStandars);
                while (exGS.hasMoreElements()) {
                    String line2 = exGS.nextElement();
                    String[] temp2 = line2.split("\t");
                    if (!lastTF.equals(temp2[0])) continue;
                    gs.add(Sequence.create(con, temp2[1]));
                }
                DataSet data = new DataSet("", list.toArray(new Sequence[0]));
                double[] signal = truth.toArray();
                double[] prediction = pred.toArray();
                double pearson = ToolBox.pearsonCorrelation(signal, prediction);
                double spearman = ToolBox.spearmanCorrelation(signal, prediction);
                KMerStatistics stat = new KMerStatistics(data, signal, true, 25, 8, false);
                DoubleList results = new DoubleList();
                stat.fillStatistics(data, prediction, gs, results);
                int i = 0;
                while (i < signal.length) {
                    signal[i] = Math.log(signal[i]);
                    prediction[i] = Math.log(prediction[i]);
                    ++i;
                }
                double logPearson = ToolBox.pearsonCorrelation(signal, prediction);
                System.out.println(String.valueOf(lastTF) + "\t" + spearman + "\t" + pearson + "\t" + logPearson + "\t" + results.get(0) + "\t" + results.get(1) + "\t" + results.get(2));
                mrs.addResults(new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("spearman", "", spearman), new NumericalResult("pearson", "", pearson), new NumericalResult("pearsonLog", "", logPearson), new NumericalResult("auc-pr", "", results.get(0)), new NumericalResult("auc-roc", "", results.get(1)), new NumericalResult("8mer-corr", "", results.get(2))}}));
                list.clear();
                truth.clear();
                pred.clear();
            }
            if (flag == 0) {
                list.add(seq);
                truth.add(weight);
                pred.add(pw);
            }
            lastTF = temp[0];
        }
        System.out.println(mrs.getStatistics());
    }
}

