/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.neuralNetworks.neurons;

import de.jstacs.classifiers.neuralNetworks.activationFunctions.ActivationFunction;
import de.jstacs.classifiers.neuralNetworks.neurons.InnerNeuron;
import de.jstacs.classifiers.neuralNetworks.neurons.Neuron;
import de.jstacs.data.sequences.Sequence;

public class MSEOutputNeuron
extends InnerNeuron {
    public MSEOutputNeuron(ActivationFunction activationFunction, int index, Neuron ... predecessors) {
        super(activationFunction, index, predecessors);
    }

    @Override
    public double getError(Sequence input, double weight, double[] desiredOutputs) {
        if (this.last != input) {
            throw new RuntimeException();
        }
        if (this.error == null) {
            this.error = weight * (desiredOutputs[this.index] - this.output) * this.activationFunction.getDerivation(this.h);
        }
        int i = 0;
        while (i < this.predecessors.length) {
            int n = i;
            this.delta[n] = this.delta[n] + this.error * this.predecessors[i].getOutput(input);
            ++i;
        }
        int n = this.delta.length - 1;
        this.delta[n] = this.delta[n] + this.error * -1.0;
        return this.error;
    }
}

