/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.fitnessFunctions;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.utils.SafeOutputStream;
import java.util.HashMap;

public class CachingFitnessFunction<T extends Individual>
implements FitnessFunction<T> {
    private FitnessFunction<T> fun;
    SafeOutputStream sos;
    HashMap<T, Double> cache;

    public CachingFitnessFunction(FitnessFunction<T> fun) {
        this.fun = fun;
        this.cache = new HashMap();
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        this.fun.setOutputStream(stream);
        this.sos = stream;
    }

    @Override
    public Double getFitness(T individual) throws Exception {
        Double temp = this.cache.get(individual);
        if (temp == null || !this.sos.doesNothing()) {
            temp = this.fun.getFitness(individual);
            this.cache.put(individual, temp);
        }
        return temp;
    }

    @Override
    public void reset() {
        this.cache.clear();
    }
}

