/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.Result;
import de.jstacs.utils.galaxy.GalaxyAdaptor;
import projects.crispr.CRISPRer;

public class CRISPRerWeb {
    public static void main(String[] args) throws Exception {
        ParameterSet params = CRISPRer.getParameters(false);
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] addLine = blArray;
        GalaxyAdaptor ga = new GalaxyAdaptor(params, addLine, "CRISPRer", "CRISPRer is a tool for designing CRISPR/Cas protospacers and seeds", "1.0", "java  -Xms512M -Xmx3G -jar " + System.getProperty("user.dir") + System.getProperty("file.separator") + "CRISPRerWeb.jar", "jobname");
        ga.setHelp(FileManager.readInputStream(CRISPRerWeb.class.getClassLoader().getResourceAsStream("projects/crispr/help.txt")).toString());
        if (!ga.parse(args)) {
            System.exit(1);
        }
        GalaxyAdaptor.Protocol prot = ga.getProtocol(false);
        int seedLength = (Integer)params.getParameterForName("Seed length").getValue();
        SelectionParameter task = (SelectionParameter)params.getParameterForName("CRISPRer task");
        int sel = task.getSelected();
        String tasks = null;
        if (sel == 0) {
            tasks = "Searching for CRISPR/Cas protospacers with unique seed sequence of length " + seedLength + " ";
        } else if (sel == 1) {
            tasks = "Searching for CRISPR/Cas seeds of length " + seedLength + " that do not occur in the input genome ";
        } else if (sel == 2) {
            tasks = "Assessing user provided CRISPR/Cas protospacers for seed length " + seedLength + " ";
        }
        prot.appendHeading("Search");
        prot.append(tasks);
        SelectionParameter sp = (SelectionParameter)((SimpleParameterSet)task.getValue()).getParameterForName("Filter");
        if (sel != 0 || sp.getSelected() == 0) {
            prot.append("using all given sequences.<br />");
        } else {
            SimpleParameterSet ps2 = (SimpleParameterSet)sp.getValue();
            String reg = ps2.getParameterForName("Chromosomal locations").getValue().toString().replaceAll("\n", ";");
            prot.append("that overlap with " + reg + ".<br />");
        }
        boolean gff3 = true;
        if (sel == 0) {
            gff3 = (Boolean)((SimpleParameterSet)task.getValue()).getParameterForName("Use GFF2").getValue() == false;
        }
        boolean includePam = (Boolean)params.getParameterForName("Include PAM").getValue();
        prot.appendHeading("Results");
        prot.append("You find the results of your search in your Galaxy history in tabular" + (sel == 0 ? " and " + (gff3 ? "GFF3" : "GFF2") : "") + " format.<br /><br />");
        prot.append("The columns of the tabular format have the following meaning:<br />");
        prot.append("<table>\n");
        prot.append("<tr><th>Column</th><th>Description</th></tr>\n");
        prot.append("<tr><td>1</td><td>Sequence ID (as given in FastA header)</td></tr>\n");
        prot.append("<tr><td>2</td><td>Start position (1-based)</td></tr>\n");
        prot.append("<tr><td>3</td><td>End position (1-based, inclusive)</td></tr>\n");
        prot.append("<tr><td>4</td><td>Strand (+: Forward, -: Reverse, .: Unknown/Not applicable)</td></tr>\n");
        prot.append("<tr><td>5</td><td>" + (sel == 1 ? "Seed" : "Protospacer") + " (" + (includePam ? "" : "not ") + "including PAM)</td></tr>\n");
        prot.append("<tr><td>6</td><td>Number of perfect seed matches</td></tr>\n");
        prot.append("<tr><td>7</td><td>Number of matches for seed that is one nucleotide shorter from the 5' end (in strand orientation)</td></tr>\n");
        prot.append("<tr><td>8</td><td>Number of matches for seed that is two nucleotides shorter from the 5' end (in strand orientation)</td></tr>\n");
        prot.append("<tr><td>9</td><td>Number of matches for seed that is three nucleotides shorter from the 5' end (in strand orientation)</td></tr>\n");
        prot.append("<tr><td>10</td><td>Number of non-optimal matches allowing one mismatch compared to perfect seed match</td></tr>\n");
        prot.append("<tr><td>11</td><td>Number of non-optimal matches allowing two mismatches compared to perfect seed match</td></tr>\n");
        prot.append("</table><br /><br />\n\n");
        prot.append("The latter five numbers may give you an estimate of likeliness of off-target effects.");
        Result[] res = CRISPRer.run(params, false);
        ga.addResult(res[0], true, false);
        if (res.length > 1) {
            ga.addResult(res[1], true, false, gff3 ? "gff3" : "gff");
        }
        ga.writeOutput();
    }
}

