/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.results.Result;
import de.jstacs.utils.SafeOutputStream;
import projects.tals.TALgetterDiffSM;

public class RVDMatchFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    private SafeOutputStream out;
    private TALgetterDiffSM fun;
    private DataSet positives;

    public RVDMatchFitnessFunction(DataSet positives, TALgetterDiffSM fun) throws CloneNotSupportedException {
        this.fun = fun.clone();
        this.positives = positives;
        this.out = SafeOutputStream.getSafeOutputStream(null);
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        this.out = stream;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws Exception {
        SimpleDiscreteSequence rvds = individual.getSequence();
        ReferenceSequenceAnnotation an = new ReferenceSequenceAnnotation("seq", rvds, new Result[0]);
        double[] posScores = new double[this.positives.getNumberOfElements()];
        double minScore = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.positives.getNumberOfElements()) {
            Sequence seq = this.positives.getElementAt(i);
            posScores[i] = Double.NEGATIVE_INFINITY;
            int bestPos = -1;
            int j = 0;
            while (j < seq.getLength() - rvds.getLength()) {
                SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{an};
                double temp = this.fun.getLogScoreFor(seq.getSubSequence(j, rvds.getLength() + 1).annotate(false, sequenceAnnotationArray));
                if (temp > posScores[i]) {
                    posScores[i] = temp;
                    bestPos = j;
                }
                ++j;
            }
            if (posScores[i] < minScore) {
                minScore = posScores[i];
            }
            ++i;
        }
        this.out.writeln("minScore: " + minScore);
        minScore /= (double)(rvds.getLength() + 1);
        return 1.0 / (1.0 + Math.exp(-10.0 * (minScore -= Math.log(0.5))));
    }

    @Override
    public void reset() {
    }
}

