/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.utils.SafeOutputStream;
import projects.talGA.TALENIndividual;

public class TALENWrapperFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    private FitnessFunction<DiscreteSequenceIndividual> function;
    private boolean homo;
    private SafeOutputStream stream;
    private boolean log;

    public TALENWrapperFitnessFunction(FitnessFunction<DiscreteSequenceIndividual> function, boolean homo, boolean log) {
        this.function = function;
        this.homo = homo;
        this.log = log;
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        this.function.setOutputStream(stream);
        this.stream = stream;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws Exception {
        double fit1 = 0.0;
        double fit2 = 0.0;
        if (this.homo) {
            fit2 = fit1 = this.function.getFitness(individual).doubleValue();
        } else {
            DiscreteSequenceIndividual first = ((TALENIndividual)individual).getFirstPart();
            DiscreteSequenceIndividual second = ((TALENIndividual)individual).getSecondPart();
            fit1 = this.function.getFitness(first);
            fit2 = this.function.getFitness(second);
        }
        if (this.log) {
            return Math.exp(Math.log(fit1) + Math.log(fit2));
        }
        return fit1 + fit2;
    }

    @Override
    public void reset() {
        this.function.reset();
    }
}

