/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.galaxy.MultilineSimpleParameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.talGA.InfixMatchFinder;
import projects.talGA.MatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class FastTBSScanner {
    public static ResultList[] scan(TALgetterDiffSM model, FastTBSScannerParameterSet params, BufferedReader dsRead) throws Exception {
        if (!params.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence tal = Sequence.create(alphabetsRVD, params.getTALSequence(), "-");
        ResultList rl = new ResultList(params.getN());
        ResultList rl2 = new ResultList(params.getN());
        StringBuffer lastHeader = new StringBuffer();
        Pair<int[][], DataSet> curr = null;
        InfixMatchFinder finder = new InfixMatchFinder(null, Math.min(9, tal.getLength() + 1), model);
        Double thresh = Double.NEGATIVE_INFINITY;
        while ((curr = FastTBSScanner.readNextSequences(dsRead, lastHeader)) != null) {
            int[][] offsets = curr.getFirstElement();
            DataSet dat = curr.getSecondElement();
            finder.setDataSet(dat);
            LimitedSortedList<MatchFinder.Match> list = finder.getScoresAbove(tal, thresh, params.getN(), true, false);
            if (params.scanRc()) {
                LimitedSortedList<MatchFinder.Match> list2 = finder.getScoresAbove(tal, thresh, params.getN(), true, true);
                list.insertAll(list2);
            }
            ComparableElement<MatchFinder.Match, Double>[] matches = list.getSortedList();
            int i = matches.length - 1;
            while (i >= 0 && rl.better(matches[i].getWeight())) {
                MatchFinder.Match match = matches[i].getElement();
                double score = matches[i].getWeight();
                Sequence seq = dat.getElementAt(match.getSeqIdx());
                Sequence sub = null;
                int pos = match.getSeqPos();
                sub = match.isRc() ? seq.reverseComplement().getSubSequence(seq.getLength() - pos - tal.getLength(), tal.getLength() + 1) : seq.getSubSequence(pos, tal.getLength() + 1);
                String id = (String)seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                String str = model.getMatchString(tal, sub);
                Result[] tr = new Result[]{new CategoricalResult("ID", "", id), new NumericalResult("Position", "", pos + offsets[0][match.getSeqIdx()]), new CategoricalResult("Strand", "", match.isRc() ? "-" : "+"), new CategoricalResult("Sequence", "", sub.toString()), new CategoricalResult("Matches", "", str), new NumericalResult("Score", "", score)};
                rl.add(new ResultSet(new Result[][]{tr}), score);
                tr[0] = new GeneLinkResult("ID", "", id);
                rl2.add(new ResultSet(new Result[][]{tr}), score);
                --i;
            }
            thresh = rl.getWorstScore();
        }
        return new ResultList[]{rl, rl2};
    }

    public static Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        IntList ends = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1));
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("unparsed comment line", "unparsed comment line", new CategoricalResult("unparsed comment", "unparsed comment", header));
                    Sequence seq = new SparseSequence((AlphabetContainer)DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    starts.add(start);
                    ends.add(seqStr.length() - end);
                }
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray(), ends.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }

    private static HashSet<Sequence> makeHash(DataSet d) {
        HashSet<Sequence> set = new HashSet<Sequence>();
        int i = 0;
        while (i < d.getNumberOfElements()) {
            set.add(d.getElementAt(i));
            ++i;
        }
        return set;
    }

    public static class FastTBSScannerParameterSet
    extends ParameterSet {
        public FastTBSScannerParameterSet() throws Exception {
            this.parameters.add(new Parameter[]{new SelectionParameter(DataType.PARAMETERSET, new String[]{"Use a previously uploaded file", "Paste sequences in FastA format"}, new ParameterSet[]{new SimpleParameterSet(new FileParameter("FastA file", "The sequences to scan for TAL effector target sites, FastA format", "fasta", true)), new SimpleParameterSet(new MultilineSimpleParameter("FastA sequences", "The sequences to scan for TAL effector target sites, FastA format", true))}, "Input sequences", "You can either use a previously uploaded file (see task &quot;GetData&quot; -&gt; &quot;Upload File&quot;) or paste in sequences in FastA format", true)});
            this.parameters.add(new Parameter[]{new MultilineSimpleParameter("RVD sequence", "Sequence of RVDs, seperated by '-'", true, "NI-HD-HD-NG-NN-NK-NK")});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Maximum number of target sites", "Limits the total number of reported target sites in all input sequences, ranked by their score.", true, new NumberValidator<Integer>(1, 10000), 100)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "Reverse complement", "Include reverse complement of input sequences.", true, false)});
        }

        public boolean scanRc() {
            return (Boolean)((Parameter)this.parameters.get("Reverse complement")).getValue();
        }

        public Parameter[] getAllParameters() {
            return (Parameter[])this.parameters.toArray(new Parameter[0]);
        }

        public void addParameter(int i, Parameter par) {
            this.parameters.add(i, par);
        }

        public String getTALSequence() {
            return (String)((Parameter)this.parameters.get("RVD sequence")).getValue();
        }

        public void setInputPath(String path) throws Exception {
            ((SelectionParameter)this.parameters.get("Input sequences")).setValue("Use a previously uploaded file");
            ((FileParameter)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0)).setValue(new FileParameter.FileRepresentation(path));
        }

        public BufferedReader getInputSequences() throws Exception {
            if (((SelectionParameter)this.parameters.get("Input sequences")).getSelected() == 0) {
                String filename = (String)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0).getValue();
                return new BufferedReader(new FileReader(filename));
            }
            String content = (String)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0).getValue();
            return new BufferedReader(new StringReader(content));
        }

        public int getN() {
            return (Integer)((Parameter)this.parameters.get("Maximum number of target sites")).getValue();
        }
    }

    public static class GeneLinkResult
    extends CategoricalResult {
        private static Object[][] map = new Object[][]{{Pattern.compile("Os[0-9]+[a-zA-Z]+[0-9]+(\\.[0-9]+)?"), "http://rice.plantbiology.msu.edu/cgi-bin/ORF_infopage.cgi?orf=LOC_$$$"}, {Pattern.compile("AT[0-9]+[a-zA-Z]+[0-9]+(\\.[0-9]+)"), "http://www.arabidopsis.org/servlets/TairObject?name=$$$&type=gene"}, {Pattern.compile("AT[0-9]+[a-zA-Z]+[0-9]+"), "http://www.arabidopsis.org/servlets/TairObject?name=$$$&type=locus"}};

        public GeneLinkResult(String name, String comment, String result) {
            super(name, comment, result);
        }

        public GeneLinkResult(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        public String getValue() {
            String str = super.getValue().toString();
            int i = 0;
            while (i < map.length) {
                Matcher m = ((Pattern)map[i][0]).matcher(str);
                if (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    String url = ((String)map[i][1]).replaceAll("\\$\\$\\$", str.substring(start, end));
                    return String.valueOf(str.substring(0, start)) + "<a href=\"" + url + "\" target=\"_blank\">" + str.substring(start, end) + "</a>" + str.substring(end);
                }
                ++i;
            }
            return str;
        }
    }

    public static class ResultList {
        private ComparableElement<ResultSet, Double>[] list;
        private int curr;

        public ResultList(int n) {
            this.list = new ComparableElement[n];
            this.curr = 0;
        }

        public boolean better(double value) {
            if (this.list[this.curr] == null) {
                return true;
            }
            return -value < this.list[this.curr].getWeight();
        }

        public void add(ResultSet res, double value) {
            if (this.list[this.curr] == null) {
                this.list[this.curr] = new ComparableElement<ResultSet, Double>(res, -value);
                if (this.curr < this.list.length - 1) {
                    ++this.curr;
                    Arrays.sort(this.list, 0, this.curr);
                } else {
                    Arrays.sort(this.list);
                }
            } else if (-value < this.list[this.curr].getWeight()) {
                this.list[this.curr] = new ComparableElement<ResultSet, Double>(res, -value);
                Arrays.sort(this.list);
            }
        }

        public DataSet getBindingSites() throws Exception {
            if (this.getNumberOfResults() == 0) {
                return null;
            }
            Sequence[] seqs = new Sequence[this.getNumberOfResults()];
            int i = 0;
            while (i < seqs.length) {
                seqs[i] = Sequence.create(DNAAlphabetContainer.SINGLETON, new SequenceAnnotation[]{new SequenceAnnotation("ID", (String)this.list[i].getElement().getResultForName("ID").getValue(), (Result[][])new Result[0][]), new SequenceAnnotation("Position", this.list[i].getElement().getResultForName("Position").getValue().toString(), (Result[][])new Result[0][]), new SequenceAnnotation("Score", this.list[i].getElement().getResultForName("Score").getValue().toString(), (Result[][])new Result[0][])}, (String)this.list[i].getElement().getResultForName("Sequence").getValue(), "");
                ++i;
            }
            return new DataSet("binding sites", seqs);
        }

        public ResultSet[] toArray() {
            ResultSet[] res = new ResultSet[this.getNumberOfResults()];
            int i = 0;
            while (i < res.length) {
                res[i] = this.list[i].getElement();
                ++i;
            }
            return res;
        }

        public double getBestScore() {
            if (this.list[0] == null) {
                return Double.NEGATIVE_INFINITY;
            }
            return -this.list[0].getWeight().doubleValue();
        }

        public double getWorstScore() {
            if (this.curr == 0 && this.list[this.curr] == null) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.list[this.curr] == null) {
                return -this.list[this.curr - 1].getWeight().doubleValue();
            }
            return -this.list[this.curr].getWeight().doubleValue();
        }

        public int getNumberOfResults() {
            if (this.list[this.curr] == null) {
                return this.curr;
            }
            return this.curr + 1;
        }
    }
}

