/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.DifferentiableStatisticalModelWrapperTrainSM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import projects.tals.TALFinder_NSF2;

public class TALMain2 {
    public static void main(String[] args) throws Exception {
        String line;
        String file = "targetsSF.fasta";
        DNAAlphabetContainer alphabets = DNAAlphabetContainer.SINGLETON;
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        ReferenceSequenceAnnotationParser annoParser = new ReferenceSequenceAnnotationParser("seq", alphabetsRVD, ":", ";", "-");
        DNADataSet data_Train_fg = new DNADataSet(file, '>', annoParser);
        int length = 0;
        int Ess = 8;
        int order_talU = 1;
        File file_gewichte = new File("targetsGewichte.txt");
        BufferedReader in = new BufferedReader(new FileReader(file_gewichte));
        double[] Gewichte_Daten = new double[data_Train_fg.getNumberOfElements()];
        int z = 0;
        while ((line = in.readLine()) != null) {
            Gewichte_Daten[z] = Double.parseDouble(line);
            ++z;
        }
        if (z < data_Train_fg.getNumberOfElements()) {
            throw new Exception("Es gibt weniger Gewichte als Sequenzen.");
        }
        if (z < data_Train_fg.getNumberOfElements()) {
            throw new Exception("Es gibt mehr Gewichte als Sequenzen.");
        }
        int numBack = 1;
        boolean onlymatch = true;
        boolean[][] ismatch = new boolean[(int)alphabetsRVD.getAlphabetLengthAt(0)][(int)alphabets.getAlphabetLengthAt(0)];
        int[] strong = new int[]{((DiscreteAlphabet)alphabetsRVD.getAlphabetAt(0)).getCode("NN"), ((DiscreteAlphabet)alphabetsRVD.getAlphabetAt(0)).getCode("NH"), ((DiscreteAlphabet)alphabetsRVD.getAlphabetAt(0)).getCode("HD"), ((DiscreteAlphabet)alphabetsRVD.getAlphabetAt(0)).getCode("HN")};
        int[] strongmatch = new int[]{((DiscreteAlphabet)alphabets.getAlphabetAt(0)).getCode("G"), ((DiscreteAlphabet)alphabets.getAlphabetAt(0)).getCode("G"), ((DiscreteAlphabet)alphabets.getAlphabetAt(0)).getCode("C"), ((DiscreteAlphabet)alphabets.getAlphabetAt(0)).getCode("G")};
        int i = 0;
        while (i < strong.length) {
            if (onlymatch) {
                ismatch[strong[i]][strongmatch[i]] = true;
            } else {
                Arrays.fill(ismatch[strong[i]], true);
            }
            ++i;
        }
        TALFinder_NSF2 Model_Tal_Finder_NSF = new TALFinder_NSF2(alphabets, alphabetsRVD, length, data_Train_fg.getAverageElementLength(), Ess, order_talU, ismatch, numBack, numBack);
        DifferentiableStatisticalModelWrapperTrainSM model = new DifferentiableStatisticalModelWrapperTrainSM(Model_Tal_Finder_NSF, 1, 20, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-10), 1.0E-10, 1.0E-4);
        model.train(data_Train_fg, Gewichte_Daten);
        TALFinder_NSF2 talFunction = (TALFinder_NSF2)model.getFunction();
        talFunction.setIndependentToStationary();
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, talFunction, "model");
        FileManager.writeFile(new File("/Users/dev/Desktop/TAL-Chips/GA/talfinder_obg" + order_talU + "_numback" + numBack + "_" + onlymatch + ".xml"), (CharSequence)sb);
        Model_Tal_Finder_NSF = talFunction;
        System.out.println(Model_Tal_Finder_NSF);
        System.out.println(Model_Tal_Finder_NSF.getLogScoreFor(data_Train_fg.getElementAt(5)));
    }
}

