/*
 * Decompiled with CFR 0.152.
 */
package seqTools;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.AbstractMixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;

public class ChIPper
extends AbstractMixtureDiffSM
implements MutableMotifDiscoverer {
    private double[][] motifProfile;
    private double logP;
    private IntList end;
    private HashMap<Sequence, float[]> positionHash;
    private double threshold;
    private HashMap<Sequence, BitSet[]> toBeUsedHash;
    private int[] endIndex;

    public ChIPper(int starts, double t, DifferentiableStatisticalModel ... motif) throws CloneNotSupportedException {
        super(0, starts, motif.length + 1, true, true, motif);
        if (t > 1.0) {
            throw new IllegalArgumentException();
        }
        if (t <= 0.0) {
            System.out.println("Viterbi mode");
        }
        this.threshold = t;
        this.init();
    }

    public ChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = (Double)XMLParser.extractObjectForTags(xml, "threshold");
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer extra = new StringBuffer(100);
        XMLParser.appendObjectWithTags(extra, this.threshold, "threshold");
        return extra;
    }

    private void init() {
        this.logP = -Math.log(this.function[0].getAlphabetContainer().getAlphabetLengthAt(0));
        this.end = new IntList();
        this.positionHash = new HashMap();
        this.toBeUsedHash = new HashMap();
        this.endIndex = new int[this.function.length];
    }

    @Override
    public ChIPper clone() throws CloneNotSupportedException {
        ChIPper clone = (ChIPper)super.clone();
        clone.motifProfile = (double[][])ArrayHandler.clone((Cloneable[])this.motifProfile);
        clone.end = this.end.clone();
        clone.positionHash = new HashMap();
        for (Sequence s : this.positionHash.keySet()) {
            clone.positionHash.put(s, (float[])this.positionHash.get(s).clone());
        }
        clone.toBeUsedHash = new HashMap();
        for (Sequence s : this.toBeUsedHash.keySet()) {
            clone.toBeUsedHash.put(s, (BitSet[])ArrayHandler.clone((Cloneable[])this.toBeUsedHash.get(s)));
        }
        clone.endIndex = (int[])this.endIndex.clone();
        return clone;
    }

    @Override
    protected boolean determineIsNormalized() {
        return false;
    }

    private Sequence getReference(Sequence seq) {
        SequenceAnnotation seqAn = seq.getSequenceAnnotationByType("reference", 0);
        return seqAn == null ? null : ((ReferenceSequenceAnnotation)seqAn).getReferenceSequence();
    }

    private float[] getPosition(int motif, Sequence seq, boolean add) {
        Sequence ref;
        float[] res = this.positionHash.get(seq);
        if (res == null && (ref = this.getReference(seq)) != null) {
            res = new float[seq.getLength() - this.function[motif].getLength() + 1];
            float sum = 0.0f;
            int i = 0;
            while (i < res.length) {
                res[i] = (float)ref.continuousVal(i);
                sum += res[i];
                ++i;
            }
            i = 0;
            while (i < res.length) {
                res[i] = (float)Math.log(res[i] / sum);
                ++i;
            }
            if (add) {
                this.positionHash.put(seq, res);
            }
        }
        return res;
    }

    @Override
    public double getHyperparameterForHiddenParameter(int index) {
        if (index < this.function.length) {
            return this.function[index].getESS();
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.function.length) {
            sum += this.function[i].getESS();
            ++i;
        }
        return sum;
    }

    @Override
    protected double getLogNormalizationConstantForComponent(int i) {
        if (i < this.function.length) {
            return this.function[i].getLogNormalizationConstant();
        }
        return 0.0;
    }

    public static int draw(DataSet d, double[] weight) {
        if (weight == null) {
            return r.nextInt(d.getNumberOfElements());
        }
        return ChIPper.draw(weight);
    }

    public static int draw(double[] weight) {
        double s = r.nextDouble() * ToolBox.sum(weight);
        int i = 0;
        while (weight[i] < s) {
            s -= weight[i];
            ++i;
        }
        return i;
    }

    @Override
    protected void initializeUsingPlugIn(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        int num = this.getNumberOfMotifs();
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double d = 0.1 / (double)(a - 1);
        d = (1.0 - (double)a * d) / ((double)a * d);
        int motif = 0;
        while (motif < num) {
            int p;
            int l = this.function[motif].getLength();
            int s = ChIPper.draw(data[index], weights == null ? null : weights[index]);
            Sequence seq = data[index].getElementAt(s);
            Sequence ref = this.getReference(seq);
            if (ref == null) {
                p = r.nextInt(seq.getLength() - l + 1);
            } else {
                double[] prof = new double[seq.getLength() - this.function[motif].getLength()];
                int i = 0;
                while (i < prof.length) {
                    prof[i] = ref.continuousVal(i);
                    ++i;
                }
                p = ChIPper.draw(prof);
            }
            seq = seq.getSubSequence(p, l);
            double h = d * this.function[motif].getESS();
            this.function[motif].initializeFunction(0, freeParams, new DataSet[]{new DataSet("", seq)}, new double[][]{{h}});
            ++motif;
        }
        this.initializeHiddenUniformly();
        this.positionHash.clear();
    }

    @Override
    public double getESS() {
        double ess = 0.0;
        int i = 0;
        while (i <= this.function.length) {
            ess += this.getHyperparameterForHiddenParameter(i);
            ++i;
        }
        return ess;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        int[] ind;
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        double res = (ind = this.getIndices(parameterIndex))[0] == this.function.length ? this.partNorm[ind[1]] : this.logHiddenPotential[ind[0]] + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]);
        return res;
    }

    protected int fillComponentScoreOf(int i, Sequence seq, int start, BitSet b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        if (this.motifProfile == null || this.motifProfile[0].length < end) {
            this.motifProfile = new double[3][seq.getLength()];
        }
        double pos = 0.0;
        float[] position = null;
        if (usePosition && (position = this.getPosition(i, seq, false)) == null) {
            pos = -Math.log(end);
        }
        int j = 0;
        int l = 0;
        while (l < end) {
            if (b == null || b.get(start)) {
                if (position != null) {
                    pos = position[start];
                }
                this.motifProfile[0][j++] = pos + this.function[i].getLogScoreFor(seq, start) - (double)m * this.logP;
            }
            ++l;
            ++start;
        }
        return j;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        BitSet[] b = this.toBeUsedHash.get(seq);
        int i = 0;
        while (i < this.function.length) {
            int j = this.fillComponentScoreOf(i, seq, start, b == null ? null : b[i], true);
            this.componentScore[i] = h + this.logHiddenPotential[i] + Normalisation.getLogSum(0, j, this.motifProfile[0]);
            ++i;
        }
        this.componentScore[this.function.length] = h + this.logHiddenPotential[this.function.length];
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int n;
        boolean add;
        int startIndex = partialDer.length();
        double pos = Double.NaN;
        BitSet[] b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add && start == 0) {
            b = new BitSet[this.function.length];
        }
        int i = 0;
        while (i < this.function.length) {
            if (!add) {
                b[i].clear();
            } else if (start == 0) {
                b[i] = new BitSet();
            }
            ++i;
        }
        int j = 0;
        while (j < this.function.length) {
            int m = this.function[j].getLength();
            int stop = seq.getLength() - start - m + 1;
            if (stop > 0) {
                int e;
                float[] position = this.getPosition(j, seq, true);
                if (position == null) {
                    pos = -Math.log(stop);
                }
                this.iList[j].clear();
                this.dList[j].clear();
                this.end.clear();
                if (this.motifProfile == null || this.motifProfile.length < stop) {
                    this.motifProfile = new double[3][seq.getLength()];
                }
                n = 0;
                int l = start;
                while (n < stop) {
                    if (position != null) {
                        pos = position[l];
                    }
                    this.motifProfile[0][n] = pos + this.function[j].getLogScoreAndPartialDerivation(seq, l, this.iList[j], this.dList[j]) - (double)m * this.logP;
                    this.end.add(this.iList[j].length());
                    ++l;
                    ++n;
                }
                if (this.threshold > 0.0) {
                    this.componentScore[j] = Normalisation.logSumNormalisation(this.motifProfile[0], 0, stop, this.motifProfile[1], 0);
                    if (this.threshold < 1.0) {
                        System.arraycopy(this.motifProfile[1], 0, this.motifProfile[2], 0, stop);
                        Arrays.sort(this.motifProfile[2], 0, stop);
                        e = stop - 1;
                        double s = 0.0;
                        while ((s += this.motifProfile[2][e]) < this.threshold) {
                            --e;
                        }
                        double t = this.motifProfile[2][e];
                        int k = 0;
                        e = 0;
                        while (e < stop) {
                            if (this.motifProfile[1][e] >= t) {
                                this.motifProfile[2][k++] = this.motifProfile[0][e];
                                if (b != null) {
                                    b[j].set(e);
                                }
                            }
                            ++e;
                        }
                        if (add && start == 0) {
                            this.toBeUsedHash.put(seq, b);
                        }
                        this.componentScore[j] = Normalisation.logSumNormalisation(this.motifProfile[2], 0, k);
                        k = 0;
                        s = 0.0;
                        e = 0;
                        while (e < stop) {
                            this.motifProfile[1][e] = this.motifProfile[1][e] < t ? 0.0 : this.motifProfile[2][k++];
                            ++e;
                        }
                    }
                } else {
                    int best = ToolBox.getMaxIndex(0, stop, this.motifProfile[0]);
                    Arrays.fill(this.motifProfile[1], 0.0);
                    this.motifProfile[1][best] = 1.0;
                    this.componentScore[j] = this.motifProfile[0][best];
                    b[j].set(best);
                    if (add && start == 0) {
                        this.toBeUsedHash.put(seq, b);
                    }
                }
                int n2 = j;
                this.componentScore[n2] = this.componentScore[n2] + this.logHiddenPotential[j];
                l = 0;
                int counter = 0;
                while (l < stop) {
                    e = this.end.get(l);
                    if (this.motifProfile[1][l] > 0.0) {
                        while (counter < e) {
                            indices.add(this.iList[j].get(counter) + this.paramRef[j]);
                            partialDer.add(this.dList[j].get(counter++) * this.motifProfile[1][l]);
                        }
                    } else {
                        counter = e;
                    }
                    ++l;
                }
            } else {
                this.componentScore[j] = Double.NEGATIVE_INFINITY;
            }
            this.endIndex[j] = partialDer.length();
            ++j;
        }
        this.componentScore[this.function.length] = this.logHiddenPotential[this.function.length];
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        j = 0;
        while (j < this.function.length) {
            partialDer.multiply(startIndex, this.endIndex[j], this.componentScore[j]);
            startIndex = this.endIndex[j];
            ++j;
        }
        logScore += this.logP * (double)(seq.getLength() - start);
        n = this.function.length;
        int i2 = this.paramRef[n + 1] - this.paramRef[n];
        j = 0;
        while (j < i2) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        return component;
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        return this.getIndexOfMaximalComponentFor(sequence, 0);
    }

    @Override
    public int getMotifLength(int motif) {
        return this.function[motif].getLength();
    }

    @Override
    public int getNumberOfMotifs() {
        return 1;
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        if (component < this.function.length) {
            return 1;
        }
        return 0;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            int end = this.fillComponentScoreOf(component, sequence, startpos, null, false);
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l > 0) {
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, this.motifProfile[0]);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                res = new double[l + 1];
                int i = 0;
                while (i < res.length) {
                    res[i] = this.motifProfile[0][i] + d;
                    ++i;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (motif > 0 || component > this.function.length) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        if (m instanceof StrandDiffSM) {
            if (startpos == 0) {
                return ((StrandDiffSM)m).getProbsForComponent(sequence);
            }
            return ((StrandDiffSM)m).getProbsForComponent(sequence.getSubSequence(startpos));
        }
        return new double[]{1.0, 0.0};
    }

    @Override
    public void adjustHiddenParameters(int index, DataSet[] data, double[][] weights) throws Exception {
    }

    @Override
    public void initializeMotif(int motifIndex, DataSet data, double[] weights) throws Exception {
        this.function[motifIndex].initializeFunction(0, this.freeParams, new DataSet[]{data}, new double[][]{weights});
        this.init(this.freeParams);
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        this.function[motif].initializeFunctionRandomly(this.freeParams);
        this.init(this.freeParams);
    }

    @Override
    protected void init(boolean freeParams) {
        super.init(freeParams);
        if (this.positionHash != null) {
            this.positionHash.clear();
        }
        if (this.toBeUsedHash != null) {
            this.toBeUsedHash.clear();
        }
    }

    @Override
    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        if (this.function[motifIndex] instanceof Mutable) {
            double norm_old = this.function[motifIndex].getLogNormalizationConstant();
            boolean res = ((Mutable)((Object)this.function[motifIndex])).modify(offsetLeft, offsetRight);
            if (res) {
                this.init(this.freeParams);
                double norm_new = this.function[motifIndex].getLogNormalizationConstant();
                int n = motifIndex;
                this.hiddenParameter[n] = this.hiddenParameter[n] + (norm_old - norm_new);
                this.setHiddenParameters(this.hiddenParameter, 0);
                this.norm = Double.NaN;
            }
            return res;
        }
        return false;
    }

    @Override
    public String toString() {
        throw new Error("Unresolved compilation problem: \n\tCannot override the final method from AbstractDifferentiableStatisticalModel\n");
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type ChIPper must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

