
## Arguments:
# 0: home directory, where the files (including *-seqs.txt and *-flags.txt) reside
# 1: absolute path of the outfile
# 2 (optional): suffix of the signals files (without .txt)

$home = $ARGV[0];
$outfile = $ARGV[1];
$signalSuff = "neighbor-3-TRUE";
if($ARGV[2]){
	$signalSuff = $ARGV[2];	
}

#@tfs=();
#for(my $i=1;$i<67;$i++){
#	push(@tfs,"TF_".$i);	
#}

@tfs = ("Cebpb", "Egr2", "Esr1", "Foxj2", "Foxo1", "Foxo3", "Foxo4", "Foxp1", "Foxp2", "Gmeb2", "Irf2", "Junb", "Mecp2", "Nr2c1", "Pou3f1", "Sox14", "Sp1", "Tbx3", "Tcf3", "Zscan20");
@arrays = ("HK", "ME");


open(OUT,">".$outfile);
print OUT "Id\tArrayType\tSequence\tSignal\tFlag\n";

for my $tf (@tfs){
	for my $array (@arrays){
		if(-e $home."/".$tf."-".$array."-flags.txt"){
				
			my $flags = $tf."-".$array."-flags.txt";
			my $signal = $tf."-".$array."-".$signalSuff.".txt";
			my $seqs = $array."-seqs.txt";
			
			open(FLAGS,$home."/".$flags);
			open(SIGN,$home."/".$signal);
			open(SEQS,$home."/".$seqs);
			
			my @flags = <FLAGS>;
			my @sign = <SIGN>;
			my @seqs = <SEQS>;
			
			for(my $i=0;$i<@flags;$i++){
				$seqs[$i] =~ s/\r?\n//;
				$sign[$i] =~ s/\r?\n//;
				$flags[$i] =~ s/\r?\n//;;
				print OUT $tf,"\t",$array,"\t",$seqs[$i],"\t",$sign[$i],"\t",$flags[$i],"\n";	
			}
			
			close(FLAGS);
			close(SIGN);
			close(SEQS);
		}
	}
}

close(OUT);
