/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.SimpleCosts;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.results.Result;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class AlignAthAlyPromoters2 {
    public static void main(String[] args) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader(args[1]));
        String str = null;
        HashMap<String, Double> atmap = new HashMap<String, Double>();
        HashMap<String, Double> almap = new HashMap<String, Double>();
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            atmap.put(parts[0], Double.parseDouble(parts[2]));
            almap.put(parts[1], Double.parseDouble(parts[3]));
        }
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        DataSet ds = new DataSet(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "R", "W", "M", "S")), new SparseStringExtractor(args[0], '>', (SequenceAnnotationParser)parser));
        LinkedList<Sequence> at = new LinkedList<Sequence>();
        LinkedList<Sequence> al = new LinkedList<Sequence>();
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            if (i % 2 == 0) {
                at.add(ds.getElementAt(i));
            } else {
                al.add(ds.getElementAt(i));
            }
            ++i;
        }
        DataSet ath = new DataSet("", at);
        DataSet aly = new DataSet("", al);
        Alignment aling = new Alignment(Alignment.AlignmentType.FREE_SHIFT, new AffineCosts(3.0, new SimpleCosts(-2.0, 2.0, 0.5)));
        at.clear();
        al.clear();
        LinkedList<Sequence> none = new LinkedList<Sequence>();
        LinkedList<Sequence> both = new LinkedList<Sequence>();
        REnvironment re = new REnvironment();
        re.voidEval("pdf(\"/Users/dev/Downloads/athal.pdf\",width=70,height=5);");
        double logM = Math.log(0.99);
        double logMM = Math.log(0.2);
        int len = 500;
        int sl = 8;
        int i2 = 0;
        while (i2 < ath.getNumberOfElements()) {
            Sequence aths = ath.getElementAt(i2);
            Sequence alys = aly.getElementAt(i2);
            String atkey = aths.getSequenceAnnotationByType("id", 0).getIdentifier();
            atkey = atkey.substring(0, atkey.indexOf(46));
            String alkey = alys.getSequenceAnnotationByType("id", 0).getIdentifier();
            if (atmap.containsKey(atkey) && almap.containsKey(alkey)) {
                PairwiseStringAlignment res = aling.getAlignment(aths, alys);
                String athal = res.getAlignedString(0);
                String alyal = res.getAlignedString(1);
                int en = alyal.length();
                int off = 0;
                int nm = 0;
                while (alyal.charAt(en - 1) == '-') {
                    if (alyal.charAt(en - 1) != '-') {
                        ++nm;
                    }
                    --en;
                    ++off;
                }
                System.out.println(off);
                SequenceAnnotation[] an = aths.getAnnotation();
                aths = aths.getSubSequence(0, aths.getLength() - off);
                aths = aths.getSubSequence(Math.max(0, aths.getLength() - len), Math.min(len, aths.getLength())).annotate(false, an);
                en = athal.length();
                off = 0;
                nm = 0;
                while (athal.charAt(en - 1) == '-') {
                    if (athal.charAt(en - 1) != '-') {
                        ++nm;
                    }
                    --en;
                    ++off;
                }
                System.out.println(off);
                an = alys.getAnnotation();
                alys = alys.getSubSequence(0, alys.getLength() - off);
                alys = alys.getSubSequence(Math.max(0, alys.getLength() - len), Math.min(len, alys.getLength())).annotate(false, an);
                if (aths.getLength() > 0 && alys.getLength() > 0) {
                    Sequence alys2;
                    Sequence aths2;
                    double atw = (Double)atmap.remove(atkey);
                    double alw = (Double)almap.remove(alkey);
                    res = aling.getAlignment(aths, alys);
                    athal = res.getAlignedString(0);
                    alyal = res.getAlignedString(1);
                    double[] athrep = new double[aths.getLength()];
                    double[] alyrep = new double[alys.getLength()];
                    int j = 0;
                    int k = 0;
                    int l = 0;
                    while (j < athal.length()) {
                        double sum = 0.0;
                        double n = 0.0;
                        String ats = athal.substring(j);
                        String als = alyal.substring(j);
                        ats = ats.replaceAll("-", "");
                        als = als.replaceAll("-", "");
                        int m = 0;
                        while (m < sl) {
                            sum = m < ats.length() && m < als.length() && ats.charAt(m) == als.charAt(m) ? (sum += logM) : (sum += logMM);
                            n += 1.0;
                            ++m;
                        }
                        if (k < athrep.length) {
                            athrep[k] = Math.exp(sum / n);
                        }
                        if (l < alyrep.length) {
                            alyrep[l] = Math.exp(sum / n);
                        }
                        if (athal.charAt(j) == alyal.charAt(j)) {
                            ++k;
                            ++l;
                        } else if (athal.charAt(j) == '-') {
                            ++l;
                        } else if (alyal.charAt(j) == '-') {
                            ++k;
                        } else {
                            ++k;
                            ++l;
                        }
                        ++j;
                    }
                    double[] athrep2 = new double[athrep.length];
                    int j2 = 0;
                    while (j2 < athrep2.length) {
                        athrep2[j2] = ToolBox.max(Math.max(0, j2 - sl / 2), Math.min(athrep.length, j2 + sl / 2), athrep);
                        ++j2;
                    }
                    double[] alyrep2 = new double[alyrep.length];
                    int j3 = 0;
                    while (j3 < alyrep2.length) {
                        alyrep2[j3] = ToolBox.max(Math.max(0, j3 - sl / 2), Math.min(alyrep.length, j3 + sl / 2), alyrep);
                        ++j3;
                    }
                    athrep = athrep2;
                    alyrep = alyrep2;
                    AlignAthAlyPromoters2.plot(re, athal, alyal, athrep, alyrep, String.valueOf(atkey) + " " + alkey);
                    if (atw > 0.5 && alw > 0.5) {
                        aths2 = aths.annotate(true, new SequenceAnnotation("weight", String.valueOf(atw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
                        alys2 = alys.annotate(true, new SequenceAnnotation("weight", String.valueOf(alw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
                        both.add(aths2);
                        both.add(alys2);
                        int j4 = 0;
                        while (j4 < athrep.length) {
                            athrep[j4] = 1.0 - athrep[j4];
                            ++j4;
                        }
                        aths2 = aths.annotate(true, new SequenceAnnotation("weight", String.valueOf(1.0 - atw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
                        both.add(aths2);
                        j4 = 0;
                        while (j4 < alyrep.length) {
                            alyrep[j4] = 1.0 - alyrep[j4];
                            ++j4;
                        }
                        alys2 = alys.annotate(true, new SequenceAnnotation("weight", String.valueOf(1.0 - alw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
                        both.add(alys2);
                    } else if (atw > 0.5) {
                        aths2 = aths.annotate(true, new SequenceAnnotation("weight", String.valueOf(1.0 - atw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
                        at.add(aths2);
                        int j5 = 0;
                        while (j5 < athrep.length) {
                            athrep[j5] = 1.0 - athrep[j5];
                            ++j5;
                        }
                        aths2 = aths.annotate(true, new SequenceAnnotation("weight", String.valueOf(atw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
                        at.add(aths2);
                        Arrays.fill(alyrep, 1.0);
                        alys2 = alys.annotate(true, new SequenceAnnotation("weight", String.valueOf(alw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
                        at.add(alys2);
                    } else if (alw > 0.5) {
                        Sequence alys22 = alys.annotate(true, new SequenceAnnotation("weight", String.valueOf(1.0 - alw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
                        al.add(alys22);
                        int j6 = 0;
                        while (j6 < alyrep.length) {
                            alyrep[j6] = 1.0 - alyrep[j6];
                            ++j6;
                        }
                        alys22 = alys.annotate(true, new SequenceAnnotation("weight", String.valueOf(alw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
                        al.add(alys22);
                        Arrays.fill(athrep, 1.0);
                        Sequence aths22 = aths.annotate(true, new SequenceAnnotation("weight", String.valueOf(atw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
                        al.add(aths22);
                    } else {
                        Arrays.fill(athrep, 1.0);
                        Arrays.fill(alyrep, 1.0);
                        aths2 = aths.annotate(true, new SequenceAnnotation("weight", String.valueOf(atw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(athrep), (Result[][])new Result[0][]));
                        alys2 = alys.annotate(true, new SequenceAnnotation("weight", String.valueOf(alw), (Result[][])new Result[0][]), new SequenceAnnotation("prof", Arrays.toString(alyrep), (Result[][])new Result[0][]));
                        none.add(aths2);
                        none.add(alys2);
                    }
                }
            }
            ++i2;
        }
        System.out.println("at: " + atmap.size());
        System.out.println("al: " + almap.size());
        re.voidEval("dev.off();");
        at = AlignAthAlyPromoters2.filter(at);
        al = AlignAthAlyPromoters2.filter(al);
        both = AlignAthAlyPromoters2.filter(both);
        none = AlignAthAlyPromoters2.filter(none);
        new DataSet("", both.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_both_bothTP.fa"), '>', parser);
        new DataSet("", at.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_athonly_bothTP.fa"), '>', parser);
        new DataSet("", al.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_alyonly_bothTP.fa"), '>', parser);
        new DataSet("", none.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_none_bothTP.fa"), '>', parser);
        at.addAll(al);
        at.addAll(both);
        at.addAll(none);
        new DataSet("", at.toArray(new Sequence[0])).save(new FileOutputStream(String.valueOf(args[0]) + "_all_bothTP.fa"), '>', parser);
    }

    private static LinkedList<Sequence> filter(LinkedList<Sequence> list) {
        LinkedList<Sequence> list2 = new LinkedList<Sequence>();
        int n = 0;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).toString().matches("^[ACGT]+$")) {
                list2.add(list.get(i));
            } else {
                ++n;
            }
            ++i;
        }
        System.out.println(String.valueOf(n) + " of " + list.size() + " sequences excluded");
        return list2;
    }

    private static void plot(REnvironment re, String athal, String alyal, double[] athrep, double[] alyrep, String id) throws Exception {
        double[] aly = new double[alyal.length()];
        int i = 0;
        int j = 0;
        while (i < alyal.length()) {
            if (alyal.charAt(i) == '-') {
                aly[i] = Double.NaN;
            } else {
                aly[i] = alyrep[j];
                ++j;
            }
            ++i;
        }
        double[] ath = new double[athal.length()];
        int i2 = 0;
        int j2 = 0;
        while (i2 < athal.length()) {
            if (athal.charAt(i2) == '-') {
                ath[i2] = Double.NaN;
            } else {
                ath[i2] = athrep[j2];
                ++j2;
            }
            ++i2;
        }
        re.createVector("ath", ath);
        re.voidEval("ath[is.nan(ath)]<-NA;");
        re.createVector("aly", aly);
        re.voidEval("aly[is.nan(aly)]<-NA;");
        re.createVector("athal", athal.split(""));
        re.createVector("alyal", alyal.split(""));
        re.voidEval("plot(ath,t=\"l\",col=2,ylim=c(-1,1),main=\"" + id + "\");");
        re.voidEval("lines(aly,col=3);");
        re.voidEval("text(x=1:length(athal),y=rep(-0.5,length(athal)),labels=athal,col=2)");
        re.voidEval("text(x=1:length(alyal),y=rep(-0.7,length(alyal)),labels=alyal,col=3)");
    }
}

