/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.results.Result;
import java.io.FileOutputStream;
import java.util.LinkedList;

public class ComputeScoreWindowCoPro {
    public static void main(String[] args) throws Exception {
        DNAAlphabetContainer alph = DNAAlphabetContainer.SINGLETON;
        Sequence miRNA = Sequence.create(alph, args[1]);
        AlphabetContainer llrCont = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));
        DataSet data = new DataSet(alph, new SparseStringExtractor(args[0], '>', (SequenceAnnotationParser)new SplitSequenceAnnotationParser(":", ";")));
        GenDisMixClassifier clCDS = new GenDisMixClassifier(FileManager.readFile(args[2]));
        GenDisMixClassifier clUTR = new GenDisMixClassifier(FileManager.readFile(args[3]));
        LinkedList<ArbitrarySequence> result = new LinkedList<ArbitrarySequence>();
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            double[] scores = new double[seq.getLength()];
            int cdsl = Integer.parseInt(seq.getSequenceAnnotationByType("cds", 0).getIdentifier());
            int j = 0;
            while (j < cdsl) {
                scores[j] = ComputeScoreWindowCoPro.getScore(j, seq, clCDS, miRNA);
                ++j;
            }
            int len = seq.getLength() - cdsl;
            int j2 = cdsl;
            while (j2 < seq.getLength()) {
                scores[j2] = ComputeScoreWindowCoPro.getScore(j2, seq, clUTR, miRNA);
                ++j2;
            }
            j2 = 0;
            while (j2 < scores.length) {
                System.out.println(String.valueOf(j2) + " " + scores[j2]);
                ++j2;
            }
            Sequence res = new ArbitrarySequence(llrCont, scores);
            res = res.annotate(true, seq.getAnnotation());
            result.add((ArbitrarySequence)res);
            ++i;
        }
        DataSet r = new DataSet("", result.toArray(new Sequence[0]));
        r.save(new FileOutputStream(args[4]), '>', new SplitSequenceAnnotationParser(":", ";"));
    }

    private static double getScore(int j, Sequence seq, GenDisMixClassifier cl, Sequence miRNA) throws Exception {
        if (j < 18) {
            return Double.NaN;
        }
        Sequence temp = seq.reverse(j - 18, j);
        temp = temp.annotate(true, new ReferenceSequenceAnnotation("seq", miRNA, new Result[0]));
        return cl.getScore(temp, 0) - cl.getScore(temp, 1);
    }
}

