/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.ToolBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class DREAMTestEvaluation {
    private static double global = 0.67;
    private static int best;
    private static AucROC aucROC;
    private static AucPR aucPR;

    static {
        aucROC = new AucROC();
        aucPR = new AucPR();
    }

    public static void main(String[] args) throws Exception {
        String home = "/Users/dev/Desktop/DREAM5/needed-data/";
        File dataHome = new File(home);
        File clHome = new File(String.valueOf(home) + "models/");
        ArrayList<GenDisMixClassifier> cl = new ArrayList<GenDisMixClassifier>();
        ArrayList<DataSet> data = new ArrayList<DataSet>();
        REnvironment r = null;
        r = new REnvironment();
        r.voidEval("require(hexbin); all=NULL; c=seq(0,2,by=0.01);");
        RegExFilenameFilter filter = new RegExFilenameFilter("data", RegExFilenameFilter.Directory.FORBIDDEN, true, ".*fa");
        Object[] fNames = dataHome.list(filter);
        Arrays.sort(fNames);
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        int i = 0;
        while (i < fNames.length) {
            best = -1;
            System.out.print((String)fNames[i]);
            data.clear();
            data.add(new DNADataSet(String.valueOf(home) + (String)fNames[i], '>', parser));
            filter = new RegExFilenameFilter("classifier", RegExFilenameFilter.Directory.FORBIDDEN, true, ".*" + ((String)fNames[i]).substring(0, ((String)fNames[i]).length() - 3) + ".*\\.xml");
            Object[] clNames = clHome.list(filter);
            Arrays.sort(clNames);
            System.out.print("\t" + clNames.length);
            cl.clear();
            int j = 0;
            while (j < 1) {
                cl.add((GenDisMixClassifier)XMLParser.extractObjectForTags(FileManager.readFile(String.valueOf(clHome.getAbsolutePath()) + "/" + (String)clNames[j]), "classifier"));
                ++j;
            }
            Object d = fNames[i];
            d = ((String)d).endsWith("ME.fa") ? ((String)d).replace("-ME", "-HK") : ((String)d).replace("-HK", "-ME");
            data.add(new DNADataSet(String.valueOf(home) + "../answers-data/" + (String)d, '>', parser));
            data.add(new DNADataSet(String.valueOf(home) + "../answers-detrend-qnorm-data/" + (String)d, '>', parser));
            DREAMTestEvaluation.evaluate(r, cl, data);
            ++i;
        }
        if (r != null) {
            if (Double.isNaN(global)) {
                r.eval("max=max(all,na.rm=T); n=" + fNames.length);
                REnvironment.showImage("", r.plot("if(is.matrix(all)) { image(c,d,all/n); } else { plot(c,all/n,main=max/n); }\n"));
                System.out.println(r.eval("c[which(all==max)]").asDouble());
            }
            r.close();
        }
    }

    private static void evaluate(REnvironment r, ArrayList<GenDisMixClassifier> cl, ArrayList<DataSet> d) throws Exception {
        double c;
        if (Double.isNaN(global)) {
            r.voidEval("l=list()");
            DataSet s = d.get(0);
            int i = 0;
            while (i < cl.size()) {
                r.createVector("help", cl.get(i).getScores(s));
                r.voidEval("l[[length(l)+1]]=help;");
                ++i;
            }
            r.createVector("signal", DREAMTestEvaluation.getSignal(s, "signal"));
            r.voidEval("q=rep(NA,length(c)); for( i in 1:length(c) ) { p=rep(0,length(l[[1]])); for( j in 1:length(l) ) { p = p+(1/(1+exp(-l[[j]]*c[i]))); }\n q[i]=cor(p,signal); }\n");
            r.voidEval("if( is.null(all) ) { all=q; } else { all = all+q; }\n");
            r.eval("max=max(q,na.rm=T); idx = which(as.vector(q)==max)");
            c = r.eval("c[idx]").asDouble();
        } else {
            c = global;
        }
        System.out.print("\t" + c);
        int i = 0;
        while (i < d.size()) {
            DREAMTestEvaluation.evaluate(DREAMTestEvaluation.getSignal(d.get(i), "signal"), DREAMTestEvaluation.getPred(d.get(i), cl, c), DREAMTestEvaluation.getFlags(d.get(i)));
            ++i;
        }
        System.out.println();
    }

    private static void evaluate(double[] signal, double[] pred, byte[] flags) throws Exception {
        double meanRaw = ToolBox.sum(signal) / (double)signal.length;
        double sdRaw = 0.0;
        int j = 0;
        while (j < signal.length) {
            sdRaw += (signal[j] - meanRaw) * (signal[j] - meanRaw);
            ++j;
        }
        sdRaw = Math.sqrt(sdRaw / (double)signal.length);
        double t = meanRaw + 4.0 * sdRaw;
        double[] clone = (double[])signal.clone();
        Arrays.sort(clone);
        if (t > clone[clone.length - 50]) {
            t = clone[clone.length - 50];
        }
        DoubleList pos = new DoubleList();
        DoubleList neg = new DoubleList();
        int j2 = 0;
        while (j2 < signal.length) {
            if (flags == null || flags[j2] == 0) {
                if (signal[j2] >= t) {
                    pos.add(pred[j2]);
                } else {
                    neg.add(pred[j2]);
                }
            }
            ++j2;
        }
        System.out.print("\t" + ToolBox.pearsonCorrelation(signal, pred));
        double[] posArray = pos.toArray();
        Arrays.sort(posArray);
        double[] negArray = neg.toArray();
        Arrays.sort(negArray);
        NumericalResultSet nr = aucROC.compute(posArray, negArray);
        System.out.print("\t" + nr.getResultAt(0).getValue());
        System.out.print("\t" + ToolBox.spearmanCorrelation(signal, pred));
        nr = aucPR.compute(posArray, negArray);
        System.out.print("\t" + nr.getResultAt(0).getValue());
    }

    private static double[] getSignal(DataSet d, String type) {
        double[] signal = new double[d.getNumberOfElements()];
        int i = 0;
        while (i < signal.length) {
            signal[i] = Double.parseDouble(d.getElementAt(i).getSequenceAnnotationByType(type, 0).getIdentifier());
            ++i;
        }
        return signal;
    }

    private static byte[] getFlags(DataSet d) {
        if (d.getElementAt(0).getSequenceAnnotationByType("flag", 0) == null) {
            return null;
        }
        byte[] flag = new byte[d.getNumberOfElements()];
        int i = 0;
        while (i < flag.length) {
            flag[i] = Byte.parseByte(d.getElementAt(i).getSequenceAnnotationByType("flag", 0).getIdentifier());
            ++i;
        }
        return flag;
    }

    public static double[] getPred(DataSet data, ArrayList<GenDisMixClassifier> cl, double value) throws Exception {
        double[] pred = new double[data.getNumberOfElements()];
        double[][] intermediate = new double[cl.size()][];
        int c = 0;
        while (c < cl.size()) {
            intermediate[c] = cl.get(c).getScores(data);
            ++c;
        }
        int i = 0;
        while (i < pred.length) {
            pred[i] = 1.0;
            int c2 = 0;
            while (c2 < cl.size()) {
                int n = i;
                pred[n] = pred[n] * (1.0 / (1.0 + Math.exp(-value * intermediate[c2][i])));
                ++c2;
            }
            ++i;
        }
        return pred;
    }
}

