/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.io.FileManager;
import de.jstacs.io.InfixStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DREAMTestEvaluationShort {
    private static double[] global = new double[]{Double.NaN};
    private static AucROC aucROC = new AucROC();

    private static void fillSignal(double[] signal, InputStream is, int index) throws Exception {
        String line;
        BufferedReader s = new BufferedReader(new InputStreamReader(is));
        int i = 0;
        while ((line = s.readLine()) != null) {
            int idx = line.indexOf("\t");
            if (idx == -1) {
                idx = line.length();
            }
            signal[i] = Double.parseDouble(line.substring(0, idx));
            ++i;
        }
        s.close();
    }

    private static void fillFlag(boolean[] flag, InputStream is) throws Exception {
        String line;
        BufferedReader f = new BufferedReader(new InputStreamReader(is));
        int i = 0;
        while ((line = f.readLine()) != null) {
            flag[i] = line.charAt(0) == '0';
            ++i;
        }
        f.close();
    }

    private static void fillClazz(double[] signal, boolean[] flags, boolean[] clazz) {
        DoubleList d = new DoubleList();
        int j = 0;
        while (j < signal.length) {
            if (flags[j]) {
                d.add(signal[j]);
            }
            ++j;
        }
        double t = d.mean(0, d.length()) + 4.0 * d.sd(0, d.length());
        double[] clone = d.toArray();
        Arrays.sort(clone);
        if (t > clone[clone.length - 50]) {
            t = clone[clone.length - 50];
        }
        int j2 = 0;
        while (j2 < signal.length) {
            clazz[j2] = signal[j2] >= t;
            ++j2;
        }
    }

    private static double transform(double llr) {
        return global[0] * llr / (1.0 + Math.abs(global[0] * llr));
    }

    public static void main(String[] args) throws Exception {
        ZipFile classifier = new ZipFile(args[0]);
        String home = args[1];
        ZipFile training = new ZipFile(String.valueOf(home) + args[2]);
        ArrayList<ZipFile> test = new ArrayList<ZipFile>();
        int i = 3;
        while (i < args.length) {
            test.add(new ZipFile(String.valueOf(home) + args[i]));
            ++i;
        }
        double[] performance = new double[test.size() + 1];
        DataSet[] data = new DataSet[]{new DataSet(DNAAlphabetContainer.SINGLETON, new InfixStringExtractor(new SparseStringExtractor(String.valueOf(home) + "HK-seqs.txt", '#'), 0, 40)), new DataSet(DNAAlphabetContainer.SINGLETON, new InfixStringExtractor(new SparseStringExtractor(String.valueOf(home) + "ME-seqs.txt", '#'), 0, 40))};
        boolean[][] flag = new boolean[data.length][];
        double[][] signal = new double[data.length][];
        boolean[][] clazz = new boolean[data.length][];
        int i2 = 0;
        while (i2 < data.length) {
            flag[i2] = new boolean[data[i2].getNumberOfElements()];
            signal[i2] = new double[data[i2].getNumberOfElements()];
            clazz[i2] = new boolean[data[i2].getNumberOfElements()];
            ++i2;
        }
        DoubleList usedSignal = new DoubleList();
        DoubleList pred = new DoubleList();
        DoubleList pos = new DoubleList();
        DoubleList neg = new DoubleList();
        REnvironment r = new REnvironment();
        r.voidEval("s=0.01; c=seq(s,2,by=s);");
        String[] allWf = new String[]{"0.01"};
        String[] allEss = new String[]{"4.0"};
        String ess = "4.0";
        String fgOrders = "bt";
        int bgOrder = 4;
        String[] stringArray = allWf;
        int n = allWf.length;
        int n2 = 0;
        while (n2 < n) {
            String wf = stringArray[n2];
            bgOrder = 4;
            while (bgOrder <= 4) {
                r.voidEval("all=NULL;");
                DREAMTestEvaluationShort.global[0] = Double.NaN;
                Arrays.fill(performance, 0.0);
                SafeOutputStream sos = SafeOutputStream.getSafeOutputStream(new PrintStream(String.valueOf(home) + "/detail/detail-wf" + wf + "_fg" + fgOrders + "_bg" + bgOrder + "_ess" + ess + ".txt"));
                int anzStart = Double.isNaN(global[0]) ? 2 : 1;
                int start = 0;
                while (start < anzStart) {
                    Enumeration<? extends ZipEntry> d = training.entries();
                    if (!Double.isNaN(global[0])) {
                        sos.write("data set\tAUC-ROC");
                        int j = 0;
                        while (j < test.size()) {
                            String n3 = ((ZipFile)test.get(j)).getName();
                            sos.write("\t" + n3.substring(n3.lastIndexOf(92) + 1));
                            ++j;
                        }
                        sos.writeln();
                    } else {
                        sos.writeln("compute global value ");
                    }
                    int a = 0;
                    while (d.hasMoreElements()) {
                        ZipEntry f;
                        ZipEntry s;
                        int index;
                        ++a;
                        ZipEntry flags = d.nextElement();
                        ZipEntry signals = d.nextElement();
                        String name = signals.toString();
                        if (name.substring(name.indexOf("/") + 1).startsWith(".")) continue;
                        sos.write(name);
                        GenDisMixClassifier cl = null;
                        int fgOrder = 0;
                        while (fgOrder < 3) {
                            ZipEntry en = classifier.getEntry(String.valueOf(name.substring(name.indexOf("/") + 1, name.length() - 12)) + "_" + fgOrder + "_" + bgOrder + "_" + wf + "_" + ess + "-motif-0.xml");
                            if (en != null) {
                                cl = (GenDisMixClassifier)XMLParser.extractObjectForTags(FileManager.readInputStream(classifier.getInputStream(en)), "classifier");
                                break;
                            }
                            ++fgOrder;
                        }
                        int n4 = index = name.endsWith("-HK-signals.txt") ? 0 : 1;
                        if (Double.isNaN(global[0])) {
                            DREAMTestEvaluationShort.fillSignal(signal[index], training.getInputStream(signals), 0);
                            DREAMTestEvaluationShort.fillFlag(flag[index], training.getInputStream(flags));
                            DREAMTestEvaluationShort.fillClazz(signal[index], flag[index], clazz[index]);
                            usedSignal.clear();
                            pred.clear();
                            pos.clear();
                            neg.clear();
                            int i3 = 0;
                            while (i3 < flag[index].length) {
                                if (flag[index][i3]) {
                                    usedSignal.add(signal[index][i3]);
                                    double t = cl.getScore(data[index].getElementAt(i3), 0) - cl.getScore(data[index].getElementAt(i3), 1);
                                    pred.add(t);
                                    if (clazz[index][i3]) {
                                        pos.add(t);
                                    } else {
                                        neg.add(t);
                                    }
                                }
                                ++i3;
                            }
                            r.createVector("pred", pred.toArray());
                            r.createVector("signal", usedSignal.toArray());
                            r.voidEval("q=rep(NA,length(c)); for( i in 1:length(c) ) { q[i]=cor((c[i]*pred/(1+abs(c[i]*pred))),signal); }\n");
                            r.voidEval("if( is.null(all) ) { all=q; } else { all = all+q; }\n");
                            sos.write("\t" + r.eval("max=max(q,na.rm=T);").asDouble());
                            double[] posArray = pos.toArray();
                            Arrays.sort(posArray);
                            double[] negArray = neg.toArray();
                            Arrays.sort(negArray);
                            double v = (Double)aucROC.compute(posArray, negArray).getResultAt(0).getValue();
                            sos.writeln("\t" + v);
                            continue;
                        }
                        if (index == 0) {
                            s = new ZipEntry(signals.toString().replace("-HK-", "-ME-"));
                            f = new ZipEntry(flags.toString().replace("-HK-", "-ME-"));
                        } else {
                            s = new ZipEntry(signals.toString().replace("-ME-", "-HK-"));
                            f = new ZipEntry(flags.toString().replace("-ME-", "-HK-"));
                        }
                        index = 1 - index;
                        int j = 0;
                        while (j < test.size()) {
                            DREAMTestEvaluationShort.fillSignal(signal[index], ((ZipFile)test.get(j)).getInputStream(s), 0);
                            if (j == 0) {
                                DREAMTestEvaluationShort.fillFlag(flag[index], ((ZipFile)test.get(j)).getInputStream(f));
                                DREAMTestEvaluationShort.fillClazz(signal[index], flag[index], clazz[index]);
                                usedSignal.clear();
                                pred.clear();
                                pos.clear();
                                neg.clear();
                                int i4 = 0;
                                while (i4 < flag[index].length) {
                                    if (flag[index][i4]) {
                                        usedSignal.add(signal[index][i4]);
                                        double t = cl.getScore(data[index].getElementAt(i4), 0) - cl.getScore(data[index].getElementAt(i4), 1);
                                        t = DREAMTestEvaluationShort.transform(t);
                                        pred.add(t);
                                        if (clazz[index][i4]) {
                                            pos.add(t);
                                        } else {
                                            neg.add(t);
                                        }
                                    }
                                    ++i4;
                                }
                                double[] posArray = pos.toArray();
                                Arrays.sort(posArray);
                                double[] negArray = neg.toArray();
                                Arrays.sort(negArray);
                                double v = (Double)aucROC.compute(posArray, negArray).getResultAt(0).getValue();
                                performance[0] = performance[0] + v;
                                sos.write("\t" + v);
                            } else {
                                usedSignal.clear();
                                pred.clear();
                                int i5 = 0;
                                while (i5 < flag[index].length) {
                                    if (flag[index][i5]) {
                                        usedSignal.add(signal[index][i5]);
                                        double score = cl.getScore(data[index].getElementAt(i5), 0) - cl.getScore(data[index].getElementAt(i5), 1);
                                        pred.add(DREAMTestEvaluationShort.transform(score));
                                    }
                                    ++i5;
                                }
                            }
                            double v = ToolBox.pearsonCorrelation(usedSignal.toArray(), pred.toArray());
                            int n5 = j + 1;
                            performance[n5] = performance[n5] + v;
                            sos.write("\t" + v);
                            ++j;
                        }
                        sos.writeln();
                    }
                    if (Double.isNaN(global[0])) {
                        r.eval("max=max(all,na.rm=T);");
                        sos.writeln(r.eval("max").asDouble() / (double)a);
                        DREAMTestEvaluationShort.global[0] = r.eval("c[which(all==max)]").asDouble();
                        sos.writeln("a=" + a + "\narray=" + Arrays.toString(r.eval("all").asDoubles()) + "\nglobal = " + Arrays.toString(global));
                    } else {
                        sos.writeln();
                        System.out.print(String.valueOf(fgOrders) + "\t" + bgOrder + "\t" + wf + "\t" + ess + "\t" + global[0]);
                        int j = 0;
                        while (j < performance.length) {
                            System.out.print("\t" + performance[j] / (double)a);
                            ++j;
                        }
                        System.out.println();
                    }
                    ++start;
                }
                sos.close();
                ++bgOrder;
            }
            ++n2;
        }
        if (r != null) {
            r.close();
        }
    }
}

