/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.motifDiscovery.DeBruijnPFMDistance;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.PFMComparator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class MotifComp {
    public static void main(String[] args) throws Exception {
        double[][] ref = MotifComp.readJaspar(args[0]);
        int i = 0;
        while (i < ref.length) {
            Normalisation.sumNormalisation(ref[i]);
            ++i;
        }
        double[][] pred = MotifComp.readChipper(args[1]);
        int i2 = 0;
        while (i2 < pred.length) {
            Normalisation.sumNormalisation(pred[i2]);
            ++i2;
        }
        PFMComparator.NormalizedEuclideanDistance dist = new PFMComparator.NormalizedEuclideanDistance();
        int overlap = Math.min(7, Math.min(ref.length - 2, pred.length - 2));
        double val1 = dist.compare(ref, pred, overlap);
        double val2 = dist.compare(PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, ref), pred, overlap);
        System.out.println(String.valueOf(val1) + " " + val2);
        System.out.println(String.valueOf(ref.length) + " , " + pred.length);
        DeBruijnPFMDistance dbd = new DeBruijnPFMDistance(10);
        val1 = dbd.compare(ref, pred, overlap);
        val2 = dbd.compare(PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, ref), pred, overlap);
        System.out.println(String.valueOf(val1) + " " + val2);
    }

    private static double[][] readTransfac(String path) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(path));
        String str = null;
        ArrayList<double[]> list = new ArrayList<double[]>();
        read.readLine();
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\\s+");
            double[] vals = new double[4];
            int j = 0;
            while (j < vals.length) {
                vals[j] = Double.parseDouble(parts[j + 1]);
                ++j;
            }
            PFMComparator.normalize(vals);
            list.add(vals);
        }
        return (double[][])list.toArray((T[])new double[0][0]);
    }

    private static double[][] readChipper(String path) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(path));
        String str = null;
        ArrayList<double[]> list = new ArrayList<double[]>();
        while ((str = read.readLine()) != null) {
            str = str.substring(1, str.length() - 1);
            String[] parts = str.split("\\, ");
            double[] vals = new double[parts.length];
            int j = 0;
            while (j < parts.length) {
                vals[j] = Double.parseDouble(parts[j]);
                ++j;
            }
            list.add(vals);
        }
        return (double[][])list.toArray((T[])new double[0][0]);
    }

    private static double[][] readJaspar(String path) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(path));
        String str = null;
        ArrayList<double[]> list = new ArrayList<double[]>();
        int i = 0;
        while ((str = read.readLine()) != null) {
            if (str.contains("[")) {
                str = str.substring(str.indexOf("[") + 1, str.lastIndexOf("]"));
            }
            str = str.trim();
            String[] parts = str.split("\\s+");
            int j = 0;
            while (j < parts.length) {
                double[] vals;
                if (i == 0) {
                    vals = new double[4];
                    vals[0] = Double.parseDouble(parts[j]);
                    list.add(vals);
                } else {
                    vals = (double[])list.get(j);
                    vals[i] = Double.parseDouble(parts[j]);
                }
                ++j;
            }
            ++i;
        }
        read.close();
        return (double[][])list.toArray((T[])new double[0][0]);
    }
}

