/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.DifferentiableHigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.NumericalHMMTrainingParameterSet;
import de.jstacs.utils.ToolBox;
import java.io.File;
import java.util.Arrays;

public class TrainCoProHMM {
    public static void main(String[] args) throws Exception {
        System.out.println(Arrays.toString(args));
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int parOff = 0;
        String home = args[parOff++];
        HMMFactory.HMMType hmmType = HMMFactory.HMMType.valueOf(args[parOff++]);
        boolean likelihood = Boolean.parseBoolean(args[parOff++]);
        int order = Integer.parseInt(args[parOff++]);
        int numLayers = Integer.parseInt(args[parOff++]);
        double ess = Double.parseDouble(args[parOff++]);
        int threads = Integer.parseInt(args[parOff++]);
        int offLeft = Integer.parseInt(args[parOff++]);
        int offRight = Integer.parseInt(args[parOff++]);
        int sequenceLength = Integer.parseInt(args[parOff++]);
        String outfile = args[parOff++];
        boolean weighteq = false;
        boolean weighted = Boolean.parseBoolean(args[parOff++]);
        boolean deleteEnd = Boolean.parseBoolean(args[parOff++]);
        DataSet[] data = new DataSet[args.length - parOff];
        double[][] seqWeights = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            data[i] = new DNADataSet(String.valueOf(home) + File.separatorChar + args[parOff + i], '>', new ReferenceSequenceAnnotationParser("seq", con, ":", ";"));
            Sequence[] seqs = data[i].getAllElements();
            int j = 0;
            while (j < seqs.length) {
                Sequence temp = seqs[j];
                SequenceAnnotation an = temp.getSequenceAnnotationByType("w", 0);
                SequenceAnnotation an2 = temp.getSequenceAnnotationByType("height", 0);
                if (offLeft > 0 || offRight > 0 || sequenceLength > 0) {
                    temp = seqs[j].getSubSequence(offLeft, sequenceLength > 0 ? sequenceLength : seqs[j].getLength() - offLeft - offRight);
                }
                seqs[j] = temp = temp.annotate(false, seqs[j].getSequenceAnnotationByType("reference", 0));
                if (weighted && an != null) {
                    if (seqWeights[i] == null) {
                        seqWeights[i] = new double[seqs.length];
                    }
                    seqWeights[i][j] = an2 != null ? Double.parseDouble(an.getIdentifier()) * Double.parseDouble(an2.getIdentifier()) : Double.parseDouble(an.getIdentifier());
                }
                ++j;
            }
            data[i] = new DataSet("", seqs);
            ++i;
        }
        if (seqWeights[0] == null) {
            seqWeights[0] = new double[data[0].getNumberOfElements()];
            Arrays.fill(seqWeights[0], 1.0);
        }
        double fgWeight = ToolBox.sum(seqWeights[0]);
        System.out.println(String.valueOf(seqWeights[0].length) + " " + fgWeight + " " + ToolBox.min(seqWeights[0]) + " " + ToolBox.max(seqWeights[0]));
        int i2 = 1;
        while (i2 < data.length) {
            seqWeights[i2] = new double[data[i2].getNumberOfElements()];
            Arrays.fill(seqWeights[i2], weighteq ? fgWeight / (double)seqWeights[i2].length : 1.0);
            ++i2;
        }
        int numClasses = data.length;
        DifferentiableStatisticalModel[] sfs = new DifferentiableStatisticalModel[numClasses];
        NumericalHMMTrainingParameterSet trainingParameterSet = new NumericalHMMTrainingParameterSet(1, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), threads, 20, 1.0E-6, 1.0);
        double[][] condInitProbs = new double[(int)con.getAlphabetLengthAt(0)][(int)con.getAlphabetLengthAt(0)];
        int i3 = 0;
        while (i3 < condInitProbs.length) {
            int j = 0;
            while (j < condInitProbs[i3].length) {
                condInitProbs[i3][j] = i3 == condInitProbs[i3].length - j - 1 ? 0.7 / con.getAlphabetLengthAt(0) : 0.1 / con.getAlphabetLengthAt(0);
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < sfs.length - 1) {
            sfs[i3] = (DifferentiableHigherOrderHMM)HMMFactory.createProfileHMM((MaxHMMTrainingParameterSet)trainingParameterSet, hmmType, likelihood, order, numLayers, (AlphabetContainer)con, ess, true, false, condInitProbs, deleteEnd ? ess / 10.0 : Double.NaN, false);
            ++i3;
        }
        sfs[sfs.length - 1] = new HomogeneousMMDiffSM(con, 1, ess, numLayers);
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(con, 0, 20, 1.0E-8, 1.0E-8, 1.0E-4, true, OptimizableFunction.KindOfParameter.PLUGIN, false, threads);
        GenDisMixClassifier gdm = new GenDisMixClassifier(params, (LogPrior)new CompositeLogPrior(), LearningPrinciple.MSP, sfs);
        gdm.train(data, seqWeights);
        FileManager.writeFile(new File(String.valueOf(home) + File.separator + outfile), (CharSequence)gdm.toXML());
        System.out.println(gdm);
    }

    private static double[][] getInitFromTo(HMMFactory.HMMType type, double ess) {
        double[][] initFromTo = new double[3][];
        if (type == HMMFactory.HMMType.PLAN9) {
            initFromTo[0] = new double[]{Double.NaN, ess / 10.0, Double.NaN, ess / 10.0, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[1] = (double[])initFromTo[0].clone();
            initFromTo[2] = (double[])initFromTo[1].clone();
        } else if (type == HMMFactory.HMMType.PLAN7) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 5.0, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 5.0, Double.NaN, Double.NaN, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 10.0, Double.NaN, ess / 10.0, Double.NaN, 8.0 * ess / 10.0};
        } else if (type == HMMFactory.HMMType.PLAN8I) {
            initFromTo[0] = new double[]{Double.NaN, ess / 10.0, Double.NaN, ess / 10.0, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 5.0, Double.NaN, Double.NaN, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 10.0, Double.NaN, ess / 10.0, Double.NaN, 8.0 * ess / 10.0};
        } else if (type == HMMFactory.HMMType.PLAN8D) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 5.0, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 10.0, Double.NaN, ess / 10.0, Double.NaN, 8.0 * ess / 10.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 10.0, Double.NaN, ess / 10.0, Double.NaN, 8.0 * ess / 10.0};
        }
        return initFromTo;
    }
}

